/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SourceEditorTextHandler;

public class SelectNextWordHandler
extends SourceEditorTextHandler {
    public SelectNextWordHandler(ISourceEditor editor) {
        super(editor);
    }

    @Override
    protected int getTextActionId() {
        return 17170436;
    }

    @Override
    protected void exec(SourceEditorTextHandler.ExecData data) throws BadLocationException {
        if (data.getWidget().getBlockSelection()) {
            BlockTextSelection blockSelection = (BlockTextSelection)data.getViewer().getSelection();
            if (blockSelection.getStartColumn() != data.getCaretColumn() && blockSelection.getEndColumn() != data.getCaretColumn() || data.getCaretDocOffset() == data.getCaretDocLineEndOffset()) {
                super.exec(data);
                return;
            }
            int newDocOffset = blockSelection.getStartColumn() > data.getCaretDocLineInformation().getLength() ? data.getCaretDocLineEndOffset() : this.findNextWordOffset(data, data.getCaretDocOffset(), true);
            int newWidgetOffset = data.toWidgetOffset(newDocOffset);
            this.expandBlockSelection(data, newWidgetOffset);
        } else {
            int newDocOffset = this.findNextWordOffset(data, data.getCaretDocOffset(), false);
            if (data.toWidgetOffset(newDocOffset) >= 0) {
                this.expandDocSelection(data, newDocOffset);
            } else {
                data.getWidget().invokeAction(16908292);
            }
        }
    }
}

