/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.internal.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRLineBreakpoint;

public abstract class RGenericLineBreakpoint
extends RBreakpoint
implements IRLineBreakpoint {
    public static final String ELEMENT_TYPE_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ElementTypeAttribute";
    public static final String ELEMENT_ID_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ElementIdAttribute";
    public static final String ELEMENT_LABEL_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ElementLabelAttribute";
    public static final String SUB_LABEL_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.SubLabelAttribute";
    public static final String CONDITION_ENABLED_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ConditionEnabledAttribute";
    public static final String CONDITION_EXPR_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ConditionExprAttribute";
    private static final String[] POSITION_ATTRIBUTES = new String[]{"lineNumber", "charStart", "charEnd"};
    private static final String[] ELEMENT_ATTRIBUTES = new String[]{"org.eclipse.statet.r.resourceMarkers.ElementTypeAttribute", "org.eclipse.statet.r.resourceMarkers.ElementIdAttribute", "org.eclipse.statet.r.resourceMarkers.ElementLabelAttribute"};
    private final AtomicReference<CachedData> cachedData = new AtomicReference();

    public static void updatePosition(IMarker marker, int lineNumber, int charStart, int charEnd) throws CoreException {
        if (lineNumber != marker.getAttribute("lineNumber", -1) || charStart != marker.getAttribute("charStart", -1) || charEnd != marker.getAttribute("charEnd", -1)) {
            marker.setAttributes(POSITION_ATTRIBUTES, new Object[]{lineNumber, charStart, charEnd});
        }
    }

    public static void updateElementInfo(IMarker marker, int elementType, String elementId, String elementLabel, String subLabel) throws CoreException {
        if (elementType != marker.getAttribute(ELEMENT_TYPE_MARKER_ATTR, -1) || !(elementId != null ? elementId.equals(marker.getAttribute(ELEMENT_ID_MARKER_ATTR, null)) : marker.getAttribute(ELEMENT_ID_MARKER_ATTR, null) == null) || (elementLabel != null ? !elementLabel.equals(marker.getAttribute(ELEMENT_LABEL_MARKER_ATTR, null)) : marker.getAttribute(ELEMENT_LABEL_MARKER_ATTR, null) != null)) {
            marker.setAttributes(ELEMENT_ATTRIBUTES, new Object[]{elementType, elementId, elementLabel});
        }
        if (subLabel != null ? !subLabel.equals(marker.getAttribute(SUB_LABEL_MARKER_ATTR, null)) : marker.getAttribute(SUB_LABEL_MARKER_ATTR, null) != null) {
            marker.setAttribute(SUB_LABEL_MARKER_ATTR, (Object)subLabel);
        }
    }

    protected RGenericLineBreakpoint() {
    }

    protected void addStandardLineBreakpointAttributes(Map<String, Object> attributes, boolean enabled, int lineNumber, int charStart, int charEnd, int elementType, String elementId, String elementLabel, String subLabel) {
        attributes.put("org.eclipse.debug.core.id", this.getModelIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
        attributes.put(ELEMENT_TYPE_MARKER_ATTR, new Integer(elementType));
        if (elementId != null) {
            attributes.put(ELEMENT_ID_MARKER_ATTR, elementId);
        }
        if (elementLabel != null) {
            attributes.put(ELEMENT_LABEL_MARKER_ATTR, elementLabel);
        }
        if (subLabel != null) {
            attributes.put(SUB_LABEL_MARKER_ATTR, elementLabel);
        }
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    @Override
    public int getElementType() throws CoreException {
        return this.ensureMarker().getAttribute(ELEMENT_TYPE_MARKER_ATTR, -1);
    }

    public String getElementId() throws CoreException {
        return this.ensureMarker().getAttribute(ELEMENT_ID_MARKER_ATTR, null);
    }

    @Override
    public String getElementLabel() throws CoreException {
        return this.ensureMarker().getAttribute(ELEMENT_LABEL_MARKER_ATTR, null);
    }

    @Override
    public String getSubLabel() throws CoreException {
        return this.ensureMarker().getAttribute(SUB_LABEL_MARKER_ATTR, null);
    }

    @Override
    public void setConditionEnabled(boolean enabled) throws CoreException {
        this.ensureMarker().setAttribute(CONDITION_ENABLED_MARKER_ATTR, enabled);
    }

    @Override
    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED_MARKER_ATTR, false);
    }

    @Override
    public void setConditionExpr(String code) throws CoreException {
        IMarker marker = this.ensureMarker();
        if (code != null && code.trim().length() > 0) {
            marker.setAttribute(CONDITION_EXPR_MARKER_ATTR, (Object)code);
        } else {
            if (marker.getAttribute(CONDITION_EXPR_MARKER_ATTR, null) != null) {
                marker.setAttribute(CONDITION_ENABLED_MARKER_ATTR, false);
            }
            this.ensureMarker().setAttribute(CONDITION_EXPR_MARKER_ATTR, null);
        }
    }

    @Override
    public String getConditionExpr() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_EXPR_MARKER_ATTR, "");
    }

    public void setCachedData(CachedData data) {
        if (this.checkTimestamp(data)) {
            this.cachedData.set(data);
        }
    }

    public CachedData getCachedData() {
        CachedData cachedData = this.cachedData.get();
        if (cachedData != null && !this.checkTimestamp(cachedData)) {
            this.cachedData.compareAndSet(cachedData, null);
        }
        return cachedData;
    }

    private boolean checkTimestamp(CachedData data) {
        IResource resource;
        IMarker marker = this.getMarker();
        if (marker != null && (resource = marker.getResource()) != null) {
            return data.getStamp() == resource.getModificationStamp();
        }
        return false;
    }

    public static class CachedData {
        private final long stamp;
        private final String elementId;
        private final int[] rExpressionIndex;

        public CachedData(long stamp, String elementId, int[] rExpressionIndex) {
            this.stamp = stamp;
            this.elementId = elementId;
            this.rExpressionIndex = rExpressionIndex;
        }

        public long getStamp() {
            return this.stamp;
        }

        public String getElementId() {
            return this.elementId;
        }

        public int[] getRExpressionIndex() {
            return this.rExpressionIndex;
        }
    }
}

