/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.Objects;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IIndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.internal.r.debug.core.model.IRIndexElementValue;
import org.eclipse.statet.internal.r.debug.core.model.IRIndexValueInternal;
import org.eclipse.statet.internal.r.debug.core.model.RArrayDimVariable;
import org.eclipse.statet.internal.r.debug.core.model.RArrayIndexVariable;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.internal.r.debug.core.model.RElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.r.core.data.RValueValidator;
import org.eclipse.statet.r.debug.core.IRVariable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RArrayAsVectorDataAdapter;
import org.eclipse.statet.rj.services.util.dataaccess.RDataAssignment;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class RArrayValue
extends RElementVariableValue<CombinedRElement>
implements IRIndexValueInternal {
    private static final RArrayAsVectorDataAdapter ADAPTER = new RArrayAsVectorDataAdapter();
    final long length;
    final RIntegerStore dim;
    final int dimCount;
    private @Nullable LazyRStore<RVector<?>> dimNameStore;
    private @Nullable LazyRStore<RVector<?>>[] dimItemNameStore;
    private @Nullable LazyRStore<RVector<?>> dataStore;

    public RArrayValue(RElementVariable variable) {
        super(variable);
        RArray<?> element = this.getRObject();
        this.length = element.getLength();
        this.dim = element.getDim();
        this.dimCount = (int)this.dim.getLength();
    }

    public final RArray<?> getRObject() {
        return (RArray)this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasValueChanged(int[] dimIndex) throws DebugException {
        LazyRStore.Fragment<RVector<?>> currentFragment;
        LazyRStore.Fragment<RVector<?>> previousFragment;
        RArrayValue previousValue;
        RElementVariable rElementVariable = this.variable;
        synchronized (rElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return false;
            }
            previousValue = (RArrayValue)this.variable.getPreviousValue();
        }
        if (previousValue == null) return false;
        int i = 0;
        while (i < this.dimCount) {
            if (dimIndex[i] >= previousValue.dim.getInt(i)) {
                return true;
            }
            ++i;
        }
        long previousIdx = RDataUtils.getDataIdx((RStore)previousValue.dim, (int[])dimIndex);
        long currentIdx = RDataUtils.getDataIdx((RStore)this.dim, (int[])dimIndex);
        RArrayValue rArrayValue = previousValue;
        synchronized (rArrayValue) {
            previousFragment = previousValue.getLoadedDataFragment(previousIdx);
            if (previousFragment == null) return false;
            if (previousFragment.getRObject() == null) {
                return false;
            }
        }
        rArrayValue = this;
        synchronized (rArrayValue) {
            currentFragment = this.getDataFragment(currentIdx);
            if (currentFragment == null) return false;
            if (currentFragment.getRObject() == null) {
                return false;
            }
        }
        if (!Objects.equals(((RVector)currentFragment.getRObject()).getData().get(currentFragment.toLocalRowIdx(currentIdx)), ((RVector)previousFragment.getRObject()).getData().get(previousFragment.toLocalRowIdx(previousIdx)))) return true;
        return false;
    }

    @Override
    public String getValueString() throws DebugException {
        String dimName;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (this.dimCount > 0) {
            sb.append(this.dim.getInt(0));
            int i = 1;
            while (i < this.dimCount) {
                sb.append('\u00d7');
                sb.append(this.dim.getInt(i));
                ++i;
            }
        }
        sb.append(']');
        if (this.dimCount > 0 && (dimName = this.getDimName(this.dimCount - 1)) != null) {
            sb.append(" / ");
            sb.append(dimName);
        }
        return sb.toString();
    }

    @Override
    public String getDetailString() {
        return "";
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return this.length > 0L && this.dim.getInt(this.dimCount - 1) > 0;
    }

    @Override
    public @NonNull IVariable[] getVariables() throws DebugException {
        return this.getPartitionFactory().getVariables((IIndexedValue)this);
    }

    @Override
    public final VariablePartitionFactory<IRIndexElementValue> getPartitionFactory() {
        return RElementValue.PARTITION_FACTORY;
    }

    public long getSize() throws DebugException {
        return this.length > 0L ? this.dim.getInt(this.dimCount - 1) : 0;
    }

    public @NonNull IRVariable[] getVariables(long offset, int length) {
        return this.getVariables(offset, length, this.variable);
    }

    @Override
    public @NonNull IRVariable[] getVariables(long offset, int length, IRVariable parent) {
        int n = this.dim.getInt(this.dimCount - 1);
        if (n <= 0) {
            throw new UnsupportedOperationException();
        }
        if (offset < 0L || length < 0 || offset > (long)(n - length)) {
            throw new IllegalArgumentException();
        }
        int o = (int)offset;
        @NonNull IRVariable[] variables = new IRVariable[length];
        if (this.dimCount == 1) {
            int i = 0;
            while (i < length) {
                int[] d = new int[]{o + i};
                variables[i] = new RArrayIndexVariable(this, d, parent);
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                int[] d = new int[]{o + i};
                variables[i] = new RArrayDimVariable(this, d, parent);
                ++i;
            }
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable String getDimName(int dimIdx) {
        RValueFormatter formatter;
        LazyRStore.Fragment<RVector<?>> fragment;
        RElementVariable rElementVariable = this.variable;
        synchronized (rElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return null;
            }
        }
        RArrayValue rArrayValue = this;
        synchronized (rArrayValue) {
            fragment = this.getDimNameFragment(dimIdx);
            if (fragment == null || fragment.getRObject() == null) {
                return null;
            }
        }
        RValueFormatter rValueFormatter = formatter = ((RDebugTarget)this.getDebugTarget()).getValueFormatter();
        synchronized (rValueFormatter) {
            return formatter.formatName(((RVector)fragment.getRObject()).getData(), (int)fragment.toLocalRowIdx((long)dimIdx));
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getDimNameFragment(int dimIdx) {
        if (this.dimNameStore == null) {
            this.dimNameStore = new LazyRStore((long)this.dimCount, 1L, 100, (LazyRStore.Updater)new RElementVariableValue.RDataLoader<RVector<?>>(this){

                @Override
                protected RVector<?> doLoad(FQRObjectRef ref, LazyRStore.Fragment<RVector<?>> fragment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    return ADAPTER.loadDimNames(ref, RArrayValue.this.getRObject(), fragment, (RService)r, m);
                }
            });
        }
        return this.dimNameStore.getFragment((long)dimIdx, 0L, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable String getDimItemName(int dimIdx, int idx) {
        RValueFormatter formatter;
        LazyRStore.Fragment<RVector<?>> fragment;
        RElementVariable rElementVariable = this.variable;
        synchronized (rElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return null;
            }
        }
        RArrayValue rArrayValue = this;
        synchronized (rArrayValue) {
            fragment = this.getDimItemNamesFragment(dimIdx, idx);
            if (fragment == null || fragment.getRObject() == null) {
                return null;
            }
        }
        RValueFormatter rValueFormatter = formatter = ((RDebugTarget)this.getDebugTarget()).getValueFormatter();
        synchronized (rValueFormatter) {
            return formatter.formatName(((RVector)fragment.getRObject()).getData(), (int)fragment.toLocalRowIdx((long)idx));
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getDimItemNamesFragment(final int dimIdx, int idx) {
        if (this.dimItemNameStore == null) {
            this.dimItemNameStore = new LazyRStore[this.dimCount];
        }
        if (this.dimItemNameStore[dimIdx] == null) {
            this.dimItemNameStore[dimIdx] = new LazyRStore((long)this.dim.get(dimIdx).intValue(), 1L, 100, (LazyRStore.Updater)new RElementVariableValue.RDataLoader<RVector<?>>(this){

                @Override
                protected RVector<?> doLoad(FQRObjectRef ref, LazyRStore.Fragment<RVector<?>> fragment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    return ADAPTER.loadDimItemNames(ref, RArrayValue.this.getRObject(), dimIdx, fragment, (RService)r, m);
                }
            });
        }
        return this.dimItemNameStore[dimIdx].getFragment((long)idx, 0L, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final @Nullable RStore<?> getValueType() {
        RStore data = this.element.getData();
        if (data.getStoreType() == 10) {
            RArrayValue rArrayValue = this;
            synchronized (rArrayValue) {
                LazyRStore.Fragment<RVector<?>> fragment;
                block5: {
                    fragment = this.getDataFragmentAny();
                    if (fragment != null && fragment.getRObject() != null) break block5;
                    return null;
                }
                data = ((RVector)fragment.getRObject()).getData();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable String getDataExpr(int[] dimIndex) {
        RValueFormatter formatter;
        LazyRStore.Fragment<RVector<?>> fragment;
        RElementVariable rElementVariable = this.variable;
        synchronized (rElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return null;
            }
        }
        long idx = RDataUtils.getDataIdx((RStore)this.dim, (int[])dimIndex);
        RArrayValue rArrayValue = this;
        synchronized (rArrayValue) {
            fragment = this.getDataFragment(idx);
            if (fragment == null || fragment.getRObject() == null) {
                return null;
            }
        }
        RValueFormatter rValueFormatter = formatter = ((RDebugTarget)this.getDebugTarget()).getValueFormatter();
        synchronized (rValueFormatter) {
            return formatter.format(((RVector)fragment.getRObject()).getData(), (int)fragment.toLocalRowIdx(idx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean validateDataExpr(String expression) {
        RValueValidator validator;
        RElementVariable rElementVariable = this.variable;
        synchronized (rElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                return false;
            }
        }
        RStore<?> type = this.getValueType();
        RValueValidator rValueValidator = validator = ((RDebugTarget)this.getDebugTarget()).getValueValidator();
        synchronized (rValueValidator) {
            return validator.isValid(type, expression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDataExpr(int[] dimIndex, String expression) throws DebugException {
        RStore data;
        RValueValidator validator;
        RElementVariable rElementVariable = this.variable;
        synchronized (rElementVariable) {
            if (this != this.variable.getCurrentValue()) {
                throw this.newRequestSetDataFailed();
            }
        }
        RStore<?> type = this.getValueType();
        RValueValidator rValueValidator = validator = ((RDebugTarget)this.getDebugTarget()).getValueValidator();
        synchronized (rValueValidator) {
            data = validator.toRData(type, expression);
        }
        if (data == null) {
            throw this.newNotSupported();
        }
        long idx = RDataUtils.getDataIdx((RStore)this.dim, (int[])dimIndex);
        RDataAssignment assignment = new RDataAssignment(idx, 0L, data);
        RArrayValue rArrayValue = this;
        synchronized (rArrayValue) {
            this.setData(assignment);
        }
    }

    private LazyRStore<RVector<?>> ensureDataStore() {
        if (this.dataStore == null) {
            int fragmentSize = this.estimateFragmentSize();
            this.dataStore = new LazyRStore(this.length, 1L, (int)Math.ceil(250000.0 / (double)fragmentSize), fragmentSize, (LazyRStore.Updater)new RElementVariableValue.RDataLoader<RVector<?>>(this){

                @Override
                protected void doSet(FQRObjectRef ref, RDataAssignment assignment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    ADAPTER.setData(ref, RArrayValue.this.getRObject(), assignment, null, (RService)r, m);
                }

                @Override
                protected RVector<?> doLoad(FQRObjectRef ref, LazyRStore.Fragment<RVector<?>> fragment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                    return (RVector)ADAPTER.loadData(ref, RArrayValue.this.getRObject(), fragment, null, (RService)r, m);
                }
            });
        }
        return this.dataStore;
    }

    /*
     * Unable to fully structure code
     */
    private int estimateFragmentSize() {
        block3: {
            if (this.dimCount <= 1) {
                return 2500;
            }
            size = this.dim.getInt(this.dim.getLength() - 1L);
            if (size <= 2500) ** GOTO lbl11
            do {
                if (size % 2 == 0) continue;
                return 2500;
            } while ((size /= 2) > 2500);
            break block3;
lbl-1000:
            // 1 sources

            {
                size *= 2;
lbl11:
                // 2 sources

                ** while (size <= 1250)
            }
        }
        return size;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getDataFragment(long idx) {
        return this.ensureDataStore().getFragment(idx, 0L, 0, null);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getDataFragmentAny() {
        LazyRStore<RVector<?>> dataStore = this.ensureDataStore();
        LazyRStore.Fragment fragment = dataStore.getLoadedFragmentAny();
        if (fragment == null) {
            fragment = dataStore.getLoadedFragment(0L, 0L);
        }
        return fragment;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<RVector<?>> getLoadedDataFragment(long idx) {
        return this.dataStore != null ? this.dataStore.getLoadedFragment(idx, 0L) : null;
    }

    public void setData(RDataAssignment assignment) {
        this.ensureDataStore().set(assignment, 0, null);
        this.variable.fireChangeEvent(512);
    }
}

