/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.docmlet.tex.core.parser.LtxLexer;
import org.eclipse.statet.ecommons.collections.IntArrayMap;
import org.eclipse.statet.ecommons.text.core.input.DocumentParserInput;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.jcommons.string.CharArrayString;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;

public class LtxDefaultTextStyleScanner
extends DocumentParserInput
implements ITokenScanner {
    private final LtxLexer lexer = this.createLexer();
    private final IToken[] tokens;
    private final TextStyleManager textStyles;
    private final IToken defaultToken;
    private IToken nextToken;
    private final Map<CharArrayString, IToken> specialWords;
    private int currentOffset;
    private int currentLength;
    private static final CharArrayString[] SECTION_WORDS = new CharArrayString[]{new CharArrayString("part"), new CharArrayString("chapter"), new CharArrayString("section"), new CharArrayString("subsection"), new CharArrayString("subsubsection")};

    protected static void putAll(Map<String, IToken> map, String[] symbols, IToken token) {
        int i = 0;
        while (i < symbols.length) {
            map.put(symbols[i], token);
            ++i;
        }
    }

    public LtxDefaultTextStyleScanner(TextStyleManager textStyles) {
        this.lexer.setReportAsterisk(false);
        this.textStyles = textStyles;
        IntArrayMap tokens = new IntArrayMap();
        this.registerTokens((IntArrayMap<IToken>)tokens);
        this.defaultToken = (IToken)tokens.get(3);
        this.tokens = (IToken[])tokens.toArray(IToken.class);
        this.specialWords = new HashMap<CharArrayString, IToken>();
        this.updateWords(this.specialWords);
    }

    protected LtxLexer createLexer() {
        return new LtxLexer();
    }

    protected IToken getToken(String key) {
        return this.textStyles.getToken(key);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.reset(document);
        this.init(offset, offset + length);
        this.lexer.reset((TextParserInput)this);
        this.currentOffset = offset;
        this.currentLength = 0;
    }

    public IToken nextToken() {
        this.currentOffset += this.currentLength;
        IToken token = this.nextToken;
        if (token != null) {
            this.nextToken = null;
        } else {
            while ((token = this.getTokenFromScannerToken(this.lexer.next())) == this.defaultToken) {
            }
        }
        this.currentLength = this.lexer.getOffset() - this.currentOffset;
        if (this.currentLength != 0) {
            this.nextToken = token;
            return this.defaultToken;
        }
        this.currentLength = this.lexer.getLength();
        return token;
    }

    protected IToken getTokenFromScannerToken(int lexerToken) {
        switch (lexerToken) {
            case -1: {
                return Token.EOF;
            }
            case 5: {
                IToken token;
                CharArrayString label = this.getTmpString(1, this.lexer.getLength());
                if (label.length() > 0 && (token = this.specialWords.get(label)) != null) {
                    return token;
                }
                return this.tokens[5];
            }
        }
        IToken token = this.tokens[lexerToken];
        if (token != null) {
            return token;
        }
        return this.defaultToken;
    }

    public int getTokenOffset() {
        return this.currentOffset;
    }

    public int getTokenLength() {
        return this.currentLength;
    }

    protected void registerTokens(IntArrayMap<IToken> map) {
        map.put(3, (Object)this.getToken("tex_ts_Default"));
        map.put(5, (Object)this.getToken("tex_ts_ControlWord"));
        map.put(6, (Object)this.getToken("tex_ts_ControlChar"));
        map.put(4, (Object)this.getToken("tex_ts_ControlWord"));
        map.put(9, (Object)this.getToken("tex_ts_CurlyBracket"));
        map.put(10, (Object)this.getToken("tex_ts_CurlyBracket"));
        map.put(11, (Object)this.getToken("tex_ts_CurlyBracket"));
        map.put(12, (Object)this.getToken("tex_ts_CurlyBracket"));
        map.put(16, (Object)this.getToken("tex_ts_Comment"));
        map.put(17, (Object)this.getToken("tex_ts_Verbatim"));
    }

    protected void updateWords(Map<CharArrayString, IToken> map) {
        IToken sectioningToken = this.getToken("tex_ts_ControlWord.Sectioning");
        int i = 0;
        while (i < SECTION_WORDS.length) {
            map.put(SECTION_WORDS[i], sectioningToken);
            ++i;
        }
    }
}

