/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class SelectionTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private final ISelectionProvider fSelectionProvider;

    public SelectionTransferDragAdapter(ISelectionProvider selectionProvider) {
        assert (selectionProvider != null);
        this.fSelectionProvider = selectionProvider;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getTransfer();
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fSelectionProvider.getSelection();
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        transfer.setSelection(selection);
        transfer.setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
        if (selection.isEmpty()) {
            event.doit = false;
            return;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = LocalSelectionTransfer.getTransfer().getSelection();
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        transfer.setSelection(null);
        transfer.setSelectionSetTime(0L);
    }
}

