/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstVisitor;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikitextEditingSettings;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.ui.sourceediting.folding.AbstractFoldingPosition;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingAnnotation;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingProvider;
import org.eclipse.statet.ltk.ui.sourceediting.folding.NodeFoldingProvider;
import org.eclipse.statet.ltk.ui.sourceediting.folding.SimpleFoldingPosition;

public class WikidocDefaultFoldingProvider
implements FoldingProvider {
    private static final String TYPE_SECTION = "org.eclipse.statet.docmlet.wikitext.Section";
    private static final String TYPE_EMBEDDED = "org.eclipse.statet.docmlet.wikitext.Embedded";
    private FoldingConfiguration config;
    private final Map<String, ? extends NodeFoldingProvider> embeddedProviders;

    public WikidocDefaultFoldingProvider() {
        this.embeddedProviders = Collections.emptyMap();
    }

    public WikidocDefaultFoldingProvider(Map<String, ? extends NodeFoldingProvider> embeddedProviders) {
        this.embeddedProviders = embeddedProviders;
    }

    public boolean checkConfig(Set<String> groupIds) {
        boolean changed = false;
        if (groupIds == null || groupIds.contains("Wikitext/editor/folding.shared")) {
            FoldingConfiguration foldingConfiguration = new FoldingConfiguration();
            PreferenceAccess prefs = PreferenceUtils.getInstancePrefs();
            foldingConfiguration.isRestoreStateEnabled = (Boolean)prefs.getPreferenceValue((Preference)WikitextEditingSettings.FOLDING_RESTORE_STATE_ENABLED_PREF);
            foldingConfiguration.minLines = 2;
            this.config = foldingConfiguration;
            changed |= true;
        }
        for (NodeFoldingProvider nodeFoldingProvider : this.embeddedProviders.values()) {
            changed |= nodeFoldingProvider.checkConfig(groupIds);
        }
        return changed;
    }

    public boolean isRestoreStateEnabled() {
        return this.config.isRestoreStateEnabled;
    }

    public boolean requiresModel() {
        return true;
    }

    public void collectRegions(FoldingEditorAddon.FoldingStructureComputationContext ctx) throws InvocationTargetException {
        try {
            ElementFinder elementFinder = new ElementFinder(ctx, this.config, this.embeddedProviders);
            elementFinder.visit(ctx.model.getSourceElement());
        }
        catch (RuntimeException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static class ElementFinder
    extends WikitextAstVisitor {
        private final FoldingEditorAddon.FoldingStructureComputationContext context;
        private final FoldingConfiguration config;
        private final NodeFoldingProvider.VisitorMap embeddedVisitors;

        public ElementFinder(FoldingEditorAddon.FoldingStructureComputationContext ctx, FoldingConfiguration config, Map<String, ? extends NodeFoldingProvider> embeddedProviders) {
            this.context = ctx;
            this.config = config;
            this.embeddedVisitors = !embeddedProviders.isEmpty() ? new NodeFoldingProvider.VisitorMap(embeddedProviders) : null;
        }

        public void visit(SourceStructElement element) throws InvocationTargetException {
            if (element.getModelTypeId() == "Wikidoc") {
                if ((element.getElementType() & 0xF00) == 2048) {
                    Embedded embedded;
                    AstVisitor visitor;
                    AstNode node;
                    TextRegion region = element.getSourceRange();
                    this.createEmbeddedRegion(region.getStartOffset(), region.getEndOffset());
                    if (this.embeddedVisitors != null && (node = (AstNode)element.getAdapter(AstNode.class)) instanceof Embedded && (visitor = this.embeddedVisitors.get((Object)(embedded = (Embedded)node).getForeignTypeId())) != null) {
                        visitor.visit(embedded.getForeignNode());
                    }
                    return;
                }
                if ((element.getElementType() & 0xFF0) == 1056) {
                    TextRegion region = element.getSourceRange();
                    this.createSectionRegion(region.getStartOffset(), region.getEndOffset());
                }
            }
            List children = element.getSourceChildren(null);
            for (SourceStructElement child : children) {
                this.visit(child);
            }
        }

        private void createSectionRegion(int startOffset, int endOffset) throws InvocationTargetException {
            try {
                AbstractDocument doc = this.context.document;
                int startLine = doc.getLineOfOffset(startOffset);
                int stopLine = doc.getLineOfOffset(endOffset);
                IRegion stopLineInfo = doc.getLineInformation(stopLine);
                if (stopLineInfo.getOffset() + stopLineInfo.getLength() > endOffset) {
                    --stopLine;
                }
                if (stopLine - startLine + 1 >= this.config.minLines) {
                    int offset = doc.getLineOffset(startLine);
                    this.context.addFoldingRegion(new FoldingAnnotation(WikidocDefaultFoldingProvider.TYPE_SECTION, false, (AbstractFoldingPosition)new SimpleFoldingPosition(offset, doc.getLineOffset(stopLine) + doc.getLineLength(stopLine) - offset)));
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private void createEmbeddedRegion(int startOffset, int endOffset) throws InvocationTargetException {
            try {
                AbstractDocument doc = this.context.document;
                int startLine = doc.getLineOfOffset(startOffset);
                int stopLine = doc.getLineOfOffset(endOffset);
                IRegion stopLineInfo = doc.getLineInformation(stopLine);
                if (stopLineInfo.getOffset() >= endOffset) {
                    --stopLine;
                }
                if (stopLine - startLine + 1 >= this.config.minLines) {
                    int offset = doc.getLineOffset(startLine);
                    this.context.addFoldingRegion(new FoldingAnnotation(WikidocDefaultFoldingProvider.TYPE_EMBEDDED, false, (AbstractFoldingPosition)new SimpleFoldingPosition(offset, doc.getLineOffset(stopLine) + doc.getLineLength(stopLine) - offset)));
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    protected static final class FoldingConfiguration {
        public int minLines;
        public boolean isRestoreStateEnabled;

        protected FoldingConfiguration() {
        }
    }
}

