/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.statet.jcommons.io.ByteOrderMark;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class IOUtils {
    static final char BOM_CHAR = '\ufeff';
    static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    static final byte[] UTF_16BE_BOM = new byte[]{-2, -1};
    static final byte[] UTF_16LE_BOM = new byte[]{-1, -2};

    public static InputStream orNullStream(@Nullable InputStream stream) {
        return stream != null ? stream : InputStream.nullInputStream();
    }

    public static OutputStream orNullStream(@Nullable OutputStream stream) {
        return stream != null ? stream : OutputStream.nullOutputStream();
    }

    public static InputStreamReader newStreamContentReader(InputStream in, @Nullable ByteOrderMark bom, Charset defaultCharset) throws IOException {
        if (bom != null) {
            in.skipNBytes(bom.getLength());
            defaultCharset = bom.getCharset();
        }
        return new InputStreamReader(in, defaultCharset);
    }

    public static void skipBOM(BufferedReader reader) throws IOException {
        reader.mark(1);
        if (reader.read() != 65279) {
            reader.reset();
        }
    }

    public static BufferedReader newBufferedStreamContentReader(InputStream in, CharsetDecoder decoder) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, decoder));
        if (decoder.charset().name().startsWith("UTF-")) {
            IOUtils.skipBOM(reader);
        }
        return reader;
    }

    public static BufferedReader newBufferedStreamContentReader(InputStream in, Charset charset, CodingErrorAction errorAction) throws IOException {
        CharsetDecoder decoder = charset.newDecoder();
        if (errorAction != CodingErrorAction.REPORT) {
            decoder = decoder.onMalformedInput(errorAction).onUnmappableCharacter(errorAction);
        }
        return IOUtils.newBufferedStreamContentReader(in, decoder);
    }

    public static BufferedReader newBufferedStreamContentReader(InputStream in, Charset charset) throws IOException {
        CharsetDecoder decoder = charset.newDecoder();
        return IOUtils.newBufferedStreamContentReader(in, decoder);
    }

    public static String stripBOM(String s) throws IOException {
        int l = s.length();
        return l > 0 && s.charAt(0) == '\ufeff' ? s.substring(1, l) : s;
    }

    public static String readFileContentString(Path path, Charset charset) throws IOException {
        String s = Files.readString(path, charset);
        if (charset.name().startsWith("UTF-")) {
            s = IOUtils.stripBOM(s);
        }
        return s;
    }

    public static void close(@Nullable Closeable toClose, Throwable exception) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException | RuntimeException e) {
                exception.addSuppressed(e);
            }
        }
    }

    private IOUtils() {
    }
}

