/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.util.Enumeration;
import java.util.HashMap;
import jdk.test.lib.hprof.model.JavaClass;
import jdk.test.lib.hprof.model.JavaHeapObjectVisitor;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.Root;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.model.StackTrace;
import jdk.test.lib.hprof.util.Misc;

public abstract class JavaHeapObject
extends JavaThing {
    private JavaThing[] referrers = null;
    private int referrersLen = 0;

    public abstract JavaClass getClazz();

    @Override
    public abstract long getSize();

    public abstract long getId();

    public void resolve(Snapshot snapshot) {
        StackTrace trace = snapshot.getSiteTrace(this);
        if (trace != null) {
            trace.resolve(snapshot);
        }
    }

    void setupReferrers() {
        if (this.referrersLen > 1) {
            HashMap<JavaThing, JavaThing> map = new HashMap<JavaThing, JavaThing>();
            for (int i = 0; i < this.referrersLen; ++i) {
                if (map.get(this.referrers[i]) != null) continue;
                map.put(this.referrers[i], this.referrers[i]);
            }
            this.referrers = new JavaThing[map.size()];
            map.keySet().toArray(this.referrers);
        }
        this.referrersLen = -1;
    }

    public String getIdString() {
        return Misc.toHex(this.getId());
    }

    @Override
    public String toString() {
        return this.getClazz().getName() + "@" + this.getIdString();
    }

    public StackTrace getAllocatedFrom() {
        return this.getClazz().getSiteTrace(this);
    }

    public boolean isNew() {
        return this.getClazz().isNew(this);
    }

    void setNew(boolean flag) {
        this.getClazz().setNew(this, flag);
    }

    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        v.visit(this.getClazz());
    }

    void addReferenceFrom(JavaHeapObject other) {
        if (this.referrersLen == 0) {
            this.referrers = new JavaThing[1];
        } else if (this.referrersLen == this.referrers.length) {
            JavaThing[] copy = new JavaThing[3 * (this.referrersLen + 1) / 2];
            System.arraycopy(this.referrers, 0, copy, 0, this.referrersLen);
            this.referrers = copy;
        }
        this.referrers[this.referrersLen++] = other;
    }

    void addReferenceFromRoot(Root r) {
        this.getClazz().addReferenceFromRoot(r, this);
    }

    public Root getRoot() {
        return this.getClazz().getRoot(this);
    }

    public Enumeration<JavaThing> getReferrers() {
        if (this.referrersLen != -1) {
            throw new RuntimeException("not resolved: " + this.getIdString());
        }
        return new Enumeration<JavaThing>(){
            private int num = 0;

            @Override
            public boolean hasMoreElements() {
                return JavaHeapObject.this.referrers != null && this.num < JavaHeapObject.this.referrers.length;
            }

            @Override
            public JavaThing nextElement() {
                return JavaHeapObject.this.referrers[this.num++];
            }
        };
    }

    public boolean refersOnlyWeaklyTo(Snapshot ss, JavaThing other) {
        return false;
    }

    public String describeReferenceTo(JavaThing target, Snapshot ss) {
        return "??";
    }

    @Override
    public boolean isHeapAllocated() {
        return true;
    }
}

