/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.format;

import java.util.ArrayList;
import java.util.List;
import jdk.test.lib.format.Format;

public class ArrayCodec<E> {
    private static final String ELLIPSIS = "...";
    private boolean exhausted;
    private StringBuilder encoded;
    private List<E> source;
    private String element;
    private boolean bounded = false;
    private int maxWidth;
    private int idx;

    private ArrayCodec(List<E> source) {
        this.source = source;
    }

    public static ArrayCodec<Character> of(char[] array) {
        ArrayList<Character> source = new ArrayList<Character>(array.length);
        for (char value : array) {
            source.add(Character.valueOf(value));
        }
        return new ArrayCodec<Character>(source);
    }

    public static ArrayCodec<Byte> of(byte[] array) {
        ArrayList<Byte> source = new ArrayList<Byte>(array.length);
        for (byte value : array) {
            source.add(value);
        }
        return new ArrayCodec<Byte>(source);
    }

    public static ArrayCodec<Integer> of(int[] array) {
        ArrayList<Integer> source = new ArrayList<Integer>(array.length);
        for (int value : array) {
            source.add(value);
        }
        return new ArrayCodec<Integer>(source);
    }

    public static ArrayCodec<Long> of(long[] array) {
        ArrayList<Long> source = new ArrayList<Long>(array.length);
        for (long value : array) {
            source.add(value);
        }
        return new ArrayCodec<Long>(source);
    }

    public static ArrayCodec<String> of(String[] array) {
        ArrayList<String> source = new ArrayList<String>(array.length);
        for (String value : array) {
            source.add(value);
        }
        return new ArrayCodec<String>(source);
    }

    public static ArrayCodec<Object> of(Object[] array) {
        ArrayList<Object> source = new ArrayList<Object>(array.length);
        for (Object value : array) {
            source.add(value);
        }
        return new ArrayCodec<Object>(source);
    }

    public static ArrayCodec<?> of(Object array) {
        Class<?> type = array.getClass().getComponentType();
        if (type == Byte.TYPE) {
            return ArrayCodec.of((byte[])array);
        }
        if (type == Integer.TYPE) {
            return ArrayCodec.of((int[])array);
        }
        if (type == Long.TYPE) {
            return ArrayCodec.of((long[])array);
        }
        if (type == Character.TYPE) {
            return ArrayCodec.of((char[])array);
        }
        if (type == String.class) {
            return ArrayCodec.of((String[])array);
        }
        if (!type.isPrimitive() && !type.isArray()) {
            return ArrayCodec.of((Object[])array);
        }
        throw new IllegalArgumentException("Unsupported array component type: " + String.valueOf(type));
    }

    public static String format(Object array) {
        ArrayCodec<?> codec = ArrayCodec.of(array);
        codec.startFormatting(0, -1);
        while (!codec.isExhausted()) {
            codec.formatNext();
            codec.appendFormatted();
        }
        return codec.getEncoded();
    }

    public void startFormatting(int startIdx, int maxWidth) {
        this.encoded = new StringBuilder(startIdx == 0 ? "[" : ELLIPSIS);
        this.exhausted = false;
        this.maxWidth = maxWidth;
        this.bounded = maxWidth > 0;
        this.idx = startIdx;
    }

    public void formatNext() {
        String prefix;
        int limit = this.source.size();
        String string = prefix = this.idx == 0 || this.idx >= limit ? "" : " ";
        String suffix = this.idx + 1 == limit || this.source.isEmpty() && this.idx == 0 ? "]" : (this.idx >= limit ? "" : ",");
        this.element = prefix + (this.idx >= limit ? "" : Format.asLiteral(this.source.get(this.idx))) + suffix;
    }

    public void appendFormatted() {
        boolean isLast;
        if (this.exhausted) {
            return;
        }
        boolean bl = isLast = this.idx == this.source.size() - 1;
        if (isLast || this.source.isEmpty()) {
            this.exhausted = true;
        }
        if (this.bounded && this.encoded.length() + this.element.length() > this.maxWidth - ELLIPSIS.length()) {
            this.encoded.append(isLast ? this.element : " ...");
            this.exhausted = true;
        } else {
            this.encoded.append(this.element);
        }
        ++this.idx;
    }

    public void alignBy(ArrayCodec<E> another) {
        int delta;
        if (!this.element.equals("") && !this.element.equals("]") && (delta = another.element.length() - this.element.length()) > 0) {
            this.element = Format.paddingForWidth(delta) + this.element;
        }
    }

    public boolean isExhausted() {
        return this.exhausted;
    }

    public String getEncoded() {
        return this.encoded.toString();
    }

    public int getEncodedLength() {
        return this.encoded.length();
    }

    public int getElementLength() {
        return this.element.length();
    }

    public int findMismatchIndex(ArrayCodec<E> another) {
        int result = 0;
        while (this.source.size() > result && another.source.size() > result) {
            E first = this.source.get(result);
            E second = another.source.get(result);
            if (first == null || second == null) {
                if (first == null && second == null) continue;
                return result;
            }
            if (!first.equals(second)) {
                return result;
            }
            ++result;
        }
        return this.source.size() != another.source.size() ? result : -1;
    }

    public boolean equals(ArrayCodec<E> another) {
        return this.source.equals(another.source);
    }
}

