/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import jdk.test.lib.hprof.model.HackJavaValue;
import jdk.test.lib.hprof.model.JavaField;
import jdk.test.lib.hprof.model.JavaLong;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.util.Misc;

public class JavaObjectRef
extends JavaThing {
    private long id;

    public JavaObjectRef(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public boolean isHeapAllocated() {
        return true;
    }

    @Override
    public JavaThing dereference(Snapshot snapshot, JavaField field) {
        return this.dereference(snapshot, field, true);
    }

    public JavaThing dereference(Snapshot snapshot, JavaField field, boolean verbose) {
        if (field != null && !field.hasId()) {
            return new JavaLong(this.id);
        }
        if (this.id == 0L) {
            return snapshot.getNullThing();
        }
        JavaThing result = snapshot.findThing(this.id);
        if (result == null) {
            if (!snapshot.getUnresolvedObjectsOK() && verbose) {
                String msg = "WARNING:  Failed to resolve object id " + Misc.toHex(this.id);
                if (field != null) {
                    msg = msg + " for field " + field.getName() + " (signature " + field.getSignature() + ")";
                }
                System.out.println(msg);
            }
            result = new HackJavaValue("Unresolved object " + Misc.toHex(this.id), 0L);
        }
        return result;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public String toString() {
        return "Unresolved object " + Misc.toHex(this.id);
    }
}

