/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwi\u0161ki srednji \u010das",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Standardni \u010das: Apia",
               "",
               "Poletni \u010das: Apia",
               "",
               "\u010cas: Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Cookovooto\u0161ki standardni \u010das",
               "",
               "Cookovooto\u0161ki srednjepoletni \u010das",
               "",
               "Cookovooto\u0161ki \u010das",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubanski standardni \u010das",
               "CST",
               "Kubanski poletni \u010das",
               "CDT",
               "Kubanski \u010das",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017eijski standardni \u010das",
               "",
               "Fid\u017eijski poletni \u010das",
               "",
               "Fid\u017eijski \u010das",
               "",
            };
        final String[] Gulf = new String[] {
               "Zalivski standardni \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdski standardni \u010das",
               "",
               "Hovdski poletni \u010das",
               "",
               "Hovdski \u010das",
               "",
            };
        final String[] Iran = new String[] {
               "Iranski standardni \u010das",
               "",
               "Iranski poletni \u010das",
               "",
               "Iranski \u010das",
               "",
            };
        final String[] Niue = new String[] {
               "Niuejski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omski standardni \u010das",
               "",
               "Omski poletni \u010das",
               "",
               "Omski \u010das",
               "",
            };
        final String[] Peru = new String[] {
               "Perujski standardni \u010das",
               "",
               "Perujski poletni \u010das",
               "",
               "Perujski \u010das",
               "",
            };
        final String[] Truk = new String[] {
               "\u010cas: Otok Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u010cas: Otok Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u010cilski standardni \u010das",
               "",
               "\u010cilski poletni \u010das",
               "",
               "\u010cilski \u010das",
               "",
            };
        final String[] China = new String[] {
               "Kitajski standardni \u010das",
               "CST",
               "Kitajski poletni \u010das",
               "CDT",
               "Kitajski \u010das",
               "CT",
            };
        final String[] Cocos = new String[] {
               "\u010cas: Kokosovi otoki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "\u010cas: Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijski standardni \u010das",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japonski standardni \u010das",
               "JST",
               "Japonski poletni \u010das",
               "JDT",
               "Japonski \u010das",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korejski standardni \u010das",
               "KST",
               "Korejski poletni \u010das",
               "KST",
               "Korejski \u010das",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Naurujski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palavski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoanski standardni \u010das",
               "SST",
               "Samoanski poletni \u010das",
               "SST",
               "Samoanski \u010das",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u010cas: Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongovski standardni \u010das",
               "",
               "Tongovski poletni \u010das",
               "",
               "Tongovski \u010das",
               "",
            };
        final String[] Yukon = new String[] {
               "Jukonski \u010das",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alja\u0161ki standardni \u010das",
               "AKST",
               "Alja\u0161ki poletni \u010das",
               "AKDT",
               "Alja\u0161ki \u010das",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazonski standardni \u010das",
               "",
               "Amazonski poletni \u010das",
               "",
               "Amazonski \u010das",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadirski standardni \u010das",
               "",
               "Anadirski poletni \u010das",
               "",
               "Anadirski \u010das",
               "",
            };
        final String[] Azores = new String[] {
               "Azorski standardni \u010das",
               "",
               "Azorski poletni \u010das",
               "",
               "Azorski \u010das",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunejski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Standardni \u010das: Velikono\u010dni otok",
               "",
               "Poletni \u010das: Velikono\u010dni otok",
               "",
               "\u010cas: Velikono\u010dni otok",
               "",
            };
        final String[] Guyana = new String[] {
               "Gvajanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Izraelski standardni \u010das",
               "IST",
               "Izraelski poletni \u010das",
               "IDT",
               "Izraelski \u010das",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraj\u0161ki \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsonski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskovski standardni \u010das",
               "MSK",
               "Moskovski poletni \u010das",
               "MSK",
               "Moskovski \u010das",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponapski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samarski standardni \u010das",
               "",
               "Samarski poletni \u010das",
               "",
               "Samarski \u010das",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitijski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tajpejski standardni \u010das",
               "CST",
               "Tajpejski poletni \u010das",
               "CDT",
               "Tajpejski \u010das",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalujski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vosto\u0161ki \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u010cas: Wallis in Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabski standardni \u010das",
               "",
               "Arabski poletni \u010das",
               "",
               "Arabski \u010das",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenski standardni \u010das",
               "",
               "Armenski poletni \u010das",
               "",
               "Armenski \u010das",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivijski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u010catamski standardni \u010das",
               "",
               "\u010catamski poletni \u010das",
               "",
               "\u010catamski \u010das",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "univerzalni koordinirani \u010das",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadorski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambierski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzijski standardni \u010das",
               "",
               "Gruzijski poletni \u010das",
               "",
               "Gruzijski \u010das",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutski standardni \u010das",
               "",
               "Irkutski poletni \u010das",
               "",
               "Irkutski \u010das",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadanski standardni \u010das",
               "",
               "Magadanski poletni \u010das",
               "",
               "Magadanski \u010das",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mjanmarski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Standardni \u010das: Norfol\u0161ki otoki",
               "",
               "Poletni \u010das: Norfol\u0161ki otoki",
               "",
               "\u010cas: Norfol\u0161ki otoki",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noron\u0161ki standardni \u010das",
               "",
               "Fernando de Noron\u0161ki poletni \u010das",
               "",
               "Fernando de Noron\u0161ki \u010das",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunionski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotherski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonovooto\u0161ki \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelavski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvajski standardni \u010das",
               "",
               "Urugvajski poletni \u010das",
               "",
               "Urugvajski \u010das",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatujski standardni \u010das",
               "",
               "Vanuatujski poletni \u010das",
               "",
               "Vanuatujski \u010das",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardni \u010das",
               "",
               "Jakutski poletni \u010das",
               "",
               "Jakutski \u010das",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantski standardni \u010das",
               "AST",
               "Atlantski poletni \u010das",
               "AST",
               "Atlantski \u010das",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilski standardni \u010das",
               "",
               "Brasilski poletni \u010das",
               "",
               "Brasilski \u010das",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camorski standardni \u010das",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbijski standardni \u010das",
               "",
               "Kolumbijski poletni \u010das",
               "",
               "Kolumbijski \u010das",
               "",
            };
        final String[] Falkland = new String[] {
               "Standardni \u010das: Falklandsko oto\u010dje",
               "",
               "Poletni \u010das: Falklandsko oto\u010dje",
               "",
               "\u010cas: Falklandsko oto\u010dje",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malezijski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatorski standardni \u010das",
               "",
               "Ulanbatorski poletni \u010das",
               "",
               "Ulanbatorski \u010das",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistanski standardni \u010das",
               "PKT",
               "Pakistanski poletni \u010das",
               "PKST",
               "Pakistanski \u010das",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvajski standardni \u010das",
               "",
               "Paragvajski poletni \u010das",
               "",
               "Paragvajski \u010das",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalinski standardni \u010das",
               "",
               "Sahalinski poletni \u010das",
               "",
               "Sahalinski \u010das",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinski standardni \u010das",
               "",
               "Argentinski poletni \u010das",
               "",
               "Argentinski \u010das",
               "",
            };
        final String[] Christmas = new String[] {
               "Bo\u017ei\u010dnooto\u0161ki \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapa\u0161ki \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkon\u0161ki standardni \u010das",
               "HKT",
               "Hongkon\u0161ki poletni \u010das",
               "HKST",
               "Hongkon\u0161ki \u010das",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokitajski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kam\u010datski standardni \u010das",
               "",
               "Petropavlovsk-Kam\u010datski poletni \u010das",
               "",
               "Petropavlovsk-Kam\u010datski \u010das",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizistanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Standardni \u010das otoka Lord Howe",
               "",
               "Poletni \u010das otoka Lord Howe",
               "",
               "\u010cas otoka Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "\u010cas: Markizni otoki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauricijski standardni \u010das",
               "",
               "Mauricijski poletni \u010das",
               "",
               "Mauricijski \u010das",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapurski standardni \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuelski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograjski standardni \u010das",
               "MSK",
               "Volgograjski poletni \u010das",
               "MSK",
               "Volgograjski \u010das",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbajd\u017eanski standardni \u010das",
               "",
               "Azerbajd\u017eanski poletni \u010das",
               "",
               "Azerbajd\u017eanski \u010das",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161ki standardni \u010das",
               "",
               "Banglade\u0161ki poletni \u010das",
               "",
               "Banglade\u0161ki \u010das",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdski standardni \u010das",
               "",
               "Kapverdski poletni \u010das",
               "",
               "Kapverdski \u010das",
               "",
            };
        final String[] East_Timor = new String[] {
               "Vzhodnotimorski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazahstanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sej\u0161elski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistanski standardni \u010das",
               "",
               "Uzbekistanski poletni \u010das",
               "",
               "Uzbekistanski \u010das",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarski standardni \u010das",
               "",
               "Krasnojarski poletni \u010das",
               "",
               "Krasnojarski \u010das",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Novozelandski standardni \u010das",
               "NZST",
               "Novozelandski poletni \u010das",
               "NZDT",
               "Novozelandski \u010das",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirski standardni \u010das",
               "",
               "Novosibirski poletni \u010das",
               "",
               "Novosibirski \u010das",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipinski standardni \u010das",
               "PST",
               "Filipinski poletni \u010das",
               "PDT",
               "Filipinski \u010das",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivosto\u0161ki standardni \u010das",
               "",
               "Vladivosto\u0161ki poletni \u010das",
               "",
               "Vladivosto\u0161ki \u010das",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijskooceanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u010cas: Ekvatorski otoki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Novofundlandski standardni \u010das",
               "NST",
               "Novofundlandski poletni \u010das",
               "NDT",
               "Novofundlandski \u010das",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistanski standardni \u010das",
               "",
               "Turkmenistanski poletni \u010das",
               "",
               "Turkmenistanski \u010das",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u010cas: Francoska Gvajana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Novokaledonijski standardni \u010das",
               "",
               "Novokaledonijski poletni \u010das",
               "",
               "Novokaledonijski \u010das",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ju\u017enogeorgijski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinbur\u0161ki standardni \u010das",
               "",
               "Jekaterinbur\u0161ki poletni \u010das",
               "",
               "Jekaterinbur\u0161ki \u010das",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centralnoafri\u0161ki \u010das",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Vzhodnoafri\u0161ki \u010das",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Zahodnoafri\u0161ki standardni \u010das",
               "WAT",
               "Zahodnoafri\u0161ki poletni \u010das",
               "WAT",
               "Zahodnoafri\u0161ki \u010das",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "\u010cas: Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Srednjeevropski standardni \u010das",
               "CET",
               "Srednjeevropski poletni \u010das",
               "CEST",
               "Srednjeevropski \u010das",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Vzhodnoevropski standardni \u010das",
               "EET",
               "Vzhodnoevropski poletni \u010das",
               "EEST",
               "Vzhodnoevropski \u010das",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Zahodnoevropski standardni \u010das",
               "WET",
               "Zahodnoevropski poletni \u010das",
               "WEST",
               "Zahodnoevropski \u010das",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mehi\u0161ki pacifi\u0161ki standardni \u010das",
               "MST",
               "Mehi\u0161ki pacifi\u0161ki poletni \u010das",
               "MDT",
               "Mehi\u0161ki pacifi\u0161ki \u010das",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017enoafri\u0161ki \u010das",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Centralni standardni \u010das",
               "CST",
               "Centralni poletni \u010das",
               "CDT",
               "Centralni \u010das",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Vzhodni standardni \u010das",
               "EST",
               "Vzhodni poletni \u010das",
               "EST",
               "Vzhodni \u010das",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pacifi\u0161ki standardni \u010das",
               "PST",
               "Pacifi\u0161ki poletni \u010das",
               "PDT",
               "Pacifi\u0161ki \u010das",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Francoski ju\u017eni in antarkti\u010dni \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010cas: Gilbertovi otoki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajski aleutski standardni \u010das",
               "HST",
               "Havajski aleutski poletni \u010das",
               "HST",
               "Havajski aleutski \u010das",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010cas: Oto\u010dje Feniks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Standardni \u010das: Saint Pierre in Miquelon",
               "",
               "Poletni \u010das: Saint Pierre in Miquelon",
               "",
               "\u010cas: Saint Pierre in Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Gorski standardni \u010das",
               "MST",
               "Gorski poletni \u010das",
               "MST",
               "Gorski \u010das",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010cas: Marshallovi otoki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papuanski \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Avstralski centralni standardni \u010das",
               "ACST",
               "Avstralski centralni poletni \u010das",
               "ACDT",
               "Avstralski centralni \u010das",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Avstralski vzhodni standardni \u010das",
               "AEST",
               "Avstralski vzhodni poletni \u010das",
               "AEDT",
               "Avstralski vzhodni \u010das",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Avstralski zahodni standardni \u010das",
               "AWST",
               "Avstralski zahodni poletni \u010das",
               "AWDT",
               "Avstralski zahodni \u010das",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indonezijski osrednji \u010das",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indonezijski vzhodni \u010das",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indonezijski zahodni \u010das",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Avstralski centralni zahodni standardni \u010das",
               "",
               "Avstralski centralni zahodni poletni \u010das",
               "",
               "Avstralski centralni zahodni \u010das",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Britanski poletni \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "univerzalni koordinirani \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Irski standardni \u010das",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "univerzalni koordinirani \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "univerzalni koordinirani \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Britanski poletni \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "univerzalni koordinirani \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "univerzalni koordinirani \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "univerzalni koordinirani \u010das",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Irski standardni \u010das",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Britanski poletni \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Britanski poletni \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Britanski poletni \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Britanski poletni \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwi\u0161ki srednji \u010das",
                    "GMT",
                    "Britanski poletni \u010das",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Beirut", "Bejrut" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Muscat", "Mu\u0161kat" },
            { "timezone.excity.Asia/Riyadh", "Rijad" },
            { "timezone.excity.Asia/Saigon", "Ho\u0161iminh" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.Etc/Unknown", "neznano mesto" },
            { "timezone.excity.Europe/Kiev", "Kijev" },
            { "timezone.excity.Europe/Rome", "Rim" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Jakarta", "D\u017eakarta" },
            { "timezone.excity.Asia/Karachi", "Kara\u010di" },
            { "timezone.excity.Asia/Nicosia", "Nikozija" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Thimphu", "Timpu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Europe/Paris", "Pariz" },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "timezone.excity.Indian/Cocos", "Kokosovi otoki" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161habad" },
            { "timezone.excity.Asia/Calcutta", "Kalkuta" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Asia/Shanghai", "\u0160anghaj" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Europe/Athens", "Atene" },
            { "timezone.excity.Europe/Lisbon", "Lizbona" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Dunaj" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Komori" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abid\u017ean" },
            { "timezone.excity.Africa/Algiers", "Al\u017eir" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Cayman", "Kajman" },
            { "timezone.excity.America/Guyana", "Gvajana" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kizlorda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Tallinn", "Talin" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Europe/Vilnius", "Vilna" },
            { "timezone.excity.Pacific/Easter", "Velikono\u010dni otok" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.Africa/Khartoum", "Kartum" },
            { "timezone.excity.Africa/Kinshasa", "Kin\u0161asa" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.Atlantic/Azores", "Azori" },
            { "timezone.excity.Atlantic/Canary", "Kanarski otoki" },
            { "timezone.excity.Atlantic/Faeroe", "Ferski otoki" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Brussels", "Bruselj" },
            { "timezone.excity.Europe/Budapest", "Budimpe\u0161ta" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161injev" },
            { "timezone.excity.Indian/Maldives", "Maldivi" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161u" },
            { "timezone.excity.America/Anguilla", "Angvila" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/St_Kitts", "Sv. Kri\u0161tof" },
            { "timezone.excity.America/St_Lucia", "Sv. Lucija" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudi" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "Bukare\u0161ta" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "Bo\u017ei\u010dni otok" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumba\u0161i" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.America/St_Thomas", "Sv. Toma\u017e" },
            { "timezone.excity.Europe/Copenhagen", "K\u00f6benhavn" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.America/St_Vincent", "Sv. Vincencij" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/St_Helena", "Sv. Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Otok Man" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Ciudad de Mexico" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Zelenortski otoki" },
            { "timezone.excity.America/St_Barthelemy", "Sv. Bartolomej" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia de Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Ju\u017ena Georgia" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Severna Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Severna Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Severna Dakota" },
        };
        return data;
    }
}
