/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XKeyEvent
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 60 : 96;
    }

    @Override
    public int getDataSize() {
        return XKeyEvent.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XKeyEvent(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XKeyEvent() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XKeyEvent.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_type(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public long get_serial() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_serial(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    public boolean get_send_event() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16));
    }

    public void set_send_event(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16), bl);
    }

    public long get_display() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24));
    }

    public void set_display(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24), l);
    }

    public long get_window() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 32));
    }

    public void set_window(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 32), l);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 40));
    }

    public void set_root(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 40), l);
    }

    public long get_subwindow() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 48));
    }

    public void set_subwindow(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 48), l);
    }

    public long get_time() {
        log.finest("");
        return Native.getULong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 56));
    }

    public void set_time(long l) {
        log.finest("");
        Native.putULong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 56), l);
    }

    public int get_x() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 64));
    }

    public void set_x(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 64), n);
    }

    public int get_y() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 68));
    }

    public void set_y(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 68), n);
    }

    public int get_x_root() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 72));
    }

    public void set_x_root(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 40 : 72), n);
    }

    public int get_y_root() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 76));
    }

    public void set_y_root(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 44 : 76), n);
    }

    public int get_state() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 80));
    }

    public void set_state(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 48 : 80), n);
    }

    public int get_keycode() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 84));
    }

    public void set_keycode(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 52 : 84), n);
    }

    public boolean get_same_screen() {
        log.finest("");
        return Native.getBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 88));
    }

    public void set_same_screen(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + (long)(XlibWrapper.dataModel == 32 ? 56 : 88), bl);
    }

    @Override
    String getName() {
        return "XKeyEvent";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(600);
        stringBuilder.append("type = ").append(XlibWrapper.eventToString[this.get_type()]).append(", ");
        stringBuilder.append("serial = ").append(this.get_serial()).append(", ");
        stringBuilder.append("send_event = ").append(this.get_send_event()).append(", ");
        stringBuilder.append("display = ").append(this.get_display()).append(", ");
        stringBuilder.append("window = ").append(this.getWindow(this.get_window())).append(", ");
        stringBuilder.append("root = ").append(this.get_root()).append(", ");
        stringBuilder.append("subwindow = ").append(this.get_subwindow()).append(", ");
        stringBuilder.append("time = ").append(this.get_time()).append(", ");
        stringBuilder.append("x = ").append(this.get_x()).append(", ");
        stringBuilder.append("y = ").append(this.get_y()).append(", ");
        stringBuilder.append("x_root = ").append(this.get_x_root()).append(", ");
        stringBuilder.append("y_root = ").append(this.get_y_root()).append(", ");
        stringBuilder.append("state = ").append(this.get_state()).append(", ");
        stringBuilder.append("keycode = ").append(this.get_keycode()).append(", ");
        stringBuilder.append("same_screen = ").append(this.get_same_screen()).append(", ");
        return stringBuilder.toString();
    }
}

