/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.util.ArrayList;
import jdk.jfr.consumer.LongMap;
import jdk.jfr.consumer.ObjectFactory;

final class ConstantMap {
    private final ObjectFactory<?> factory;
    private final LongMap<Object> objects;
    private LongMap<Boolean> isResolving;
    private boolean allResolved;
    private String name;

    ConstantMap(ObjectFactory<?> objectFactory, String string) {
        this.name = string;
        this.objects = new LongMap();
        this.factory = objectFactory;
    }

    Object get(long l) {
        if (this.allResolved) {
            return this.objects.get(l);
        }
        if (this.isResolving == null) {
            return new Reference(this, l);
        }
        Boolean bl = this.isResolving.get(l);
        if (Boolean.FALSE.equals(bl)) {
            return this.objects.get(l);
        }
        if (Boolean.TRUE.equals(bl)) {
            return null;
        }
        this.isResolving.put(l, Boolean.TRUE);
        Object object = ConstantMap.resolve(this.objects.get(l));
        this.isResolving.put(l, Boolean.FALSE);
        if (this.factory != null) {
            Object obj = this.factory.createObject(l, object);
            this.objects.put(l, obj);
            return obj;
        }
        this.objects.put(l, object);
        return object;
    }

    private static Object resolve(Object object) {
        if (object instanceof Reference) {
            return ConstantMap.resolve(((Reference)object).resolve());
        }
        if (object != null && object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = ConstantMap.resolve(objectArray[i]);
            }
            return objectArray;
        }
        return object;
    }

    public void resolve() {
        ArrayList arrayList = new ArrayList();
        this.objects.keys().forEachRemaining(arrayList::add);
        for (Long l : arrayList) {
            this.get(l);
        }
    }

    public void put(long l, Object object) {
        this.objects.put(l, object);
    }

    public void setIsResolving() {
        this.isResolving = new LongMap();
    }

    public void setResolved() {
        this.allResolved = true;
        this.isResolving = null;
    }

    public String getName() {
        return this.name;
    }

    private static final class Reference {
        private final long key;
        private final ConstantMap pool;

        Reference(ConstantMap constantMap, long l) {
            this.pool = constantMap;
            this.key = l;
        }

        Object resolve() {
            return this.pool.get(this.key);
        }
    }
}

