/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public class RSAUtil {
    public static void checkParamsAgainstType(KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec) throws ProviderException {
        switch (keyType) {
            case RSA: {
                if (algorithmParameterSpec == null) break;
                throw new ProviderException("null params expected for " + keyType.keyAlgo());
            }
            case PSS: {
                if (algorithmParameterSpec == null || algorithmParameterSpec instanceof PSSParameterSpec) break;
                throw new ProviderException("PSSParmeterSpec expected for " + keyType.keyAlgo());
            }
            default: {
                throw new ProviderException("Unsupported RSA algorithm " + (Object)((Object)keyType));
            }
        }
    }

    public static AlgorithmId createAlgorithmId(KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec) throws ProviderException {
        RSAUtil.checkParamsAgainstType(keyType, algorithmParameterSpec);
        ObjectIdentifier objectIdentifier = null;
        AlgorithmParameters algorithmParameters = null;
        try {
            switch (keyType) {
                case RSA: {
                    objectIdentifier = AlgorithmId.RSAEncryption_oid;
                    break;
                }
                case PSS: {
                    if (algorithmParameterSpec != null) {
                        algorithmParameters = AlgorithmParameters.getInstance(keyType.keyAlgo());
                        algorithmParameters.init(algorithmParameterSpec);
                    }
                    objectIdentifier = AlgorithmId.RSASSA_PSS_oid;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported RSA algorithm " + (Object)((Object)keyType));
                }
            }
            AlgorithmId algorithmId = algorithmParameters == null ? new AlgorithmId(objectIdentifier) : new AlgorithmId(objectIdentifier, algorithmParameters);
            return algorithmId;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
    }

    public static AlgorithmParameterSpec getParamSpec(AlgorithmId algorithmId) throws ProviderException {
        if (algorithmId == null) {
            throw new ProviderException("AlgorithmId should not be null");
        }
        return RSAUtil.getParamSpec(algorithmId.getParameters());
    }

    public static AlgorithmParameterSpec getParamSpec(AlgorithmParameters algorithmParameters) throws ProviderException {
        if (algorithmParameters == null) {
            return null;
        }
        try {
            Class<PSSParameterSpec> clazz;
            String string = algorithmParameters.getAlgorithm();
            KeyType keyType = KeyType.lookup(string);
            switch (keyType) {
                case RSA: {
                    throw new ProviderException("No params accepted for " + keyType.keyAlgo());
                }
                case PSS: {
                    clazz = PSSParameterSpec.class;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported RSA algorithm: " + string);
                }
            }
            return algorithmParameters.getParameterSpec(clazz);
        }
        catch (ProviderException providerException) {
            throw providerException;
        }
        catch (Exception exception) {
            throw new ProviderException(exception);
        }
    }

    public static enum KeyType {
        RSA("RSA"),
        PSS("RSASSA-PSS");

        private final String algo;

        private KeyType(String string2) {
            this.algo = string2;
        }

        public String keyAlgo() {
            return this.algo;
        }

        public static KeyType lookup(String string) throws InvalidKeyException, ProviderException {
            if (string == null) {
                throw new InvalidKeyException("Null key algorithm");
            }
            for (KeyType keyType : KeyType.values()) {
                if (!keyType.keyAlgo().equalsIgnoreCase(string)) continue;
                return keyType;
            }
            throw new ProviderException("Unsupported algorithm " + string);
        }
    }
}

