/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Conditional;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsCallback;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.swing.JInternalFrame;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.java2d.pipe.Region;
import sun.security.action.GetBooleanAction;
import sun.util.logging.PlatformLogger;

public class Container
extends Component {
    private static final PlatformLogger log = PlatformLogger.getLogger("java.awt.Container");
    private static final PlatformLogger eventLog = PlatformLogger.getLogger("java.awt.event.Container");
    private static final Component[] EMPTY_ARRAY = new Component[0];
    private List<Component> component = new ArrayList<Component>();
    LayoutManager layoutMgr;
    private LightweightDispatcher dispatcher;
    private transient FocusTraversalPolicy focusTraversalPolicy;
    private boolean focusCycleRoot = false;
    private boolean focusTraversalPolicyProvider;
    private transient Set<Thread> printingThreads;
    private transient boolean printing = false;
    transient ContainerListener containerListener;
    transient int listeningChildren;
    transient int listeningBoundsChildren;
    transient int descendantsCount;
    transient Color preserveBackgroundColor = null;
    private static final long serialVersionUID = 4613797578919906343L;
    static final boolean INCLUDE_SELF = true;
    static final boolean SEARCH_HEAVYWEIGHTS = true;
    private transient int numOfHWComponents = 0;
    private transient int numOfLWComponents = 0;
    private static final PlatformLogger mixingLog = PlatformLogger.getLogger("java.awt.mixing.Container");
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("ncomponents", Integer.TYPE), new ObjectStreamField("component", Component[].class), new ObjectStreamField("layoutMgr", LayoutManager.class), new ObjectStreamField("dispatcher", LightweightDispatcher.class), new ObjectStreamField("maxSize", Dimension.class), new ObjectStreamField("focusCycleRoot", Boolean.TYPE), new ObjectStreamField("containerSerializedDataVersion", Integer.TYPE), new ObjectStreamField("focusTraversalPolicyProvider", Boolean.TYPE)};
    private static final boolean isJavaAwtSmartInvalidate;
    private static boolean descendUnconditionallyWhenValidating;
    transient Component modalComp;
    transient AppContext modalAppContext;
    private int containerSerializedDataVersion = 1;

    private static native void initIDs();

    @Override
    void initializeFocusTraversalKeys() {
        this.focusTraversalKeys = new Set[4];
    }

    public int getComponentCount() {
        return this.countComponents();
    }

    @Deprecated
    public int countComponents() {
        return this.component.size();
    }

    public Component getComponent(int n) {
        try {
            return this.component.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("No such child: " + n);
        }
    }

    public Component[] getComponents() {
        return this.getComponents_NoClientCode();
    }

    final Component[] getComponents_NoClientCode() {
        return this.component.toArray(EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Component[] getComponentsSync() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.getComponents();
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    @Deprecated
    public Insets insets() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof ContainerPeer) {
            ContainerPeer containerPeer = (ContainerPeer)componentPeer;
            return (Insets)containerPeer.getInsets().clone();
        }
        return new Insets(0, 0, 0, 0);
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    private void checkAddToSelf(Component component) {
        if (component instanceof Container) {
            Container container = this;
            while (container != null) {
                if (container == component) {
                    throw new IllegalArgumentException("adding container's parent to itself");
                }
                container = container.parent;
            }
        }
    }

    private void checkNotAWindow(Component component) {
        if (component instanceof Window) {
            throw new IllegalArgumentException("adding a window to a container");
        }
    }

    private void checkAdding(Component component, int n) {
        this.checkTreeLock();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (n > this.component.size() || n < 0) {
            throw new IllegalArgumentException("illegal component position");
        }
        if (component.parent == this && n == this.component.size()) {
            throw new IllegalArgumentException("illegal component position " + n + " should be less then " + this.component.size());
        }
        this.checkAddToSelf(component);
        this.checkNotAWindow(component);
        Window window = this.getContainingWindow();
        Window window2 = component.getContainingWindow();
        if (window != window2) {
            throw new IllegalArgumentException("component and container should be in the same top-level window");
        }
        if (graphicsConfiguration != null) {
            component.checkGD(graphicsConfiguration.getDevice().getIDstring());
        }
    }

    private boolean removeDelicately(Component component, Container container, int n) {
        this.checkTreeLock();
        int n2 = this.getComponentZOrder(component);
        boolean bl = Container.isRemoveNotifyNeeded(component, this, container);
        if (bl) {
            component.removeNotify();
        }
        if (container != this) {
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            this.adjustListeningChildren(32768L, -component.numListening(32768L));
            this.adjustListeningChildren(65536L, -component.numListening(65536L));
            this.adjustDescendants(-component.countHierarchyMembers());
            component.parent = null;
            if (bl) {
                component.setGraphicsConfiguration(null);
            }
            this.component.remove(n2);
            this.invalidateIfValid();
        } else {
            this.component.remove(n2);
            this.component.add(n, component);
        }
        if (component.parent == null) {
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.dispatchEvent(containerEvent);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canContainFocusOwner(Component component) {
        Object object;
        if (!(this.isEnabled() && this.isDisplayable() && this.isVisible() && this.isFocusable())) {
            return false;
        }
        if (this.isFocusCycleRoot() && (object = this.getFocusTraversalPolicy()) instanceof DefaultFocusTraversalPolicy && !((DefaultFocusTraversalPolicy)object).accept(component)) {
            return false;
        }
        object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null) {
                return this.parent.canContainFocusOwner(component);
            }
        }
        return true;
    }

    final boolean hasHeavyweightDescendants() {
        this.checkTreeLock();
        return this.numOfHWComponents > 0;
    }

    final boolean hasLightweightDescendants() {
        this.checkTreeLock();
        return this.numOfLWComponents > 0;
    }

    Container getHeavyweightContainer() {
        this.checkTreeLock();
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            return this;
        }
        return this.getNativeContainer();
    }

    private static boolean isRemoveNotifyNeeded(Component component, Container container, Container container2) {
        Container container3;
        boolean bl;
        if (container == null) {
            return false;
        }
        if (component.peer == null) {
            return false;
        }
        if (container2.peer == null) {
            return true;
        }
        if (component.isLightweight() && (!(bl = component instanceof Container) || bl && !((Container)component).hasHeavyweightDescendants())) {
            return false;
        }
        Container container4 = container.getHeavyweightContainer();
        if (container4 != (container3 = container2.getHeavyweightContainer())) {
            return !component.peer.isReparentSupported();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentZOrder(Component component, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Container container = component.parent;
            int n2 = this.getComponentZOrder(component);
            if (container == this && n == n2) {
                return;
            }
            this.checkAdding(component, n);
            boolean bl = container != null ? container.removeDelicately(component, this, n) : false;
            this.addDelicately(component, container, n);
            if (!bl && n2 != -1) {
                component.mixOnZOrderChanging(n2, n);
            }
        }
    }

    private void reparentTraverse(ContainerPeer containerPeer, Container container) {
        this.checkTreeLock();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component.isLightweight()) {
                if (!(component instanceof Container)) continue;
                this.reparentTraverse(containerPeer, (Container)component);
                continue;
            }
            component.getPeer().reparent(containerPeer);
        }
    }

    private void reparentChild(Component component) {
        this.checkTreeLock();
        if (component == null) {
            return;
        }
        if (component.isLightweight()) {
            if (component instanceof Container) {
                this.reparentTraverse((ContainerPeer)this.getPeer(), (Container)component);
            }
        } else {
            component.getPeer().reparent((ContainerPeer)this.getPeer());
        }
    }

    private void addDelicately(Component component, Container container, int n) {
        Serializable serializable;
        this.checkTreeLock();
        if (container != this) {
            if (n == -1) {
                this.component.add(component);
            } else {
                this.component.add(n, component);
            }
            component.parent = this;
            component.setGraphicsConfiguration(this.getGraphicsConfiguration());
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            this.adjustDescendants(component.countHierarchyMembers());
        } else if (n < this.component.size()) {
            this.component.set(n, component);
        }
        this.invalidateIfValid();
        if (this.peer != null) {
            if (component.peer == null) {
                component.addNotify();
            } else {
                serializable = this.getHeavyweightContainer();
                Container container2 = container.getHeavyweightContainer();
                if (container2 != serializable) {
                    ((Container)serializable).reparentChild(component);
                }
                component.updateZOrder();
                if (!component.isLightweight() && this.isLightweight()) {
                    component.relocateComponent();
                }
            }
        }
        if (container != this) {
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, null);
                } else {
                    this.layoutMgr.addLayoutComponent(null, component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                serializable = new ContainerEvent(this, 300, component);
                this.dispatchEvent((AWTEvent)serializable);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (component.isFocusOwner() && !component.canBeFocusOwnerRecursively()) {
                component.transferFocus();
            } else if (component instanceof Container && (serializable = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && this.isParentOf((Component)serializable) && !((Component)serializable).canBeFocusOwnerRecursively()) {
                ((Component)serializable).transferFocus();
            }
        } else {
            component.createHierarchyEvents(1400, component, this, 1400L, Toolkit.enabledOnToolkit(32768L));
        }
        if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
            this.updateCursorImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getComponentZOrder(Component component) {
        if (component == null) {
            return -1;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.parent != this) {
                return -1;
            }
            return this.component.indexOf(component);
        }
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            if (n > this.component.size() || n < 0 && n != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            this.checkAddToSelf(component);
            this.checkNotAWindow(component);
            if (component.parent != null) {
                component.parent.remove(component);
                if (n > this.component.size()) {
                    throw new IllegalArgumentException("illegal component position");
                }
            }
            if (graphicsConfiguration != null) {
                component.checkGD(graphicsConfiguration.getDevice().getIDstring());
            }
            if (n == -1) {
                this.component.add(component);
            } else {
                this.component.add(n, component);
            }
            component.parent = this;
            component.setGraphicsConfiguration(graphicsConfiguration);
            this.adjustListeningChildren(32768L, component.numListening(32768L));
            this.adjustListeningChildren(65536L, component.numListening(65536L));
            this.adjustDescendants(component.countHierarchyMembers());
            this.invalidateIfValid();
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, object);
                } else if (object instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)object, component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                ContainerEvent containerEvent = new ContainerEvent(this, 300, component);
                this.dispatchEvent(containerEvent);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    @Override
    boolean updateGraphicsData(GraphicsConfiguration graphicsConfiguration) {
        this.checkTreeLock();
        boolean bl = super.updateGraphicsData(graphicsConfiguration);
        for (Component component : this.component) {
            if (component == null) continue;
            bl |= component.updateGraphicsData(graphicsConfiguration);
        }
        return bl;
    }

    @Override
    void checkGD(String string) {
        for (Component component : this.component) {
            if (component == null) continue;
            component.checkGD(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0 || n >= this.component.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            Component component = this.component.get(n);
            if (this.peer != null) {
                component.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            this.adjustListeningChildren(32768L, -component.numListening(32768L));
            this.adjustListeningChildren(65536L, -component.numListening(65536L));
            this.adjustDescendants(-component.countHierarchyMembers());
            component.parent = null;
            this.component.remove(n);
            component.setGraphicsConfiguration(null);
            this.invalidateIfValid();
            if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.dispatchEvent(containerEvent);
            }
            component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n;
            if (component.parent == this && (n = this.component.indexOf(component)) >= 0) {
                this.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.adjustListeningChildren(32768L, -this.listeningChildren);
            this.adjustListeningChildren(65536L, -this.listeningBoundsChildren);
            this.adjustDescendants(-this.descendantsCount);
            while (!this.component.isEmpty()) {
                Component component = this.component.remove(this.component.size() - 1);
                if (this.peer != null) {
                    component.removeNotify();
                }
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(component);
                }
                component.parent = null;
                component.setGraphicsConfiguration(null);
                if (this.containerListener != null || (this.eventMask & 2L) != 0L || Toolkit.enabledOnToolkit(2L)) {
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.dispatchEvent(containerEvent);
                }
                component.createHierarchyEvents(1400, component, this, 1L, Toolkit.enabledOnToolkit(32768L));
            }
            if (this.peer != null && this.layoutMgr == null && this.isVisible()) {
                this.updateCursorImmediately();
            }
            this.invalidateIfValid();
        }
    }

    @Override
    int numListening(long l) {
        int n = super.numListening(l);
        if (l == 32768L) {
            if (eventLog.isLoggable(PlatformLogger.Level.FINE)) {
                int n2 = 0;
                for (Component component : this.component) {
                    n2 += component.numListening(l);
                }
                if (this.listeningChildren != n2) {
                    eventLog.fine("Assertion (listeningChildren == sum) failed");
                }
            }
            return this.listeningChildren + n;
        }
        if (l == 65536L) {
            if (eventLog.isLoggable(PlatformLogger.Level.FINE)) {
                int n3 = 0;
                for (Component component : this.component) {
                    n3 += component.numListening(l);
                }
                if (this.listeningBoundsChildren != n3) {
                    eventLog.fine("Assertion (listeningBoundsChildren == sum) failed");
                }
            }
            return this.listeningBoundsChildren + n;
        }
        if (eventLog.isLoggable(PlatformLogger.Level.FINE)) {
            eventLog.fine("This code must never be reached");
        }
        return n;
    }

    void adjustListeningChildren(long l, int n) {
        if (eventLog.isLoggable(PlatformLogger.Level.FINE)) {
            boolean bl;
            boolean bl2 = bl = l == 32768L || l == 65536L || l == 98304L;
            if (!bl) {
                eventLog.fine("Assertion failed");
            }
        }
        if (n == 0) {
            return;
        }
        if ((l & 0x8000L) != 0L) {
            this.listeningChildren += n;
        }
        if ((l & 0x10000L) != 0L) {
            this.listeningBoundsChildren += n;
        }
        this.adjustListeningChildrenOnParent(l, n);
    }

    void adjustDescendants(int n) {
        if (n == 0) {
            return;
        }
        this.descendantsCount += n;
        this.adjustDecendantsOnParent(n);
    }

    void adjustDecendantsOnParent(int n) {
        if (this.parent != null) {
            this.parent.adjustDescendants(n);
        }
    }

    @Override
    int countHierarchyMembers() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            int n = 0;
            for (Component component : this.component) {
                n += component.countHierarchyMembers();
            }
            if (this.descendantsCount != n) {
                log.fine("Assertion (descendantsCount == sum) failed");
            }
        }
        return this.descendantsCount + 1;
    }

    private int getListenersCount(int n, boolean bl) {
        this.checkTreeLock();
        if (bl) {
            return this.descendantsCount;
        }
        switch (n) {
            case 1400: {
                return this.listeningChildren;
            }
            case 1401: 
            case 1402: {
                return this.listeningBoundsChildren;
            }
        }
        return 0;
    }

    @Override
    final int createHierarchyEvents(int n, Component component, Container container, long l, boolean bl) {
        int n2;
        this.checkTreeLock();
        int n3 = n2 = this.getListenersCount(n, bl);
        int n4 = 0;
        while (n3 > 0) {
            n3 -= this.component.get(n4).createHierarchyEvents(n, component, container, l, bl);
            ++n4;
        }
        return n2 + super.createHierarchyEvents(n, component, container, l, bl);
    }

    final void createChildHierarchyEvents(int n, long l, boolean bl) {
        int n2;
        this.checkTreeLock();
        if (this.component.isEmpty()) {
            return;
        }
        int n3 = n2 = this.getListenersCount(n, bl);
        int n4 = 0;
        while (n3 > 0) {
            n3 -= this.component.get(n4).createHierarchyEvents(n, this, this.parent, l, bl);
            ++n4;
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        this.invalidateIfValid();
    }

    @Override
    public void doLayout() {
        this.layout();
    }

    @Override
    @Deprecated
    public void layout() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            layoutManager.layoutContainer(this);
        }
    }

    public boolean isValidateRoot() {
        return false;
    }

    @Override
    void invalidateParent() {
        if (!isJavaAwtSmartInvalidate || !this.isValidateRoot()) {
            super.invalidateParent();
        }
    }

    @Override
    public void invalidate() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            layoutManager2.invalidateLayout(this);
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() {
        boolean bl = false;
        Object object = this.getTreeLock();
        synchronized (object) {
            if ((!this.isValid() || descendUnconditionallyWhenValidating) && this.peer != null) {
                ContainerPeer containerPeer = null;
                if (this.peer instanceof ContainerPeer) {
                    containerPeer = (ContainerPeer)this.peer;
                }
                if (containerPeer != null) {
                    containerPeer.beginValidate();
                }
                this.validateTree();
                if (containerPeer != null) {
                    containerPeer.endValidate();
                    if (!descendUnconditionallyWhenValidating) {
                        bl = this.isVisible();
                    }
                }
            }
        }
        if (bl) {
            this.updateCursorImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void validateUnconditionally() {
        boolean bl = false;
        Object object = this.getTreeLock();
        synchronized (object) {
            descendUnconditionallyWhenValidating = true;
            this.validate();
            if (this.peer instanceof ContainerPeer) {
                bl = this.isVisible();
            }
            descendUnconditionallyWhenValidating = false;
        }
        if (bl) {
            this.updateCursorImmediately();
        }
    }

    protected void validateTree() {
        this.checkTreeLock();
        if (!this.isValid() || descendUnconditionallyWhenValidating) {
            if (this.peer instanceof ContainerPeer) {
                ((ContainerPeer)this.peer).beginLayout();
            }
            if (!this.isValid()) {
                this.doLayout();
            }
            for (int i = 0; i < this.component.size(); ++i) {
                Component component = this.component.get(i);
                if (component instanceof Container && !(component instanceof Window) && (!component.isValid() || descendUnconditionallyWhenValidating)) {
                    ((Container)component).validateTree();
                    continue;
                }
                component.validate();
            }
            if (this.peer instanceof ContainerPeer) {
                ((ContainerPeer)this.peer).endLayout();
            }
        }
        super.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.component.size(); ++i) {
                Component component = this.component.get(i);
                if (component instanceof Container) {
                    ((Container)component).invalidateTree();
                    continue;
                }
                component.invalidateIfValid();
            }
            this.invalidateIfValid();
        }
    }

    @Override
    public void setFont(Font font) {
        boolean bl = false;
        Font font2 = this.getFont();
        super.setFont(font);
        Font font3 = this.getFont();
        if (!(font3 == font2 || font2 != null && font2.equals(font3))) {
            this.invalidateTree();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension == null || !this.isPreferredSizeSet() && !this.isValid()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                dimension = this.prefSize = this.layoutMgr != null ? this.layoutMgr.preferredLayoutSize(this) : super.preferredSize();
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension == null || !this.isMinimumSizeSet() && !this.isValid()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                dimension = this.minSize = this.layoutMgr != null ? this.layoutMgr.minimumLayoutSize(this) : super.minimumSize();
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = this.maxSize;
        if (dimension == null || !this.isMaximumSizeSet() && !this.isValid()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                    this.maxSize = layoutManager2.maximumLayoutSize(this);
                } else {
                    this.maxSize = super.getMaximumSize();
                }
                dimension = this.maxSize;
            }
        }
        if (dimension != null) {
            return new Dimension(dimension);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAlignmentX() {
        float f;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f = layoutManager2.getLayoutAlignmentX(this);
            }
        } else {
            f = super.getAlignmentX();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAlignmentY() {
        float f;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f = layoutManager2.getLayoutAlignmentY(this);
            }
        } else {
            f = super.getAlignmentY();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            Object object = this.getObjectLock();
            synchronized (object) {
                if (this.printing && this.printingThreads.contains(Thread.currentThread())) {
                    return;
                }
            }
            GraphicsCallback.PaintCallback.getInstance().runComponents(this.getComponentsSync(), graphics, 2);
        }
    }

    @Override
    public void update(Graphics graphics) {
        if (this.isShowing()) {
            if (!(this.peer instanceof LightweightPeer)) {
                graphics.clearRect(0, 0, this.width, this.height);
            }
            this.paint(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics graphics) {
        if (this.isShowing()) {
            Object object;
            Thread thread = Thread.currentThread();
            try {
                object = this.getObjectLock();
                synchronized (object) {
                    if (this.printingThreads == null) {
                        this.printingThreads = new HashSet<Thread>();
                    }
                    this.printingThreads.add(thread);
                    this.printing = true;
                }
                super.print(graphics);
            }
            catch (Throwable throwable) {
                Object object2 = this.getObjectLock();
                synchronized (object2) {
                    this.printingThreads.remove(thread);
                    this.printing = !this.printingThreads.isEmpty();
                }
                throw throwable;
            }
            object = this.getObjectLock();
            synchronized (object) {
                this.printingThreads.remove(thread);
                this.printing = !this.printingThreads.isEmpty();
            }
            GraphicsCallback.PrintCallback.getInstance().runComponents(this.getComponentsSync(), graphics, 2);
        }
    }

    public void paintComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintAllCallback.getInstance().runComponents(this.getComponentsSync(), graphics, 4);
        }
    }

    @Override
    void lightweightPaint(Graphics graphics) {
        super.lightweightPaint(graphics);
        this.paintHeavyweightComponents(graphics);
    }

    @Override
    void paintHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PaintHeavyweightComponentsCallback.getInstance().runComponents(this.getComponentsSync(), graphics, 3);
        }
    }

    public void printComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintAllCallback.getInstance().runComponents(this.getComponentsSync(), graphics, 4);
        }
    }

    @Override
    void lightweightPrint(Graphics graphics) {
        super.lightweightPrint(graphics);
        this.printHeavyweightComponents(graphics);
    }

    @Override
    void printHeavyweightComponents(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(this.getComponentsSync(), graphics, 3);
        }
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])this.getListeners(ContainerListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        ContainerListener containerListener = null;
        if (clazz != ContainerListener.class) {
            return super.getListeners(clazz);
        }
        containerListener = this.containerListener;
        return AWTEventMulticaster.getListeners((EventListener)containerListener, clazz);
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (n == 300 || n == 301) {
            return (this.eventMask & 2L) != 0L || this.containerListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        ContainerListener containerListener = this.containerListener;
        if (containerListener != null) {
            switch (containerEvent.getID()) {
                case 300: {
                    containerListener.componentAdded(containerEvent);
                    break;
                }
                case 301: {
                    containerListener.componentRemoved(containerEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.dispatcher != null && this.dispatcher.dispatchEvent(aWTEvent)) {
            aWTEvent.consume();
            if (this.peer != null) {
                this.peer.handleEvent(aWTEvent);
            }
            return;
        }
        super.dispatchEventImpl(aWTEvent);
        Object object = this.getTreeLock();
        synchronized (object) {
            switch (aWTEvent.getID()) {
                case 101: {
                    this.createChildHierarchyEvents(1402, 0L, Toolkit.enabledOnToolkit(65536L));
                    break;
                }
                case 100: {
                    this.createChildHierarchyEvents(1401, 0L, Toolkit.enabledOnToolkit(65536L));
                    break;
                }
            }
        }
    }

    void dispatchEventToSelf(AWTEvent aWTEvent) {
        super.dispatchEventImpl(aWTEvent);
    }

    Component getMouseEventTarget(int n, int n2, boolean bl) {
        return this.getMouseEventTarget(n, n2, bl, MouseEventTargetFilter.FILTER, false);
    }

    Component getDropTargetEventTarget(int n, int n2, boolean bl) {
        return this.getMouseEventTarget(n, n2, bl, DropTargetEventTargetFilter.FILTER, true);
    }

    private Component getMouseEventTarget(int n, int n2, boolean bl, EventTargetFilter eventTargetFilter, boolean bl2) {
        Component component = null;
        if (bl2) {
            component = this.getMouseEventTargetImpl(n, n2, bl, eventTargetFilter, true, bl2);
        }
        if (component == null || component == this) {
            component = this.getMouseEventTargetImpl(n, n2, bl, eventTargetFilter, false, bl2);
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getMouseEventTargetImpl(int n, int n2, boolean bl, EventTargetFilter eventTargetFilter, boolean bl2, boolean bl3) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3;
            for (n3 = 0; n3 < this.component.size(); ++n3) {
                Component component = this.component.get(n3);
                if (component == null || !component.visible || (bl2 || !(component.peer instanceof LightweightPeer)) && (!bl2 || component.peer instanceof LightweightPeer) || !component.contains(n - component.x, n2 - component.y)) continue;
                if (component instanceof Container) {
                    Container container = (Container)component;
                    Component component2 = container.getMouseEventTarget(n - container.x, n2 - container.y, bl, eventTargetFilter, bl3);
                    if (component2 == null) continue;
                    return component2;
                }
                if (!eventTargetFilter.accept(component)) continue;
                return component;
            }
            n3 = this.peer instanceof LightweightPeer || bl ? 1 : 0;
            boolean bl4 = this.contains(n, n2);
            if (bl4 && n3 != 0 && eventTargetFilter.accept(this)) {
                return this;
            }
            return null;
        }
    }

    void proxyEnableEvents(long l) {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent != null) {
                this.parent.proxyEnableEvents(l);
            }
        } else if (this.dispatcher != null) {
            this.dispatcher.enableEvents(l);
        }
    }

    @Override
    @Deprecated
    public void deliverEvent(Event event) {
        Component component = this.getComponentAt(event.x, event.y);
        if (component != null && component != this) {
            event.translate(-component.x, -component.y);
            component.deliverEvent(event);
        } else {
            this.postEvent(event);
        }
    }

    @Override
    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Component locate(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        Component component = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            for (Component component2 : this.component) {
                if (!component2.contains(n - component2.x, n2 - component2.y)) continue;
                if (!component2.isLightweight()) {
                    return component2;
                }
                if (component != null) continue;
                component = component2;
            }
        }
        return component != null ? component : this;
    }

    @Override
    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getMousePosition(boolean bl) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        PointerInfo pointerInfo = AccessController.doPrivileged(new PrivilegedAction<PointerInfo>(){

            @Override
            public PointerInfo run() {
                return MouseInfo.getPointerInfo();
            }
        });
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.findUnderMouseInWindow(pointerInfo);
            if (this.isSameOrAncestorOf(component, bl)) {
                return this.pointRelativeToComponent(pointerInfo.getLocation());
            }
            return null;
        }
    }

    @Override
    boolean isSameOrAncestorOf(Component component, boolean bl) {
        return this == component || bl && this.isParentOf(component);
    }

    public Component findComponentAt(int n, int n2) {
        return this.findComponentAt(n, n2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Component findComponentAt(int n, int n2, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isRecursivelyVisible()) {
                return this.findComponentAtImpl(n, n2, bl);
            }
        }
        return null;
    }

    final Component findComponentAtImpl(int n, int n2, boolean bl) {
        if (!this.contains(n, n2) || !this.visible || !bl && !this.enabled) {
            return null;
        }
        Component component = null;
        for (Component component2 : this.component) {
            int n3;
            int n4;
            if (!component2.contains(n4 = n - component2.x, n3 = n2 - component2.y)) continue;
            if (!component2.isLightweight()) {
                Component component3 = Container.getChildAt(component2, n4, n3, bl);
                if (component3 == null) continue;
                return component3;
            }
            if (component != null) continue;
            component = Container.getChildAt(component2, n4, n3, bl);
        }
        return component != null ? component : this;
    }

    private static Component getChildAt(Component component, int n, int n2, boolean bl) {
        if ((component = component instanceof Container ? ((Container)component).findComponentAtImpl(n, n2, bl) : component.getComponentAt(n, n2)) != null && component.visible && (bl || component.enabled)) {
            return component;
        }
        return null;
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (!(this.peer instanceof LightweightPeer)) {
                this.dispatcher = new LightweightDispatcher(this);
            }
            for (int i = 0; i < this.component.size(); ++i) {
                this.component.get(i).addNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = this.component.size() - 1; i >= 0; --i) {
                Component component = this.component.get(i);
                if (component == null) continue;
                component.setAutoFocusTransferOnDisposal(false);
                component.removeNotify();
                component.setAutoFocusTransferOnDisposal(true);
            }
            if (this.containsFocus() && KeyboardFocusManager.isAutoFocusTransferEnabledFor(this) && !this.transferFocus(false)) {
                this.transferFocusBackward(true);
            }
            if (this.dispatcher != null) {
                this.dispatcher.dispose();
                this.dispatcher = null;
            }
            super.removeNotify();
        }
    }

    public boolean isAncestorOf(Component component) {
        Container container;
        if (component == null || (container = component.getParent()) == null) {
            return false;
        }
        while (container != null) {
            if (container == this) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLWModal() {
        Container container;
        Component component;
        this.modalAppContext = AppContext.getAppContext();
        long l = Toolkit.getEventQueue().getMostRecentKeyEventTime();
        Component component2 = component = Component.isInstanceOf(this, "javax.swing.JInternalFrame") ? ((JInternalFrame)this).getMostRecentFocusOwner() : null;
        if (component != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().enqueueKeyEvents(l, component);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            container = this.getHeavyweightContainer();
            if (container.modalComp != null) {
                this.modalComp = container.modalComp;
                container.modalComp = this;
                return;
            }
            container.modalComp = this;
        }
        object = new Runnable(){

            @Override
            public void run() {
                EventDispatchThread eventDispatchThread = (EventDispatchThread)Thread.currentThread();
                eventDispatchThread.pumpEventsForHierarchy(new Conditional(){

                    @Override
                    public boolean evaluate() {
                        return Container.this.windowClosingException == null && container.modalComp != null;
                    }
                }, Container.this);
            }
        };
        if (EventQueue.isDispatchThread()) {
            SequencedEvent sequencedEvent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentSequencedEvent();
            if (sequencedEvent != null) {
                sequencedEvent.dispose();
            }
            object.run();
        } else {
            Object object2 = this.getTreeLock();
            synchronized (object2) {
                Toolkit.getEventQueue().postEvent(new PeerEvent(this, (Runnable)object, 1L));
                while (this.windowClosingException == null && container.modalComp != null) {
                    try {
                        this.getTreeLock().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        if (this.windowClosingException != null) {
            this.windowClosingException.fillInStackTrace();
            throw this.windowClosingException;
        }
        if (component != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().dequeueKeyEvents(l, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLWModal() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.modalAppContext != null) {
                Container container = this.getHeavyweightContainer();
                if (container != null) {
                    if (this.modalComp != null) {
                        container.modalComp = this.modalComp;
                        this.modalComp = null;
                        return;
                    }
                    container.modalComp = null;
                }
                SunToolkit.postEvent(this.modalAppContext, new PeerEvent(this, new WakingRunnable(), 1L));
            }
            EventQueue.invokeLater(new WakingRunnable());
            this.getTreeLock().notifyAll();
        }
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            string = string + ",layout=" + layoutManager.getClass().getName();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void list(PrintStream printStream, int n) {
        super.list(printStream, n);
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.component.size(); ++i) {
                Component component = this.component.get(i);
                if (component == null) continue;
                component.list(printStream, n + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void list(PrintWriter printWriter, int n) {
        super.list(printWriter, n);
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.component.size(); ++i) {
                Component component = this.component.get(i);
                if (component == null) continue;
                component.list(printWriter, n + 1);
            }
        }
    }

    @Override
    public void setFocusTraversalKeys(int n, Set<? extends AWTKeyStroke> set) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        this.setFocusTraversalKeys_NoIDCheck(n, set);
    }

    @Override
    public Set<AWTKeyStroke> getFocusTraversalKeys(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.getFocusTraversalKeys_NoIDCheck(n);
    }

    @Override
    public boolean areFocusTraversalKeysSet(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n] != null;
    }

    @Override
    public boolean isFocusCycleRoot(Container container) {
        if (this.isFocusCycleRoot() && container == this) {
            return true;
        }
        return super.isFocusCycleRoot(container);
    }

    private Container findTraversalRoot() {
        Container container;
        Container container2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot();
        if (container2 == this) {
            container = this;
        } else {
            container = this.getFocusCycleRootAncestor();
            if (container == null) {
                container = this;
            }
        }
        if (container != container2) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRootPriv(container);
        }
        return container;
    }

    @Override
    final boolean containsFocus() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return this.isParentOf(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isParentOf(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            while (component != null && component != this && !(component instanceof Window)) {
                component = component.getParent();
            }
            return component == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    void clearMostRecentFocusOwnerOnHide() {
        boolean bl = false;
        Window window = null;
        Object object = this.getTreeLock();
        // MONITORENTER : object
        window = this.getContainingWindow();
        if (window != null) {
            Component component = KeyboardFocusManager.getMostRecentFocusOwner(window);
            bl = component == this || this.isParentOf(component);
            Class<KeyboardFocusManager> clazz = KeyboardFocusManager.class;
            // MONITORENTER : java.awt.KeyboardFocusManager.class
            Component component2 = window.getTemporaryLostComponent();
            if (this.isParentOf(component2) || component2 == this) {
                window.setTemporaryLostComponent(null);
            }
            // MONITOREXIT : clazz
        }
        // MONITOREXIT : object
        if (!bl) return;
        KeyboardFocusManager.setMostRecentFocusOwner(window, null);
    }

    @Override
    void clearCurrentFocusCycleRootOnHide() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Container container = keyboardFocusManager.getCurrentFocusCycleRoot();
        if (container == this || this.isParentOf(container)) {
            keyboardFocusManager.setGlobalCurrentFocusCycleRootPriv(null);
        }
    }

    @Override
    final Container getTraversalRoot() {
        if (this.isFocusCycleRoot()) {
            return this.findTraversalRoot();
        }
        return super.getTraversalRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        FocusTraversalPolicy focusTraversalPolicy2;
        Container container = this;
        synchronized (container) {
            focusTraversalPolicy2 = this.focusTraversalPolicy;
            this.focusTraversalPolicy = focusTraversalPolicy;
        }
        this.firePropertyChange("focusTraversalPolicy", focusTraversalPolicy2, focusTraversalPolicy);
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusTraversalPolicyProvider() && !this.isFocusCycleRoot()) {
            return null;
        }
        FocusTraversalPolicy focusTraversalPolicy = this.focusTraversalPolicy;
        if (focusTraversalPolicy != null) {
            return focusTraversalPolicy;
        }
        Container container = this.getFocusCycleRootAncestor();
        if (container != null) {
            return container.getFocusTraversalPolicy();
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy();
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusCycleRoot(boolean bl) {
        boolean bl2;
        Container container = this;
        synchronized (container) {
            bl2 = this.focusCycleRoot;
            this.focusCycleRoot = bl;
        }
        this.firePropertyChange("focusCycleRoot", bl2, bl);
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFocusTraversalPolicyProvider(boolean bl) {
        boolean bl2;
        Container container = this;
        synchronized (container) {
            bl2 = this.focusTraversalPolicyProvider;
            this.focusTraversalPolicyProvider = bl;
        }
        this.firePropertyChange("focusTraversalPolicyProvider", bl2, bl);
    }

    public final boolean isFocusTraversalPolicyProvider() {
        return this.focusTraversalPolicyProvider;
    }

    public void transferFocusDownCycle() {
        if (this.isFocusCycleRoot()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRootPriv(this);
            Component component = this.getFocusTraversalPolicy().getDefaultComponent(this);
            if (component != null) {
                component.requestFocus(CausedFocusEvent.Cause.TRAVERSAL_DOWN);
            }
        }
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.preProcessKeyEvent(keyEvent);
        }
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.postProcessKeyEvent(keyEvent);
        }
    }

    @Override
    boolean postsOldMouseEvents() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.component.size(); ++i) {
                Component component = this.component.get(i);
                component.applyComponentOrientation(componentOrientation);
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("ncomponents", this.component.size());
        putField.put("component", this.component.toArray(EMPTY_ARRAY));
        putField.put("layoutMgr", this.layoutMgr);
        putField.put("dispatcher", this.dispatcher);
        putField.put("maxSize", this.maxSize);
        putField.put("focusCycleRoot", this.focusCycleRoot);
        putField.put("containerSerializedDataVersion", this.containerSerializedDataVersion);
        putField.put("focusTraversalPolicyProvider", this.focusTraversalPolicyProvider);
        objectOutputStream.writeFields();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        objectOutputStream.writeObject(null);
        if (this.focusTraversalPolicy instanceof Serializable) {
            objectOutputStream.writeObject(this.focusTraversalPolicy);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        block10: {
            Object object;
            int n;
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            Component[] componentArray = (Component[])getField.get("component", null);
            if (componentArray == null) {
                componentArray = EMPTY_ARRAY;
            }
            if ((n = Integer.valueOf(getField.get("ncomponents", 0)).intValue()) < 0 || n > componentArray.length) {
                throw new InvalidObjectException("Incorrect number of components");
            }
            this.component = new ArrayList<Component>(n);
            for (int i = 0; i < n; ++i) {
                this.component.add(componentArray[i]);
            }
            this.layoutMgr = (LayoutManager)getField.get("layoutMgr", null);
            this.dispatcher = (LightweightDispatcher)getField.get("dispatcher", null);
            if (this.maxSize == null) {
                this.maxSize = (Dimension)getField.get("maxSize", null);
            }
            this.focusCycleRoot = getField.get("focusCycleRoot", false);
            this.containerSerializedDataVersion = getField.get("containerSerializedDataVersion", 1);
            this.focusTraversalPolicyProvider = getField.get("focusTraversalPolicyProvider", false);
            List<Component> list = this.component;
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                ((Component)object).parent = this;
                this.adjustListeningChildren(32768L, ((Component)object).numListening(32768L));
                this.adjustListeningChildren(65536L, ((Component)object).numListening(65536L));
                this.adjustDescendants(((Component)object).countHierarchyMembers());
            }
            while (null != (object2 = objectInputStream.readObject())) {
                object = ((String)object2).intern();
                if ("containerL" == object) {
                    this.addContainerListener((ContainerListener)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
            try {
                object = objectInputStream.readObject();
                if (object instanceof FocusTraversalPolicy) {
                    this.focusTraversalPolicy = (FocusTraversalPolicy)object;
                }
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block10;
                throw optionalDataException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessible getAccessibleAt(Point point) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)this);
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext != null) {
                    int n = accessibleContext.getAccessibleChildrenCount();
                    for (int i = 0; i < n; ++i) {
                        AccessibleComponent accessibleComponent;
                        accessible = accessibleContext.getAccessibleChild(i);
                        if (accessible == null || (accessibleContext = accessible.getAccessibleContext()) == null || (accessibleComponent = accessibleContext.getAccessibleComponent()) == null || !accessibleComponent.isShowing()) continue;
                        Point point2 = accessibleComponent.getLocation();
                        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                        if (!accessibleComponent.contains(point3)) continue;
                        return accessible;
                    }
                }
                return (Accessible)((Object)this);
            }
            Component component = this;
            if (!this.contains(point.x, point.y)) {
                component = null;
            } else {
                int n = this.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component2 = this.getComponent(i);
                    if (component2 == null || !component2.isShowing()) continue;
                    Point point4 = component2.getLocation();
                    if (!component2.contains(point.x - point4.x, point.y - point4.y)) continue;
                    component = component2;
                }
            }
            if (component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccessibleChildrenCount() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessible getAccessibleChild(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                if (n2 == n) {
                    return (Accessible)((Object)componentArray[i]);
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void increaseComponentCount(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!component.isDisplayable()) {
                throw new IllegalStateException("Peer does not exist while invoking the increaseComponentCount() method");
            }
            int n = 0;
            int n2 = 0;
            if (component instanceof Container) {
                n2 = ((Container)component).numOfLWComponents;
                n = ((Container)component).numOfHWComponents;
            }
            if (component.isLightweight()) {
                ++n2;
            } else {
                ++n;
            }
            for (Container container = this; container != null; container = container.getContainer()) {
                container.numOfLWComponents += n2;
                container.numOfHWComponents += n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void decreaseComponentCount(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!component.isDisplayable()) {
                throw new IllegalStateException("Peer does not exist while invoking the decreaseComponentCount() method");
            }
            int n = 0;
            int n2 = 0;
            if (component instanceof Container) {
                n2 = ((Container)component).numOfLWComponents;
                n = ((Container)component).numOfHWComponents;
            }
            if (component.isLightweight()) {
                ++n2;
            } else {
                ++n;
            }
            for (Container container = this; container != null; container = container.getContainer()) {
                container.numOfLWComponents -= n2;
                container.numOfHWComponents -= n;
            }
        }
    }

    private int getTopmostComponentIndex() {
        this.checkTreeLock();
        if (this.getComponentCount() > 0) {
            return 0;
        }
        return -1;
    }

    private int getBottommostComponentIndex() {
        this.checkTreeLock();
        if (this.getComponentCount() > 0) {
            return this.getComponentCount() - 1;
        }
        return -1;
    }

    @Override
    final Region getOpaqueShape() {
        this.checkTreeLock();
        if (this.isLightweight() && this.isNonOpaqueForMixing() && this.hasLightweightDescendants()) {
            Region region = Region.EMPTY_REGION;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!component.isLightweight() || !component.isShowing()) continue;
                region = region.getUnion(component.getOpaqueShape());
            }
            return region.getIntersection(this.getNormalShape());
        }
        return super.getOpaqueShape();
    }

    final void recursiveSubtractAndApplyShape(Region region) {
        this.recursiveSubtractAndApplyShape(region, this.getTopmostComponentIndex(), this.getBottommostComponentIndex());
    }

    final void recursiveSubtractAndApplyShape(Region region, int n) {
        this.recursiveSubtractAndApplyShape(region, n, this.getBottommostComponentIndex());
    }

    final void recursiveSubtractAndApplyShape(Region region, int n, int n2) {
        this.checkTreeLock();
        if (mixingLog.isLoggable(PlatformLogger.Level.FINE)) {
            mixingLog.fine("this = " + this + "; shape=" + region + "; fromZ=" + n + "; toZ=" + n2);
        }
        if (n == -1) {
            return;
        }
        if (region.isEmpty()) {
            return;
        }
        if (this.getLayout() != null && !this.isValid()) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            Component component = this.getComponent(i);
            if (!component.isLightweight()) {
                component.subtractAndApplyShape(region);
                continue;
            }
            if (!(component instanceof Container) || !((Container)component).hasHeavyweightDescendants() || !component.isShowing()) continue;
            ((Container)component).recursiveSubtractAndApplyShape(region);
        }
    }

    final void recursiveApplyCurrentShape() {
        this.recursiveApplyCurrentShape(this.getTopmostComponentIndex(), this.getBottommostComponentIndex());
    }

    final void recursiveApplyCurrentShape(int n) {
        this.recursiveApplyCurrentShape(n, this.getBottommostComponentIndex());
    }

    final void recursiveApplyCurrentShape(int n, int n2) {
        this.checkTreeLock();
        if (mixingLog.isLoggable(PlatformLogger.Level.FINE)) {
            mixingLog.fine("this = " + this + "; fromZ=" + n + "; toZ=" + n2);
        }
        if (n == -1) {
            return;
        }
        if (this.getLayout() != null && !this.isValid()) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            Component component = this.getComponent(i);
            if (!component.isLightweight()) {
                component.applyCurrentShape();
            }
            if (!(component instanceof Container) || !((Container)component).hasHeavyweightDescendants()) continue;
            ((Container)component).recursiveApplyCurrentShape();
        }
    }

    private void recursiveShowHeavyweightChildren() {
        if (!this.hasHeavyweightDescendants() || !this.isVisible()) {
            return;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ComponentPeer componentPeer;
            Component component = this.getComponent(i);
            if (component.isLightweight()) {
                if (!(component instanceof Container)) continue;
                ((Container)component).recursiveShowHeavyweightChildren();
                continue;
            }
            if (!component.isVisible() || (componentPeer = component.getPeer()) == null) continue;
            componentPeer.setVisible(true);
        }
    }

    private void recursiveHideHeavyweightChildren() {
        if (!this.hasHeavyweightDescendants()) {
            return;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ComponentPeer componentPeer;
            Component component = this.getComponent(i);
            if (component.isLightweight()) {
                if (!(component instanceof Container)) continue;
                ((Container)component).recursiveHideHeavyweightChildren();
                continue;
            }
            if (!component.isVisible() || (componentPeer = component.getPeer()) == null) continue;
            componentPeer.setVisible(false);
        }
    }

    private void recursiveRelocateHeavyweightChildren(Point point) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Object object;
            Component component = this.getComponent(i);
            if (component.isLightweight()) {
                if (!(component instanceof Container) || !((Container)component).hasHeavyweightDescendants()) continue;
                object = new Point(point);
                ((Point)object).translate(component.getX(), component.getY());
                ((Container)component).recursiveRelocateHeavyweightChildren((Point)object);
                continue;
            }
            object = component.getPeer();
            if (object == null) continue;
            object.setBounds(point.x + component.getX(), point.y + component.getY(), component.getWidth(), component.getHeight(), 1);
        }
    }

    final boolean isRecursivelyVisibleUpToHeavyweightContainer() {
        if (!this.isLightweight()) {
            return true;
        }
        for (Container container = this; container != null && container.isLightweight(); container = container.getContainer()) {
            if (container.isVisible()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mixOnShowing() {
        Object object = this.getTreeLock();
        synchronized (object) {
            boolean bl;
            if (mixingLog.isLoggable(PlatformLogger.Level.FINE)) {
                mixingLog.fine("this = " + this);
            }
            if ((bl = this.isLightweight()) && this.isRecursivelyVisibleUpToHeavyweightContainer()) {
                this.recursiveShowHeavyweightChildren();
            }
            if (!this.isMixingNeeded()) {
                return;
            }
            if (!bl || bl && this.hasHeavyweightDescendants()) {
                this.recursiveApplyCurrentShape();
            }
            super.mixOnShowing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mixOnHiding(boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (mixingLog.isLoggable(PlatformLogger.Level.FINE)) {
                mixingLog.fine("this = " + this + "; isLightweight=" + bl);
            }
            if (bl) {
                this.recursiveHideHeavyweightChildren();
            }
            super.mixOnHiding(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mixOnReshaping() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (mixingLog.isLoggable(PlatformLogger.Level.FINE)) {
                mixingLog.fine("this = " + this);
            }
            boolean bl = this.isMixingNeeded();
            if (this.isLightweight() && this.hasHeavyweightDescendants()) {
                Point point = new Point(this.getX(), this.getY());
                for (Container container = this.getContainer(); container != null && container.isLightweight(); container = container.getContainer()) {
                    point.translate(container.getX(), container.getY());
                }
                this.recursiveRelocateHeavyweightChildren(point);
                if (!bl) {
                    return;
                }
                this.recursiveApplyCurrentShape();
            }
            if (!bl) {
                return;
            }
            super.mixOnReshaping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mixOnZOrderChanging(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            boolean bl;
            if (mixingLog.isLoggable(PlatformLogger.Level.FINE)) {
                mixingLog.fine("this = " + this + "; oldZ=" + n + "; newZ=" + n2);
            }
            if (!this.isMixingNeeded()) {
                return;
            }
            boolean bl2 = bl = n2 < n;
            if (bl && this.isLightweight() && this.hasHeavyweightDescendants()) {
                this.recursiveApplyCurrentShape();
            }
            super.mixOnZOrderChanging(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mixOnValidating() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (mixingLog.isLoggable(PlatformLogger.Level.FINE)) {
                mixingLog.fine("this = " + this);
            }
            if (!this.isMixingNeeded()) {
                return;
            }
            if (this.hasHeavyweightDescendants()) {
                this.recursiveApplyCurrentShape();
            }
            if (this.isLightweight() && this.isNonOpaqueForMixing()) {
                this.subtractAndApplyShapeBelowMe();
            }
            super.mixOnValidating();
        }
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Container.initIDs();
        }
        AWTAccessor.setContainerAccessor(new AWTAccessor.ContainerAccessor(){

            @Override
            public void validateUnconditionally(Container container) {
                container.validateUnconditionally();
            }

            @Override
            public Component findComponentAt(Container container, int n, int n2, boolean bl) {
                return container.findComponentAt(n, n2, bl);
            }
        });
        isJavaAwtSmartInvalidate = AccessController.doPrivileged(new GetBooleanAction("java.awt.smartInvalidate"));
        descendUnconditionallyWhenValidating = false;
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = 5081320404842566097L;
        private volatile transient int propertyListenersCount;
        protected ContainerListener accessibleContainerHandler;

        protected AccessibleAWTContainer() {
            super(Container.this);
            this.propertyListenersCount = 0;
            this.accessibleContainerHandler = null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return Container.this.getAccessibleChildrenCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return Container.this.getAccessibleChild(n);
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            return Container.this.getAccessibleAt(point);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
            }
            if (this.propertyListenersCount++ == 0) {
                Container.this.addContainerListener(this.accessibleContainerHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyListenersCount == 0) {
                Container.this.removeContainerListener(this.accessibleContainerHandler);
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }
    }

    static final class WakingRunnable
    implements Runnable {
        WakingRunnable() {
        }

        @Override
        public void run() {
        }
    }

    static class DropTargetEventTargetFilter
    implements EventTargetFilter {
        static final EventTargetFilter FILTER = new DropTargetEventTargetFilter();

        private DropTargetEventTargetFilter() {
        }

        @Override
        public boolean accept(Component component) {
            DropTarget dropTarget = component.getDropTarget();
            return dropTarget != null && dropTarget.isActive();
        }
    }

    static class MouseEventTargetFilter
    implements EventTargetFilter {
        static final EventTargetFilter FILTER = new MouseEventTargetFilter();

        private MouseEventTargetFilter() {
        }

        @Override
        public boolean accept(Component component) {
            return (component.eventMask & 0x20L) != 0L || (component.eventMask & 0x10L) != 0L || (component.eventMask & 0x20000L) != 0L || component.mouseListener != null || component.mouseMotionListener != null || component.mouseWheelListener != null;
        }
    }

    static interface EventTargetFilter {
        public boolean accept(Component var1);
    }
}

