/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import sun.awt.AWTAccessor;

public class Menu
extends MenuItem
implements MenuContainer,
Accessible {
    Vector<MenuComponent> items = new Vector();
    boolean tearOff;
    boolean isHelpMenu;
    private static final String base = "menu";
    private static int nameCounter;
    private static final long serialVersionUID = -8809584163345499784L;
    private int menuSerializedDataVersion = 1;

    public Menu() throws HeadlessException {
        this("", false);
    }

    public Menu(String string) throws HeadlessException {
        this(string, false);
    }

    public Menu(String string, boolean bl) throws HeadlessException {
        super(string);
        this.tearOff = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Menu> clazz = Menu.class;
        synchronized (Menu.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenu(this);
            }
            int n = this.getItemCount();
            for (int i = 0; i < n; ++i) {
                MenuItem menuItem = this.getItem(i);
                menuItem.parent = this;
                menuItem.addNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getItemCount();
            for (int i = 0; i < n; ++i) {
                this.getItem(i).removeNotify();
            }
            super.removeNotify();
        }
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    @Deprecated
    public int countItems() {
        return this.countItemsImpl();
    }

    final int countItemsImpl() {
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        return this.getItemImpl(n);
    }

    final MenuItem getItemImpl(int n) {
        return (MenuItem)this.items.elementAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem add(MenuItem menuItem) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menuItem.parent != null) {
                menuItem.parent.remove(menuItem);
            }
            this.items.addElement(menuItem);
            menuItem.parent = this;
            MenuPeer menuPeer = (MenuPeer)this.peer;
            if (menuPeer != null) {
                menuItem.addNotify();
                menuPeer.addItem(menuItem);
            }
            return menuItem;
        }
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(MenuItem menuItem, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2;
            if (n < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n3 = this.getItemCount();
            Vector<MenuItem> vector = new Vector<MenuItem>();
            for (n2 = n; n2 < n3; ++n2) {
                vector.addElement(this.getItem(n));
                this.remove(n);
            }
            this.add(menuItem);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.add((MenuItem)vector.elementAt(n2));
            }
        }
    }

    public void insert(String string, int n) {
        this.insert(new MenuItem(string), n);
    }

    public void addSeparator() {
        this.add("-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSeparator(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2;
            if (n < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n3 = this.getItemCount();
            Vector<MenuItem> vector = new Vector<MenuItem>();
            for (n2 = n; n2 < n3; ++n2) {
                vector.addElement(this.getItem(n));
                this.remove(n);
            }
            this.addSeparator();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.add((MenuItem)vector.elementAt(n2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuItem menuItem = this.getItem(n);
            this.items.removeElementAt(n);
            MenuPeer menuPeer = (MenuPeer)this.peer;
            if (menuPeer != null) {
                menuPeer.delItem(n);
                menuItem.removeNotify();
                menuItem.parent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.items.indexOf(menuComponent);
            if (n >= 0) {
                this.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getItemCount();
            for (int i = n - 1; i >= 0; --i) {
                this.remove(i);
            }
        }
    }

    @Override
    boolean handleShortcut(KeyEvent keyEvent) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = this.getItem(i);
            if (!menuItem.handleShortcut(keyEvent)) continue;
            return true;
        }
        return false;
    }

    @Override
    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = this.getItem(i).getShortcutMenuItem(menuShortcut);
            if (menuItem == null) continue;
            return menuItem;
        }
        return null;
    }

    synchronized Enumeration<MenuShortcut> shortcuts() {
        Vector<Object> vector = new Vector<Object>();
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            MenuItem menuItem = this.getItem(i);
            if (menuItem instanceof Menu) {
                object = ((Menu)menuItem).shortcuts();
                while (object.hasMoreElements()) {
                    vector.addElement(object.nextElement());
                }
                continue;
            }
            object = menuItem.getShortcut();
            if (object == null) continue;
            vector.addElement(object);
        }
        return vector.elements();
    }

    @Override
    void deleteShortcut(MenuShortcut menuShortcut) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            this.getItem(i).deleteShortcut(menuShortcut);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, HeadlessException {
        objectInputStream.defaultReadObject();
        for (int i = 0; i < this.items.size(); ++i) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(i);
            menuItem.parent = this;
        }
    }

    @Override
    public String paramString() {
        String string = ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu;
        return super.paramString() + string;
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu();
        }
        return this.accessibleContext;
    }

    @Override
    int getAccessibleChildIndex(MenuComponent menuComponent) {
        return this.items.indexOf(menuComponent);
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Menu.initIDs();
        }
        AWTAccessor.setMenuAccessor(new AWTAccessor.MenuAccessor(){

            @Override
            public Vector<MenuComponent> getItems(Menu menu) {
                return menu.items;
            }
        });
        nameCounter = 0;
    }

    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        private static final long serialVersionUID = 5228160894980069094L;

        protected AccessibleAWTMenu() {
            super(Menu.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }
    }
}

