/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.framework.android;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProgressReport;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.framework.IFrameworkSupport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.GradleEnvironment;

public class AndroidSupport
implements IFrameworkSupport {
    public static String SYNCHRONIZATION_TASKS_API_GRADLE = "5.4";
    public static String ASSEMBLE_TASK_NAME = "assemble";

    @Override
    public void onDidProjectsImported(IProgressMonitor monitor) {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null) {
            return;
        }
        if (!preferencesManager.getPreferences().isAndroidSupportEnabled()) {
            return;
        }
        List<IProject> projects = ProjectUtils.getGradleProjects();
        if (projects.isEmpty()) {
            return;
        }
        JavaClientConnection.JavaLanguageClient client = JavaLanguageServerPlugin.getProjectsManager().getConnection();
        ProgressReport progressReport = new ProgressReport(UUID.randomUUID().toString());
        progressReport.setTask("Running Gradle tasks");
        progressReport.setComplete(false);
        progressReport.setTotalWork(1);
        progressReport.setStatus("Generating Android project sources files...");
        client.sendProgressReport(progressReport);
        HashSet<GradleBuild> processedGradleBuilds = new HashSet<GradleBuild>();
        for (IProject project : projects) {
            GradleBuild build;
            Optional gradleBuild;
            if (!ProjectUtils.isJavaProject(project) || (gradleBuild = GradleCore.getWorkspace().getBuild(project)).isEmpty() || !processedGradleBuilds.add(build = (GradleBuild)gradleBuild.get())) continue;
            try {
                GradleProject rootProject;
                String gradleVersion;
                GradleEnvironment gradleEnvironment;
                BuildEnvironment buildEnvironment = (BuildEnvironment)build.withConnection(connection -> (BuildEnvironment)connection.getModel(BuildEnvironment.class), monitor);
                if (buildEnvironment == null || (gradleEnvironment = buildEnvironment.getGradle()) == null || (gradleVersion = gradleEnvironment.getGradleVersion()) == null || GradleVersion.version((String)gradleVersion).compareTo(GradleVersion.version((String)SYNCHRONIZATION_TASKS_API_GRADLE)) >= 0 || !this.hasAndroidTasks(rootProject = (GradleProject)build.withConnection(connection -> (GradleProject)connection.getModel(GradleProject.class), monitor))) continue;
                build.withConnection(connection -> {
                    connection.newBuild().forTasks(new String[]{ASSEMBLE_TASK_NAME}).run();
                    return null;
                }, monitor);
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException(e);
            }
        }
        progressReport.setWorkDone(1);
        progressReport.setComplete(true);
        client.sendProgressReport(progressReport);
    }

    private boolean hasAndroidTasks(GradleProject project) {
        for (GradleTask task : project.getTasks()) {
            if (!"Android".equalsIgnoreCase(task.getGroup())) continue;
            return true;
        }
        for (GradleProject subProject : project.getChildren()) {
            if (!this.hasAndroidTasks(subProject)) continue;
            return true;
        }
        return false;
    }
}

