/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.util;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.apt.core.internal.AnnotationProcessorFactoryLoader;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.generatedfile.ClasspathUtil;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;
import org.eclipse.jdt.apt.core.util.AptPreferenceConstants;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.service.prefs.BackingStoreException;

public class AptConfig {
    private static final String PATHVAR_TOKEN = "^%[^%/\\\\ ]+%.*";
    private static final String PATHVAR_ROOT = "%ROOT%";
    private static final String PATHVAR_PROJECTROOT = "%PROJECT.DIR%";

    private AptConfig() {
    }

    public static void addProcessorOption(IJavaProject jproj, String key, String val) {
        if (key == null || key.length() < 1) {
            throw new IllegalArgumentException();
        }
        IScopeContext context = jproj != null ? new ProjectScope(jproj.getProject()) : InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.jdt.apt.core/org.eclipse.jdt.apt.processorOptions");
        String nonNullVal = val == null ? "org.eclipse.jdt.apt.NULLVALUE" : val;
        node.put(key, nonNullVal);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            AptPlugin.log(e, "Unable to save annotation processor option" + key);
        }
    }

    public static void removeProcessorOption(IJavaProject jproj, String key) {
        if (key == null || key.length() < 1) {
            throw new IllegalArgumentException();
        }
        IScopeContext context = jproj != null ? new ProjectScope(jproj.getProject()) : InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.jdt.apt.core/org.eclipse.jdt.apt.processorOptions");
        node.remove(key);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            AptPlugin.log(e, "Unable to save annotation processor option" + key);
        }
    }

    @Deprecated
    public static Map<String, String> getProcessorOptions(IJavaProject jproj) {
        return AptConfig.getProcessorOptions(jproj, false);
    }

    public static Map<String, String> getProcessorOptions(IJavaProject jproj, boolean isTestCode) {
        Map<String, String> rawOptions = AptConfig.getRawProcessorOptions(jproj);
        HashMap<String, String> options = new HashMap<String, String>(rawOptions.size() + 6);
        for (Map.Entry<String, String> entry : rawOptions.entrySet()) {
            String resolvedValue = AptConfig.resolveVarPath(jproj, entry.getValue());
            String value = resolvedValue == null ? entry.getValue() : resolvedValue;
            options.put(entry.getKey(), value);
        }
        if (jproj == null) {
            return options;
        }
        IWorkspaceRoot root = jproj.getProject().getWorkspace().getRoot();
        try {
            IClasspathEntry[] classpathEntries = jproj.getResolvedClasspath(true);
            LinkedHashSet<String> classpath = new LinkedHashSet<String>();
            LinkedHashSet<String> sourcepath = new LinkedHashSet<String>();
            HashSet<IJavaProject> projectsProcessed = new HashSet<IJavaProject>();
            projectsProcessed.add(jproj);
            IClasspathEntry[] iClasspathEntryArray = classpathEntries;
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (isTestCode || !entry.isTest()) {
                    IPath otherProjectPath;
                    IProject otherProject;
                    IJavaProject otherJavaProject;
                    int kind = entry.getEntryKind();
                    if (kind == 1) {
                        IPath cpPath = entry.getPath();
                        IResource res = root.findMember(cpPath);
                        if (res == null) {
                            classpath.add(cpPath.toOSString());
                        } else {
                            classpath.add(res.getLocation().toOSString());
                        }
                    } else if (kind == 3) {
                        IPath srcPath;
                        IResource res = root.findMember(entry.getPath());
                        if (res != null && (srcPath = res.getLocation()) != null) {
                            sourcepath.add(srcPath.toOSString());
                        }
                    } else if (kind == 2 && (otherJavaProject = JavaCore.create((IProject)(otherProject = root.getProject((otherProjectPath = entry.getPath()).segment(0))))) != null && otherJavaProject.getProject().isOpen()) {
                        AptConfig.addProjectClasspath(root, otherJavaProject, projectsProcessed, classpath, isTestCode);
                    }
                }
                ++n2;
            }
            options.put("-classpath", AptConfig.convertPathCollectionToString(classpath));
            options.put("-sourcepath", AptConfig.convertPathCollectionToString(sourcepath));
            IFolder genSrcDir = jproj.getProject().getFolder(isTestCode ? AptConfig.getGenTestSrcDir(jproj) : AptConfig.getGenSrcDir(jproj));
            String genSrcDirString = genSrcDir.getRawLocation().toOSString();
            options.put("-s", genSrcDirString);
            IPath binPath = isTestCode ? ClasspathUtil.findTestOutputLocation(jproj.getRawClasspath()) : jproj.getOutputLocation();
            IResource binPathResource = root.findMember(binPath);
            String binDirString = binPathResource != null ? root.findMember(binPath).getLocation().toOSString() : binPath.toOSString();
            options.put("-d", binDirString);
            String target = jproj.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
            options.put("-target", target);
            String source = jproj.getOption("org.eclipse.jdt.core.compiler.source", true);
            options.put("-source", source);
        }
        catch (JavaModelException jme) {
            AptPlugin.log(jme, "Could not get the classpath for project: " + jproj);
        }
        return options;
    }

    private static String resolveVarPath(IJavaProject jproj, String value) {
        if (value == null) {
            return null;
        }
        if (!Pattern.matches(PATHVAR_TOKEN, value)) {
            return value;
        }
        Path path = new Path(value);
        String firstToken = path.segment(0);
        if (PATHVAR_ROOT.equals(firstToken)) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource proj = root.findMember(path.segment(1));
            if (proj == null) {
                return value;
            }
            IPath relativePath = path.removeFirstSegments(2);
            IPath absoluteProjPath = proj.getLocation();
            IPath absoluteResPath = absoluteProjPath.append(relativePath);
            return absoluteResPath.toOSString();
        }
        if (jproj != null && PATHVAR_PROJECTROOT.equals(firstToken)) {
            IPath relativePath = path.removeFirstSegments(1);
            IPath absoluteProjPath = jproj.getProject().getLocation();
            IPath absoluteResPath = absoluteProjPath.append(relativePath);
            return absoluteResPath.toOSString();
        }
        String cpvName = firstToken.substring(1, firstToken.length() - 1);
        IPath cpvPath = JavaCore.getClasspathVariable((String)cpvName);
        if (cpvPath != null) {
            IPath resolved = cpvPath.append(path.removeFirstSegments(1));
            return resolved.toOSString();
        }
        return value;
    }

    private static void addProjectClasspath(IWorkspaceRoot root, IJavaProject otherJavaProject, Set<IJavaProject> projectsProcessed, Set<String> classpath, boolean isTestCode) {
        if (projectsProcessed.contains(otherJavaProject)) {
            return;
        }
        projectsProcessed.add(otherJavaProject);
        try {
            IClasspathEntry[] classpathEntries;
            String binDirString;
            IPath binPath = otherJavaProject.getOutputLocation();
            IResource binPathResource = root.findMember(binPath);
            if (binPathResource != null) {
                IPath binPathLocation = binPathResource.getLocation();
                if (binPathLocation == null) {
                    AptPlugin.logWarning(null, "Failed to resolve output location for the following project: " + otherJavaProject);
                    return;
                }
                binDirString = binPathLocation.toOSString();
            } else {
                binDirString = binPath.toOSString();
            }
            classpath.add(binDirString);
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = otherJavaProject.getResolvedClasspath(true);
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (isTestCode || !entry.isTest()) {
                    IPath otherProjectPath;
                    IProject otherProject;
                    IJavaProject yetAnotherJavaProject;
                    if (entry.getEntryKind() == 1) {
                        IPath cpPath = entry.getPath();
                        IResource res = root.findMember(cpPath);
                        if (res == null) {
                            classpath.add(cpPath.toOSString());
                        } else {
                            classpath.add(res.getLocation().toOSString());
                        }
                    } else if (entry.getEntryKind() == 2 && (yetAnotherJavaProject = JavaCore.create((IProject)(otherProject = root.getProject((otherProjectPath = entry.getPath()).segment(0))))) != null) {
                        AptConfig.addProjectClasspath(root, yetAnotherJavaProject, projectsProcessed, classpath, isTestCode);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            AptPlugin.log(jme, "Failed to get the classpath for the following project: " + otherJavaProject);
        }
    }

    private static String convertPathCollectionToString(Collection<String> paths) {
        if (paths.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String path : paths) {
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(path);
        }
        return sb.toString();
    }

    public static void setProcessorOptions(Map<String, String> options, IJavaProject jproj) {
        IScopeContext context = jproj != null ? new ProjectScope(jproj.getProject()) : InstanceScope.INSTANCE;
        AptConfig.removeOldStyleSettings(context);
        IEclipsePreferences node = context.getNode("org.eclipse.jdt.apt.core/org.eclipse.jdt.apt.processorOptions");
        try {
            node.clear();
            for (Map.Entry<String, String> option : options.entrySet()) {
                String nonNullVal = option.getValue() == null ? "org.eclipse.jdt.apt.NULLVALUE" : option.getValue();
                node.put(option.getKey(), nonNullVal);
            }
            node.flush();
        }
        catch (BackingStoreException e) {
            AptPlugin.log(e, "Unable to save annotation processor options");
        }
    }

    public static boolean isAutomaticProcessorOption(String key) {
        if ("-classpath".equals(key)) {
            return true;
        }
        if ("-sourcepath".equals(key)) {
            return true;
        }
        if ("-s".equals(key)) {
            return true;
        }
        if ("-d".equals(key)) {
            return true;
        }
        if ("-target".equals(key)) {
            return true;
        }
        return "-source".equals(key);
    }

    public static Map<String, String> getRawProcessorOptions(IJavaProject jproj) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.putAll(AptConfig.getOldStyleRawProcessorOptions(jproj));
        IScopeContext[] contexts = jproj != null ? new IScopeContext[]{new ProjectScope(jproj.getProject()), InstanceScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE};
        IScopeContext[] iScopeContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IScopeContext context = iScopeContextArray[n2];
            IEclipsePreferences prefs = context.getNode("org.eclipse.jdt.apt.core");
            try {
                IEclipsePreferences procOptionsNode;
                if (prefs.childrenNames().length > 0 && (procOptionsNode = context.getNode("org.eclipse.jdt.apt.core/org.eclipse.jdt.apt.processorOptions")) != null) {
                    String[] stringArray = procOptionsNode.keys();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String key = stringArray[n4];
                        String nonNullVal = procOptionsNode.get(key, null);
                        String val = "org.eclipse.jdt.apt.NULLVALUE".equals(nonNullVal) ? null : nonNullVal;
                        options.put(key, val);
                        ++n4;
                    }
                    break;
                }
            }
            catch (BackingStoreException e) {
                AptPlugin.log(e, "Unable to load annotation processor options");
            }
            ++n2;
        }
        return options;
    }

    private static Map<String, String> getOldStyleRawProcessorOptions(IJavaProject jproj) {
        Map<String, String> options;
        String allOptions = AptConfig.getString(jproj, "org.eclipse.jdt.apt.processorOptions");
        if (allOptions == null) {
            options = new HashMap<String, String>();
        } else {
            ProcessorOptionsParser op = new ProcessorOptionsParser(allOptions);
            options = op.parse();
        }
        return options;
    }

    private static void removeOldStyleSettings(IScopeContext context) {
        IEclipsePreferences node = context.getNode("org.eclipse.jdt.apt.core");
        node.remove("org.eclipse.jdt.apt.processorOptions");
    }

    public static void dispose() {
        try {
            InstanceScope.INSTANCE.getNode("org.eclipse.jdt.apt.core").flush();
        }
        catch (BackingStoreException e) {
            AptPlugin.log(e, "Couldn't flush preferences to disk");
        }
    }

    public static void initialize() {
    }

    public static boolean isEnabled(IJavaProject jproject) {
        if ("enabled".equals(AptConfig.getString(jproject, "org.eclipse.jdt.core.compiler.processAnnotations"))) {
            return true;
        }
        return AptConfig.getBoolean(jproject, "org.eclipse.jdt.apt.aptEnabled");
    }

    public static void setEnabled(IJavaProject jproject, boolean enabled) {
        if (jproject == null && enabled) {
            IllegalArgumentException e = new IllegalArgumentException();
            Status status = AptPlugin.createWarningStatus(e, "Illegal attempt to enable annotation processing workspace-wide");
            AptPlugin.log((IStatus)status);
            throw e;
        }
        AptConfig.setString(jproject, "org.eclipse.jdt.core.compiler.processAnnotations", enabled ? "enabled" : "disabled");
        AptConfig.setBoolean(jproject, "org.eclipse.jdt.apt.aptEnabled", enabled);
        if (enabled) {
            AptProject aptProject = AptPlugin.getAptProject(jproject);
            aptProject.getGeneratedSourceFolderManager(true).ensureFolderExists();
            aptProject.getGeneratedSourceFolderManager(false).ensureFolderExists();
        }
    }

    public static boolean shouldProcessDuringReconcile(IJavaProject jproject) {
        return AptConfig.getBoolean(jproject, "org.eclipse.jdt.apt.reconcileEnabled");
    }

    public static void setProcessDuringReconcile(IJavaProject jproject, boolean enabled) {
        AptConfig.setBoolean(jproject, "org.eclipse.jdt.apt.reconcileEnabled", enabled);
    }

    private static boolean getBoolean(IJavaProject jproj, String optionName) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] contexts = jproj != null ? new IScopeContext[]{new ProjectScope(jproj.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        return service.getBoolean("org.eclipse.jdt.apt.core", optionName, Boolean.parseBoolean(AptPreferenceConstants.DEFAULT_OPTIONS_MAP.get(optionName)), contexts);
    }

    public static IFactoryPath getDefaultFactoryPath(IJavaProject jproj) {
        return FactoryPathUtil.getDefaultFactoryPath(jproj);
    }

    public static IFactoryPath getFactoryPath(IJavaProject jproj) {
        return FactoryPathUtil.getFactoryPath(jproj);
    }

    public static void setFactoryPath(IJavaProject jproj, IFactoryPath path) throws CoreException {
        FactoryPath fp = (FactoryPath)path;
        FactoryPathUtil.setFactoryPath(jproj, fp);
        if (jproj == null) {
            AnnotationProcessorFactoryLoader.getLoader().resetAll();
        }
    }

    public static boolean hasProjectSpecificFactoryPath(IJavaProject jproj) {
        if (jproj == null) {
            return false;
        }
        return FactoryPathUtil.doesFactoryPathFileExist(jproj) && !AptConfig.getFactoryPath(jproj).equals(AptConfig.getDefaultFactoryPath(jproj));
    }

    public static String getString(IJavaProject jproj, String optionName) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] contexts = jproj != null ? new IScopeContext[]{new ProjectScope(jproj.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        String pluginId = null;
        pluginId = "org.eclipse.jdt.core.compiler.processAnnotations".equals(optionName) ? "org.eclipse.jdt.core" : "org.eclipse.jdt.apt.core";
        return service.getString(pluginId, optionName, AptPreferenceConstants.DEFAULT_OPTIONS_MAP.get(optionName), contexts);
    }

    public static String getGenSrcDir(IJavaProject jproject) {
        return AptConfig.getString(jproject, "org.eclipse.jdt.apt.genSrcDir");
    }

    public static void setGenSrcDir(IJavaProject jproject, String dirString) {
        if (!GeneratedSourceFolderManager.validate(jproject, dirString)) {
            throw new IllegalArgumentException("Illegal name for generated source folder: " + dirString);
        }
        AptConfig.setString(jproject, "org.eclipse.jdt.apt.genSrcDir", dirString);
    }

    public static String getGenTestSrcDir(IJavaProject jproject) {
        return AptConfig.getString(jproject, "org.eclipse.jdt.apt.genTestSrcDir");
    }

    public static void setGenTestSrcDir(IJavaProject jproject, String dirString) {
        if (!GeneratedSourceFolderManager.validate(jproject, dirString)) {
            throw new IllegalArgumentException("Illegal name for generated test source folder: " + dirString);
        }
        AptConfig.setString(jproject, "org.eclipse.jdt.apt.genTestSrcDir", dirString);
    }

    public static boolean validateGenSrcDir(IJavaProject jproject, String dirName) {
        return GeneratedSourceFolderManager.validate(jproject, dirName);
    }

    private static void setBoolean(IJavaProject jproject, String optionName, boolean value) {
        IScopeContext context = jproject != null ? new ProjectScope(jproject.getProject()) : InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.eclipse.jdt.apt.core");
        String oldValue = node.get(optionName, null);
        node.putBoolean(optionName, value);
        if (jproject != null && oldValue == null || value != Boolean.parseBoolean(oldValue)) {
            AptProject aproj = AptPlugin.getAptProject(jproject);
            aproj.preferenceChanged(optionName);
        }
        AptConfig.flushPreference(optionName, node);
    }

    private static void setString(IJavaProject jproject, String optionName, String value) {
        IScopeContext context = jproject != null ? new ProjectScope(jproject.getProject()) : InstanceScope.INSTANCE;
        IEclipsePreferences node = "org.eclipse.jdt.core.compiler.processAnnotations".equals(optionName) ? context.getNode("org.eclipse.jdt.core") : context.getNode("org.eclipse.jdt.apt.core");
        String oldValue = node.get(optionName, null);
        node.put(optionName, value);
        if (jproject != null && !value.equals(oldValue)) {
            AptProject aproj = AptPlugin.getAptProject(jproject);
            aproj.preferenceChanged(optionName);
        }
        AptConfig.flushPreference(optionName, node);
    }

    private static void flushPreference(String optionName, IEclipsePreferences node) {
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            AptPlugin.log(e, "Failed to save preference: " + optionName);
        }
    }

    private static class ProcessorOptionsParser {
        final String _s;
        int _start;
        boolean _hasVal;

        public ProcessorOptionsParser(String s) {
            this._s = s;
            this._start = 0;
            this._hasVal = false;
        }

        public Map<String, String> parse() {
            String key;
            HashMap<String, String> options = new HashMap<String, String>();
            while ((key = this.parseKey()) != null) {
                options.put(key, this.parseVal());
            }
            return options;
        }

        private String parseKey() {
            String key;
            int spaceAt = -1;
            int equalsAt = -1;
            this._hasVal = false;
            while (true) {
                this._start = this._s.indexOf("-A", this._start);
                if (this._start < 0) {
                    return null;
                }
                this._start += 2;
                if (this._start >= this._s.length()) {
                    return null;
                }
                spaceAt = this._s.indexOf(32, this._start);
                equalsAt = this._s.indexOf(61, this._start);
                if (spaceAt != this._start && equalsAt != this._start) break;
                ++this._start;
            }
            if (equalsAt > 0) {
                if (spaceAt < 0 || equalsAt < spaceAt) {
                    key = this._s.substring(this._start, equalsAt);
                    this._start = equalsAt + 1;
                    this._hasVal = this._start < this._s.length();
                } else {
                    key = this._s.substring(this._start, spaceAt);
                    this._start = spaceAt + 1;
                }
            } else if (spaceAt < 0) {
                key = this._s.substring(this._start);
                this._start = this._s.length();
            } else {
                key = this._s.substring(this._start, spaceAt);
                this._start = spaceAt + 1;
            }
            return key;
        }

        private String parseVal() {
            if (!this._hasVal || this._start < 0 || this._start >= this._s.length()) {
                return null;
            }
            boolean inQuotedRegion = false;
            int start = this._start;
            int end = this._start;
            while (end < this._s.length()) {
                char c = this._s.charAt(end);
                if (c == '\"') {
                    inQuotedRegion = !inQuotedRegion;
                } else if (!inQuotedRegion && c == ' ') {
                    this._start = end + 1;
                    break;
                }
                ++end;
            }
            return this._s.substring(start, end);
        }
    }
}

