/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import com.ibm.icu.text.Collator;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.ASTNodes;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.corext.codemanipulation.StyledInclude;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.refactoring.includes.HeaderSubstitutor;
import org.eclipse.cdt.internal.ui.refactoring.includes.IElementSelector;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreationContext;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeOrganizer;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class IncludeCreator {
    private static final Collator COLLATOR = Collator.getInstance();
    private final String fLineDelimiter;
    private final IElementSelector fAmbiguityResolver;
    private final IncludeCreationContext fContext;

    public IncludeCreator(ITranslationUnit tu, IIndex index, String lineDelimiter, IElementSelector ambiguityResolver) {
        this.fLineDelimiter = lineDelimiter;
        this.fAmbiguityResolver = ambiguityResolver;
        this.fContext = new IncludeCreationContext(tu, index);
    }

    public MultiTextEdit createInclude(IASTTranslationUnit ast, ITextSelection selection) throws CoreException {
        IFunctionSummary fs;
        MultiTextEdit rootEdit = new MultiTextEdit();
        ITranslationUnit tu = this.fContext.getTranslationUnit();
        IASTNodeSelector selector = ast.getNodeSelector(tu.getLocation().toOSString());
        IASTName name = selector.findEnclosingName(selection.getOffset(), selection.getLength());
        if (name == null) {
            return rootEdit;
        }
        char[] nameChars = name.toCharArray();
        String lookupName = new String(nameChars);
        IBinding binding = name.resolveBinding();
        if (binding instanceof ICPPVariable) {
            IType type = ((ICPPVariable)binding).getType();
            if ((type = SemanticUtil.getNestedType((IType)type, (int)180)) instanceof IBinding) {
                binding = (IBinding)type;
                nameChars = binding.getNameCharArray();
            }
        }
        if (nameChars.length == 0) {
            return rootEdit;
        }
        HashMap<String, IncludeCandidate> candidatesMap = new HashMap<String, IncludeCandidate>();
        IndexFilter filter = IndexFilter.getDeclaredBindingFilter((int)ast.getLinkage().getLinkageID(), (boolean)false);
        ArrayList<IncludeInfo> requiredIncludes = new ArrayList<IncludeInfo>();
        ArrayList<UsingDeclaration> usingDeclarations = new ArrayList<UsingDeclaration>();
        ArrayList<IIndexBinding> bindings = new ArrayList<IIndexBinding>();
        try {
            IIndexMacro[] macros;
            IIndex index = this.fContext.getIndex();
            IIndexBinding adaptedBinding = index.adaptBinding(binding);
            if (adaptedBinding == null) {
                bindings.addAll(Arrays.asList(index.findBindings(nameChars, false, filter, (IProgressMonitor)new NullProgressMonitor())));
            } else {
                bindings.add(adaptedBinding);
                while (adaptedBinding instanceof ICPPSpecialization) {
                    if ((adaptedBinding = index.adaptBinding(((ICPPSpecialization)adaptedBinding).getSpecializedBinding())) == null) continue;
                    bindings.add(adaptedBinding);
                }
            }
            HeaderSubstitutor headerSubstitutor = new HeaderSubstitutor(this.fContext);
            for (IIndexBinding indexBinding : bindings) {
                if (indexBinding instanceof ICPPConstructor) {
                    indexBinding = indexBinding.getOwner();
                }
                IIndexName[] definitions = null;
                if (indexBinding instanceof ICompositeType || indexBinding instanceof IEnumeration || indexBinding instanceof IEnumerator) {
                    definitions = index.findDefinitions((IBinding)indexBinding);
                } else if (indexBinding instanceof ITypedef || indexBinding instanceof IFunction) {
                    definitions = index.findDeclarations((IBinding)indexBinding);
                }
                if (definitions == null) continue;
                IIndexName[] iIndexNameArray = definitions;
                int n = definitions.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexName definition = iIndexNameArray[n2];
                    this.considerForInclusion(definition, indexBinding, index, headerSubstitutor, candidatesMap);
                    ++n2;
                }
                if (definitions.length > 0 && adaptedBinding != null) break;
            }
            IIndexMacro[] iIndexMacroArray = macros = index.findMacros(nameChars, filter, (IProgressMonitor)new NullProgressMonitor());
            int definition = macros.length;
            int definitions = 0;
            while (definitions < definition) {
                IIndexMacro macro = iIndexMacroArray[definitions];
                IIndexName definition2 = macro.getDefinition();
                this.considerForInclusion(definition2, (IIndexBinding)macro, index, headerSubstitutor, candidatesMap);
                ++definitions;
            }
            ArrayList candidates = new ArrayList(candidatesMap.values());
            if (candidates.size() > 1) {
                IncludeCandidate candidate = (IncludeCandidate)this.fAmbiguityResolver.selectElement(candidates);
                if (candidate == null) {
                    return rootEdit;
                }
                candidates.clear();
                candidates.add(candidate);
            }
            if (candidates.size() == 1) {
                UsingDeclaration usingDeclaration;
                IncludeCandidate candidate = (IncludeCandidate)candidates.get(0);
                requiredIncludes.add(candidate.include);
                IIndexBinding indexBinding = candidate.binding;
                if (indexBinding instanceof ICPPBinding && !(indexBinding instanceof IIndexMacro) && (usingDeclaration = this.deduceUsingDeclaration(binding, (IBinding)indexBinding, ast)) != null) {
                    usingDeclarations.add(usingDeclaration);
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return rootEdit;
        }
        if (requiredIncludes.isEmpty() && !lookupName.isEmpty() && (fs = this.findContribution(lookupName)) != null) {
            String ns;
            IRequiredInclude[] functionIncludes = fs.getIncludes();
            if (functionIncludes != null) {
                IRequiredInclude[] iRequiredIncludeArray = functionIncludes;
                int n = functionIncludes.length;
                int n3 = 0;
                while (n3 < n) {
                    IRequiredInclude include = iRequiredIncludeArray[n3];
                    requiredIncludes.add(new IncludeInfo(include.getIncludeName(), include.isStandard()));
                    ++n3;
                }
            }
            if ((ns = fs.getNamespace()) != null && !ns.isEmpty()) {
                usingDeclarations.add(new UsingDeclaration(String.valueOf(ns) + "::" + fs.getName()));
            }
        }
        return this.createEdit(requiredIncludes, usingDeclarations, ast, selection);
    }

    /*
     * WARNING - void declaration
     */
    private MultiTextEdit createEdit(List<IncludeInfo> includes, List<UsingDeclaration> usingDeclarations, IASTTranslationUnit ast, ITextSelection selection) {
        int n;
        void var16_37;
        int n2;
        NodeCommentMap commentedNodeMap = ASTCommenter.getCommentedNodeMap((IASTTranslationUnit)ast);
        String contents = this.fContext.getSourceContents();
        IRegion includeRegion = IncludeOrganizer.getSafeIncludeReplacementRegion(contents, ast, commentedNodeMap);
        IncludePreferences preferences = this.fContext.getPreferences();
        MultiTextEdit rootEdit = new MultiTextEdit();
        IASTPreprocessorIncludeStatement[] existingIncludes = ast.getIncludeDirectives();
        this.fContext.addHeadersIncludedPreviously(existingIncludes);
        ArrayList<StyledInclude> styledIncludes = new ArrayList<StyledInclude>();
        for (IncludeInfo includeInfo : includes) {
            IPath header = this.fContext.resolveInclude(includeInfo);
            if (this.fContext.wasIncludedPreviously(header)) continue;
            IncludeGroupStyle style = this.fContext.getIncludeStyle(includeInfo);
            StyledInclude styledInclude = new StyledInclude(header, includeInfo, style);
            styledIncludes.add(styledInclude);
        }
        Collections.sort(styledIncludes, preferences);
        ArrayList<StyledInclude> mergedIncludes = new ArrayList<StyledInclude>();
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = existingIncludes;
        int style = existingIncludes.length;
        int header = 0;
        while (header < style) {
            IASTPreprocessorIncludeStatement iASTPreprocessorIncludeStatement = iASTPreprocessorIncludeStatementArray[header];
            if (iASTPreprocessorIncludeStatement.isPartOfTranslationUnitFile() && IncludeUtil.isContainedInRegion((IASTNode)iASTPreprocessorIncludeStatement, includeRegion)) {
                String name = new String(iASTPreprocessorIncludeStatement.getName().getSimpleID());
                IncludeInfo includeInfo = new IncludeInfo(name, iASTPreprocessorIncludeStatement.isSystemInclude());
                String string = iASTPreprocessorIncludeStatement.getPath();
                IPath header2 = string.isEmpty() ? null : Path.fromOSString((String)string);
                IncludeGroupStyle style2 = header2 != null ? this.fContext.getIncludeStyle(header2) : this.fContext.getIncludeStyle(includeInfo);
                StyledInclude prototype2 = new StyledInclude(header2, includeInfo, style2, iASTPreprocessorIncludeStatement);
                mergedIncludes.add(prototype2);
            }
            ++header;
        }
        if (preferences.allowReordering) {
            for (StyledInclude styledInclude : styledIncludes) {
                int i = mergedIncludes.size();
                while (--i >= 0 && preferences.compare(styledInclude, (StyledInclude)mergedIncludes.get(i)) < 0) {
                }
                mergedIncludes.add(i + 1, styledInclude);
            }
        } else {
            mergedIncludes.addAll(styledIncludes);
        }
        int n3 = includeRegion.getOffset();
        StringBuilder text = new StringBuilder();
        StyledInclude previousInclude = null;
        for (StyledInclude styledInclude : mergedIncludes) {
            if (styledInclude.getExistingInclude() == null) {
                if (previousInclude != null) {
                    IASTPreprocessorIncludeStatement previousNode = previousInclude.getExistingInclude();
                    if (previousNode != null) {
                        n2 = ASTNodes.skipToNextLineAfterNode((String)contents, (IASTNode)previousNode);
                        this.flushEditBuffer(n2, text, rootEdit);
                        if (contents.charAt(n2 - 1) != '\n') {
                            text.append(this.fLineDelimiter);
                        }
                    }
                    if (styledInclude.getStyle().isBlankLineNeededAfter(previousInclude.getStyle(), preferences.includeStyles)) {
                        text.append(this.fLineDelimiter);
                    }
                }
                text.append(styledInclude.getIncludeInfo().composeIncludeStatement());
                text.append(this.fLineDelimiter);
            } else {
                if (previousInclude != null && previousInclude.getExistingInclude() == null && styledInclude.getStyle().isBlankLineNeededAfter(previousInclude.getStyle(), preferences.includeStyles)) {
                    text.append(this.fLineDelimiter);
                }
                this.flushEditBuffer(n2, text, rootEdit);
            }
            previousInclude = styledInclude;
        }
        this.flushEditBuffer(n2, text, rootEdit);
        List<UsingDeclaration> list = this.getUsingDeclarations(ast);
        for (UsingDeclaration usingDeclaration : list) {
            Iterator<UsingDeclaration> iterator = usingDeclarations.iterator();
            while (iterator.hasNext()) {
                UsingDeclaration using = iterator.next();
                if (!using.equals(usingDeclaration.name)) continue;
                iterator.remove();
            }
        }
        if (usingDeclarations.isEmpty()) {
            return rootEdit;
        }
        ArrayList<UsingDeclaration> temp = null;
        for (UsingDeclaration usingDeclaration : list) {
            if (!usingDeclaration.existingDeclaration.isPartOfTranslationUnitFile() || ASTNodes.endOffset((IASTNode)usingDeclaration.existingDeclaration) > selection.getOffset()) continue;
            if (temp == null) {
                temp = new ArrayList<UsingDeclaration>();
            }
            temp.add(usingDeclaration);
        }
        if (temp == null) {
            list.clear();
        } else {
            ArrayList<UsingDeclaration> arrayList = temp;
        }
        Collections.sort(usingDeclarations);
        if (var16_37.isEmpty()) {
            int n4 = includeRegion.getOffset() + includeRegion.getLength();
            text.append(this.fLineDelimiter);
        } else {
            int n5 = commentedNodeMap.getOffsetIncludingComments((IASTNode)((UsingDeclaration)var16_37.get((int)0)).existingDeclaration);
        }
        for (UsingDeclaration using : usingDeclarations) {
            int i = var16_37.size();
            while (--i >= 0 && using.compareTo((UsingDeclaration)var16_37.get(i)) < 0) {
            }
            var16_37.add(i + 1, using);
        }
        UsingDeclaration previousUsing = null;
        for (UsingDeclaration usingDeclaration : var16_37) {
            if (usingDeclaration.existingDeclaration == null) {
                ICPPASTUsingDeclaration previousNode;
                if (previousUsing != null && (previousNode = previousUsing.existingDeclaration) != null) {
                    n = ASTNodes.skipToNextLineAfterNode((String)contents, (IASTNode)previousNode);
                    this.flushEditBuffer(n, text, rootEdit);
                    if (contents.charAt(n - 1) != '\n') {
                        text.append(this.fLineDelimiter);
                    }
                }
                text.append(usingDeclaration.composeDirective());
                text.append(this.fLineDelimiter);
            } else {
                this.flushEditBuffer(n, text, rootEdit);
            }
            previousUsing = usingDeclaration;
        }
        this.flushEditBuffer(n, text, rootEdit);
        return rootEdit;
    }

    private List<UsingDeclaration> getUsingDeclarations(IASTTranslationUnit ast) {
        IASTDeclaration[] declarations;
        ArrayList<UsingDeclaration> usingDeclarations = new ArrayList<UsingDeclaration>();
        IASTDeclaration[] iASTDeclarationArray = declarations = ast.getDeclarations();
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            if (declaration instanceof ICPPASTUsingDeclaration) {
                usingDeclarations.add(new UsingDeclaration((ICPPASTUsingDeclaration)declaration));
            }
            ++n2;
        }
        return usingDeclarations;
    }

    private void flushEditBuffer(int offset, StringBuilder text, MultiTextEdit edit) {
        if (text.length() != 0) {
            edit.addChild((TextEdit)new InsertEdit(offset, text.toString()));
            text.delete(0, text.length());
        }
    }

    private void considerForInclusion(IIndexName definition, IIndexBinding binding, IIndex index, HeaderSubstitutor headerSubstitutor, Map<String, IncludeCandidate> candidates) throws CoreException {
        if (definition == null) {
            return;
        }
        IIndexFile file = definition.getFile();
        if (!this.isSource(IncludeCreator.getPath(file)) || index.findIncludedBy(file, 0).length > 0) {
            IncludeCandidate candidate;
            IncludeInfo include;
            if (this.fContext.getPreferences().heuristicHeaderSubstitution) {
                include = this.getIncludeByHeuristic(file, index);
            } else {
                IPath header = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
                header = headerSubstitutor.getPreferredRepresentativeHeader(header);
                IncludeGroupStyle style = this.fContext.getIncludeStyle(header);
                include = this.fContext.createIncludeInfo(header, style);
            }
            if (include != null && !candidates.containsKey((candidate = new IncludeCandidate(binding, include)).toString())) {
                candidates.put(candidate.toString(), candidate);
            }
        }
    }

    private UsingDeclaration deduceUsingDeclaration(IBinding source, IBinding target, IASTTranslationUnit ast) {
        int i;
        IASTDeclaration[] declarations;
        if (source.equals(target)) {
            return null;
        }
        ArrayList<String> targetChain = this.getUsingChain(target);
        if (targetChain.size() <= 1) {
            return null;
        }
        IASTDeclaration[] iASTDeclarationArray = declarations = ast.getDeclarations(false);
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            if (declaration.isPartOfTranslationUnitFile()) {
                IASTName name = null;
                if (declaration instanceof ICPPASTUsingDeclaration ? this.match(name = ((ICPPASTUsingDeclaration)declaration).getName(), targetChain, false) : declaration instanceof ICPPASTUsingDirective && this.match(name = ((ICPPASTUsingDirective)declaration).getQualifiedName(), targetChain, true)) {
                    return null;
                }
            }
            ++n2;
        }
        ArrayList<String> sourceChain = this.getUsingChain(source);
        if (sourceChain.size() >= targetChain.size()) {
            int j = targetChain.size();
            i = sourceChain.size();
            while (--j >= 1 && --i >= 1) {
                if (!sourceChain.get(i).equals(targetChain.get(j))) break;
            }
            if (j <= 0) {
                return null;
            }
        }
        StringBuilder buf = new StringBuilder();
        i = targetChain.size();
        while (--i >= 0) {
            if (buf.length() > 0) {
                buf.append("::");
            }
            buf.append(targetChain.get(i));
        }
        return new UsingDeclaration(buf.toString());
    }

    private boolean match(IASTName name, ArrayList<String> usingChain, boolean excludeLast) {
        ICPPASTNameSpecifier[] qualifiers = name instanceof ICPPASTQualifiedName ? ((ICPPASTQualifiedName)name).getQualifier() : ICPPASTNameSpecifier.EMPTY_NAME_SPECIFIER_ARRAY;
        if (qualifiers.length + 1 != usingChain.size() - (excludeLast ? 1 : 0)) {
            return false;
        }
        int i = 0;
        while (i < qualifiers.length) {
            if (!qualifiers[i].toString().equals(usingChain.get(usingChain.size() - 1 - i))) {
                return false;
            }
            ++i;
        }
        return name.getLastName().toString().equals(usingChain.get(usingChain.size() - 1 - qualifiers.length));
    }

    private ArrayList<String> getUsingChain(IBinding binding) {
        ArrayList<String> chain = new ArrayList<String>(4);
        while (binding != null) {
            block3: {
                String name;
                block2: {
                    block1: {
                        name = binding.getName();
                        if (!(binding instanceof ICPPNamespace)) break block1;
                        if (name.length() != 0) break block2;
                        break block3;
                    }
                    chain.clear();
                }
                chain.add(name);
            }
            binding = binding.getOwner();
        }
        return chain;
    }

    private IIndexFile getRepresentativeFile(IIndexFile headerFile, IIndex index) {
        try {
            if (this.isWorkspaceFile(headerFile.getLocation().getURI())) {
                return headerFile;
            }
            ArrayDeque<IIndexFile> front = new ArrayDeque<IIndexFile>();
            front.add(headerFile);
            HashSet<IIndexFile> processed = new HashSet<IIndexFile>();
            processed.add(headerFile);
            while (!front.isEmpty()) {
                IIndexInclude[] includes;
                IIndexFile file = (IIndexFile)front.remove();
                if (this.fContext.isCXXLanguage() && !this.hasExtension(IncludeCreator.getPath(file))) {
                    return file;
                }
                IIndexInclude[] iIndexIncludeArray = includes = index.findIncludedBy(file, 0);
                int n = includes.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexInclude include = iIndexIncludeArray[n2];
                    IIndexFile includer = include.getIncludedBy();
                    if (!processed.contains(includer)) {
                        URI uri = includer.getLocation().getURI();
                        if (this.isSource(uri.getPath()) || this.isWorkspaceFile(uri)) {
                            return file;
                        }
                        front.add(includer);
                        processed.add(includer);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return headerFile;
    }

    private boolean isWorkspaceFile(URI uri) {
        IFile[] iFileArray = ResourceLookup.findFilesForLocationURI((URI)uri);
        int n = iFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasExtension(String path) {
        return path.indexOf(46, path.lastIndexOf(47) + 1) >= 0;
    }

    private IFunctionSummary findContribution(String name) throws CoreException {
        ICHelpInvocationContext context = new ICHelpInvocationContext(){

            @Override
            public IProject getProject() {
                return IncludeCreator.this.fContext.getProject();
            }

            @Override
            public ITranslationUnit getTranslationUnit() {
                return IncludeCreator.this.fContext.getTranslationUnit();
            }
        };
        return CHelpProviderManager.getDefault().getFunctionInfo(context, name);
    }

    private boolean isSource(String filename) {
        String id;
        IContentType ct = CCorePlugin.getContentType((IProject)this.fContext.getProject(), (String)filename);
        return ct != null && ("org.eclipse.cdt.core.cSource".equals(id = ct.getId()) || "org.eclipse.cdt.core.cxxSource".equals(id));
    }

    private static String getPath(IIndexFile file) throws CoreException {
        return file.getLocation().getURI().getPath();
    }

    private IncludeInfo getIncludeByHeuristic(IIndexFile file, IIndex index) throws CoreException {
        IIndexInclude[] includes = index.findIncludedBy(file = this.getRepresentativeFile(file, index));
        if (includes.length > 0) {
            int systemIncludeVotes = 0;
            Object[] ballotBox = new String[includes.length];
            int k = 0;
            IIndexInclude[] iIndexIncludeArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexInclude include = iIndexIncludeArray[n2];
                if (this.isResolvableInCurrentContext(include)) {
                    ballotBox[k++] = include.getFullName();
                    if (include.isSystemInclude()) {
                        ++systemIncludeVotes;
                    }
                }
                ++n2;
            }
            if (k != 0) {
                Arrays.sort(ballotBox, 0, k);
                Object contender = ballotBox[0];
                int votes = 1;
                Object winner = contender;
                int winnerVotes = votes;
                int i = 1;
                while (i < k) {
                    if (!((String)ballotBox[i]).equals(contender)) {
                        contender = ballotBox[i];
                        votes = 1;
                    }
                    if (++votes > winnerVotes) {
                        winner = contender;
                        winnerVotes = votes;
                    }
                    ++i;
                }
                return new IncludeInfo((String)winner, systemIncludeVotes * 2 >= k);
            }
        }
        IPath targetLocation = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
        return this.fContext.getIncludeForHeaderFile(targetLocation);
    }

    private boolean isResolvableInCurrentContext(IIndexInclude include) {
        try {
            IncludeInfo includeInfo = new IncludeInfo(include.getFullName(), include.isSystemInclude());
            return this.fContext.resolveInclude(includeInfo) != null;
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return false;
        }
    }

    private static String getBindingQualifiedName(IIndexBinding binding) throws CoreException {
        String[] qname = CPPVisitor.getQualifiedName((IBinding)binding);
        StringBuilder result = new StringBuilder();
        boolean needSep = false;
        String[] stringArray = qname;
        int n = qname.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (needSep) {
                result.append(Keywords.cpCOLONCOLON);
            }
            result.append(element);
            needSep = true;
            ++n2;
        }
        return result.toString();
    }

    private static class IncludeCandidate {
        final IIndexBinding binding;
        final IncludeInfo include;
        final String label;

        IncludeCandidate(IIndexBinding binding, IncludeInfo include) throws CoreException {
            this.binding = binding;
            this.include = include;
            this.label = String.valueOf(IncludeCreator.getBindingQualifiedName(binding)) + " - " + include.toString();
        }

        public String toString() {
            return this.label;
        }
    }

    private static class UsingDeclaration
    implements Comparable<UsingDeclaration> {
        final String name;
        final ICPPASTUsingDeclaration existingDeclaration;

        UsingDeclaration(String name) {
            this.name = name;
            this.existingDeclaration = null;
        }

        UsingDeclaration(ICPPASTUsingDeclaration existingDeclaration) {
            this.name = ASTStringUtil.getQualifiedName((IASTName)existingDeclaration.getName());
            this.existingDeclaration = existingDeclaration;
        }

        @Override
        public int compareTo(UsingDeclaration other) {
            return COLLATOR.compare(this.name, other.name);
        }

        String composeDirective() {
            return "using " + this.name + ';';
        }
    }
}

