/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.model.TestingSessionsManager;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ActionsMessages;
import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class HistoryDropDownAction
extends Action {
    public static final int RESULTS_IN_DROP_DOWN_MENU = 10;
    private TestingSessionsManager testingSessionsManager;
    private Shell shell;
    private Menu menu;

    public HistoryDropDownAction(TestingSessionsManager testingSessionsManager, Shell shell) {
        super(ActionsMessages.HistoryAction_history_text);
        this.setToolTipText(ActionsMessages.HistoryAction_history_tooltip);
        this.setDisabledImageDescriptor(TestsRunnerPlugin.getImageDescriptor("dlcl16/history_list.gif"));
        this.setHoverImageDescriptor(TestsRunnerPlugin.getImageDescriptor("elcl16/history_list.gif"));
        this.setImageDescriptor(TestsRunnerPlugin.getImageDescriptor("elcl16/history_list.gif"));
        this.testingSessionsManager = testingSessionsManager;
        this.shell = shell;
        this.setMenuCreator(new HistoryMenuCreator());
    }

    private void runHistoryDialog() {
        HistoryListDialog dialog = new HistoryListDialog(this.shell);
        if (dialog.open() == 0) {
            this.testingSessionsManager.setHistorySizeLimit(dialog.getResultHistorySizeLimit());
            this.testingSessionsManager.setActiveSession(dialog.getResultActiveSession());
            this.testingSessionsManager.setSessions(dialog.getResultSessions());
        }
    }

    public void run() {
        this.runHistoryDialog();
    }

    private class ClearAction
    extends Action {
        public ClearAction() {
            this.setText(ActionsMessages.HistoryAction_history_item_clear_text);
            boolean enabled = false;
            for (ITestingSession iTestingSession : HistoryDropDownAction.this.testingSessionsManager.getSessions()) {
                if (!iTestingSession.isFinished()) continue;
                enabled = true;
                break;
            }
            this.setEnabled(enabled);
        }

        public void run() {
            ArrayList<ITestingSession> remainingSessions = new ArrayList<ITestingSession>();
            for (ITestingSession iTestingSession : HistoryDropDownAction.this.testingSessionsManager.getSessions()) {
                if (iTestingSession.isFinished()) continue;
                remainingSessions.add(iTestingSession);
            }
            ITestingSession iTestingSession = remainingSessions.isEmpty() ? null : (ITestingSession)remainingSessions.get(0);
            HistoryDropDownAction.this.testingSessionsManager.setActiveSession(iTestingSession);
            HistoryDropDownAction.this.testingSessionsManager.setSessions(remainingSessions);
        }
    }

    private class HistoryAction
    extends Action {
        private final ITestingSession testingSession;

        public HistoryAction(int testingSessionIndex, ITestingSession testingSession) {
            super("", 8);
            this.testingSession = testingSession;
            String label = testingSession.getName();
            if (testingSessionIndex < 10) {
                label = "" + '&' + testingSessionIndex + ' ' + label;
            }
            this.setText(label);
        }

        public void run() {
            if (this.isChecked()) {
                HistoryDropDownAction.this.testingSessionsManager.setActiveSession(this.testingSession);
            }
        }
    }

    private class HistoryListAction
    extends Action {
        public HistoryListAction() {
            super(ActionsMessages.HistoryAction_history_item_show_text, 8);
        }

        public void run() {
            if (this.isChecked()) {
                HistoryDropDownAction.this.runHistoryDialog();
            }
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private static final int MAX_HISTORY_SIZE_LIMIT = 100;
        private ListDialogField<ITestingSession> historyList;
        private StringDialogField historySizeLimitField;
        private int historySizeLimit;
        private ITestingSession resultActiveSession;

        private HistoryListDialog(Shell shell) {
            super(shell);
            this.setHelpAvailable(false);
            this.setTitle(ActionsMessages.HistoryAction_dialog_title);
            this.createHistoryList();
            this.createHistorySizeLimitField();
        }

        protected boolean isResizable() {
            return true;
        }

        private void createHistoryList() {
            IListAdapter<ITestingSession> adapter = new IListAdapter<ITestingSession>(){

                public void customButtonPressed(ListDialogField<ITestingSession> field, int index) {
                    HistoryListDialog.this.doCustomButtonPressed(index);
                }

                public void selectionChanged(ListDialogField<ITestingSession> field) {
                    HistoryListDialog.this.doSelectionChanged();
                }

                public void doubleClicked(ListDialogField<ITestingSession> field) {
                    HistoryListDialog.this.doDoubleClicked();
                }
            };
            String[] buttonLabels = new String[]{ActionsMessages.HistoryAction_dialog_button_remove, ActionsMessages.HistoryAction_dialog_button_remove_all};
            TestRunLabelProvider labelProvider = new TestRunLabelProvider();
            this.historyList = new ListDialogField((IListAdapter)adapter, buttonLabels, (IBaseLabelProvider)labelProvider);
            this.historyList.setLabelText(ActionsMessages.HistoryAction_dialog_list_title);
            this.historyList.setElements(HistoryDropDownAction.this.testingSessionsManager.getSessions());
            ITestingSession currentEntry = HistoryDropDownAction.this.testingSessionsManager.getActiveSession();
            StructuredSelection sel = currentEntry != null ? new StructuredSelection((Object)currentEntry) : new StructuredSelection();
            this.historyList.selectElements((ISelection)sel);
        }

        private void createHistorySizeLimitField() {
            this.historySizeLimitField = new StringDialogField();
            this.historySizeLimitField.setLabelText(ActionsMessages.HistoryAction_dialog_limit_label);
            this.historySizeLimitField.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    boolean valid;
                    String maxString = HistoryListDialog.this.historySizeLimitField.getText();
                    try {
                        HistoryListDialog.this.historySizeLimit = Integer.parseInt(maxString);
                        valid = HistoryListDialog.this.historySizeLimit > 0 && HistoryListDialog.this.historySizeLimit < 100;
                    }
                    catch (NumberFormatException numberFormatException) {
                        valid = false;
                    }
                    IStatus status = valid ? StatusInfo.OK_STATUS : new StatusInfo(4, MessageFormat.format(ActionsMessages.HistoryAction_dialog_limit_label_error, Integer.toString(100)));
                    HistoryListDialog.this.updateStatus(status);
                }
            });
            this.historySizeLimitField.setText(Integer.toString(HistoryDropDownAction.this.testingSessionsManager.getHistorySizeLimit()));
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setLayoutData((Object)new GridData(1808));
            inner.setFont(composite.getFont());
            LayoutUtil.doDefaultLayout((Composite)inner, (DialogField[])new DialogField[]{this.historyList, new org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator()}, (boolean)true);
            LayoutUtil.setHeightHint((Control)this.historyList.getListControl(null), (int)this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing((Control)this.historyList.getListControl(null));
            Composite additionalControls = new Composite(inner, 0);
            additionalControls.setLayoutData((Object)new GridData(4, 4, true, false));
            LayoutUtil.doDefaultLayout((Composite)additionalControls, (DialogField[])new DialogField[]{this.historySizeLimitField}, (boolean)false);
            LayoutUtil.setHorizontalGrabbing((Control)this.historySizeLimitField.getTextControl(null));
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doCustomButtonPressed(int index) {
            switch (index) {
                case 0: {
                    this.historyList.removeElements(this.historyList.getSelectedElements());
                    this.historyList.selectFirstElement();
                    break;
                }
                case 1: {
                    this.historyList.removeAllElements();
                    break;
                }
            }
        }

        private void doDoubleClicked() {
            this.okPressed();
        }

        private void doSelectionChanged() {
            List selected = this.historyList.getSelectedElements();
            this.resultActiveSession = selected.size() >= 1 ? (ITestingSession)selected.get(0) : null;
            this.historyList.enableButton(0, selected.size() != 0);
        }

        public ITestingSession getResultActiveSession() {
            return this.resultActiveSession;
        }

        public List<ITestingSession> getResultSessions() {
            return this.historyList.getElements();
        }

        public int getResultHistorySizeLimit() {
            return this.historySizeLimit;
        }

        private final class TestRunLabelProvider
        extends LabelProvider {
            private TestRunLabelProvider() {
            }

            public String getText(Object element) {
                return ((ITestingSession)element).getName();
            }
        }
    }

    private class HistoryMenuCreator
    implements IMenuCreator {
        private HistoryMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            if (HistoryDropDownAction.this.menu != null) {
                HistoryDropDownAction.this.menu.dispose();
            }
            MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager2) {
                    boolean checkOthers = this.addHistoryItems(manager2);
                    HistoryListAction others = new HistoryListAction();
                    others.setChecked(checkOthers);
                    manager2.add((IAction)others);
                    manager2.add((IContributionItem)new Separator());
                    manager2.add((IAction)new ClearAction());
                }

                private boolean addHistoryItems(IMenuManager manager) {
                    boolean checkOthers = true;
                    int sessionsCount = HistoryDropDownAction.this.testingSessionsManager.getSessionsCount();
                    if (sessionsCount == 0) {
                        return false;
                    }
                    int menuItemsCount = Math.min(sessionsCount, 10);
                    ITestingSession activeSession = HistoryDropDownAction.this.testingSessionsManager.getActiveSession();
                    int testingSessionIndex = 0;
                    for (ITestingSession iTestingSession : HistoryDropDownAction.this.testingSessionsManager.getSessions()) {
                        if (testingSessionIndex >= menuItemsCount) break;
                        HistoryAction action = new HistoryAction(testingSessionIndex, iTestingSession);
                        boolean check = iTestingSession == activeSession;
                        action.setChecked(check);
                        if (check) {
                            checkOthers = false;
                        }
                        manager.add((IAction)action);
                        ++testingSessionIndex;
                    }
                    return checkOthers;
                }
            });
            HistoryDropDownAction.this.menu = manager.createContextMenu(parent);
            return HistoryDropDownAction.this.menu;
        }

        public void dispose() {
            if (HistoryDropDownAction.this.menu != null) {
                HistoryDropDownAction.this.menu.dispose();
                HistoryDropDownAction.this.menu = null;
            }
        }
    }
}

