/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.boost;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cdt.testsrunner.internal.boost.BoostTestsRunnerMessages;
import org.eclipse.cdt.testsrunner.internal.boost.BoostXmlLogHandler;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProvider;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.eclipse.cdt.testsrunner.model.TestingException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BoostTestsRunnerProvider
implements ITestsRunnerProvider {
    public String[] getAdditionalLaunchParameters(String[][] testPaths) throws TestingException {
        String[] boostParameters;
        String[] result = boostParameters = new String[]{"--output_format=xml", "--log_level=all", "--report_level=no"};
        if (testPaths != null && testPaths.length >= 1) {
            if (testPaths.length != 1) {
                throw new TestingException(BoostTestsRunnerMessages.BoostTestsRunner_wrong_tests_paths_count);
            }
            StringBuilder sb = new StringBuilder("--run_test=");
            String[] testPath = testPaths[0];
            int i = 1;
            while (i < testPath.length) {
                if (i != 1) {
                    sb.append("/");
                }
                sb.append(testPath[i]);
                ++i;
            }
            result = new String[boostParameters.length + 1];
            System.arraycopy(boostParameters, 0, result, 0, boostParameters.length);
            result[boostParameters.length] = sb.toString();
        }
        return result;
    }

    private String getErrorText(String prefix, String description) {
        return MessageFormat.format(BoostTestsRunnerMessages.BoostTestsRunner_error_format, prefix, description);
    }

    public void run(ITestModelUpdater modelUpdater, InputStream inputStream) throws TestingException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(inputStream, (DefaultHandler)new BoostXmlLogHandler(modelUpdater));
        }
        catch (IOException e) {
            throw new TestingException(this.getErrorText(BoostTestsRunnerMessages.BoostTestsRunner_io_error_prefix, e.getLocalizedMessage()));
        }
        catch (NumberFormatException e) {
            throw new TestingException(this.getErrorText(BoostTestsRunnerMessages.BoostTestsRunner_xml_error_prefix, e.getLocalizedMessage()));
        }
        catch (ParserConfigurationException e) {
            throw new TestingException(this.getErrorText(BoostTestsRunnerMessages.BoostTestsRunner_xml_error_prefix, e.getLocalizedMessage()));
        }
        catch (SAXException e) {
            throw new TestingException(this.getErrorText(BoostTestsRunnerMessages.BoostTestsRunner_xml_error_prefix, e.getLocalizedMessage()));
        }
    }
}

