/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.DsfDebugUITools;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterBitFieldVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterColumnPresentation;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterGroupVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterRootDMVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.BreakpointHitUpdatePolicy;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.DebugManualUpdatePolicy;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class RegisterVMProvider
extends AbstractDMVMProvider {
    private IPropertyChangeListener fPreferencesListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("delaySteppingForViewUpdatesEnable")) {
                IPreferenceStore store = DsfDebugUITools.getPreferenceStore();
                RegisterVMProvider.this.setDelayEventHandleForViewUpdate(store.getBoolean(property));
            }
        }
    };
    private IPropertyChangeListener fPresentationContextListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            RegisterVMProvider.this.handleEvent(event);
        }
    };

    public RegisterVMProvider(AbstractVMAdapter adapter, IPresentationContext context, DsfSession session) {
        super(adapter, context, session);
        context.addPropertyChangeListener(this.fPresentationContextListener);
        IPreferenceStore store = DsfDebugUITools.getPreferenceStore();
        store.addPropertyChangeListener(this.fPreferencesListener);
        this.setDelayEventHandleForViewUpdate(store.getBoolean("delaySteppingForViewUpdatesEnable"));
        SyncRegisterDataAccess regAccess = new SyncRegisterDataAccess(session);
        RegisterRootDMVMNode rootNode = new RegisterRootDMVMNode(this);
        RegisterGroupVMNode registerGroupNode = new RegisterGroupVMNode((AbstractDMVMProvider)this, this.getSession(), regAccess);
        this.addChildNodes(rootNode, new IVMNode[]{registerGroupNode});
        RegisterVMNode registerNode = new RegisterVMNode((AbstractDMVMProvider)this, this.getSession(), regAccess);
        this.addChildNodes(registerGroupNode, new IVMNode[]{registerNode});
        RegisterBitFieldVMNode bitFieldNode = new RegisterBitFieldVMNode((AbstractDMVMProvider)this, this.getSession(), regAccess);
        this.addChildNodes(registerNode, new IVMNode[]{bitFieldNode});
        this.setRootNode(rootNode);
    }

    @Override
    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new AutomaticUpdatePolicy(), new DebugManualUpdatePolicy(), new BreakpointHitUpdatePolicy()};
    }

    @Override
    public void dispose() {
        DsfDebugUITools.getPreferenceStore().removePropertyChangeListener(this.fPreferencesListener);
        this.getPresentationContext().removePropertyChangeListener(this.fPresentationContextListener);
        super.dispose();
    }

    @Override
    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new RegisterColumnPresentation();
    }

    @Override
    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return "org.eclipse.cdt.dsf.ui.REGISTERS_COLUMN_PRESENTATION_ID";
    }

    @Override
    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        return newEvent instanceof IRunControl.ISuspendedDMEvent;
    }

    @Override
    public void update(IViewerInputUpdate update) {
        Object element = update.getElement();
        if (element instanceof IDMVMContext) {
            IDMContext ctx = ((IDMVMContext)element).getDMContext();
            IDMContext selDmc = DMContexts.getAncestorOfType((IDMContext)ctx, IStack.IFrameDMContext.class);
            if (selDmc == null) {
                selDmc = DMContexts.getAncestorOfType((IDMContext)ctx, IRunControl.IExecutionDMContext.class);
            }
            if (selDmc != null) {
                update.setInputElement((Object)new ViewInputElement(this.getRootVMNode(), selDmc));
                update.done();
                return;
            }
        }
        super.update(update);
    }

    @Override
    public void refresh() {
        super.refresh();
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), RegisterVMProvider.this.getSession().getId());
                    IRegisters registerService = (IRegisters)tracker.getService(IRegisters.class);
                    if (registerService instanceof ICachingService) {
                        ((ICachingService)registerService).flushCache(null);
                    }
                    tracker.dispose();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    private class ViewInputElement
    extends AbstractVMContext
    implements IDMVMContext {
        private final IDMContext fDMContext;

        public ViewInputElement(IVMNode node, IDMContext dmc) {
            super(node);
            this.fDMContext = dmc;
        }

        @Override
        public IDMContext getDMContext() {
            return this.fDMContext;
        }

        @Override
        public Object getAdapter(Class adapter) {
            Object superAdapter = super.getAdapter(adapter);
            if (superAdapter != null) {
                return superAdapter;
            }
            if (adapter.isInstance(this.fDMContext)) {
                return this.fDMContext;
            }
            return this.fDMContext.getAdapter(adapter);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ViewInputElement && ((ViewInputElement)obj).fDMContext.equals(this.fDMContext);
        }

        @Override
        public int hashCode() {
            return this.fDMContext.hashCode();
        }
    }
}

