/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.internal.core.index.IWritableIndex;

public class YieldableIndexLock {
    private final IWritableIndex index;
    private final boolean flushIndex;
    private long lastLockTime;
    private long cumulativeLockTime;

    public YieldableIndexLock(IWritableIndex index, boolean flushIndex) {
        this.index = index;
        this.flushIndex = flushIndex;
    }

    public void acquire() throws InterruptedException {
        this.index.acquireWriteLock();
        this.lastLockTime = System.currentTimeMillis();
    }

    public void release() {
        if (this.lastLockTime != 0L) {
            this.index.releaseWriteLock(this.flushIndex);
            this.cumulativeLockTime += System.currentTimeMillis() - this.lastLockTime;
            this.lastLockTime = 0L;
        }
    }

    public void yield() throws InterruptedException {
        if (this.index.hasWaitingReaders()) {
            this.index.releaseWriteLock(false);
            this.cumulativeLockTime += System.currentTimeMillis() - this.lastLockTime;
            this.lastLockTime = 0L;
            this.acquire();
        }
    }

    public long getCumulativeLockTime() {
        return this.cumulativeLockTime;
    }
}

