/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPEnumerator;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumerator
extends PDOMCPPBinding
implements IPDOMCPPEnumerator {
    private static final int VALUE = 32;
    protected static final int RECORD_SIZE = 38;

    public PDOMCPPEnumerator(PDOMLinkage linkage, PDOMNode parent, IEnumerator enumerator) throws CoreException {
        super(linkage, parent, enumerator.getNameCharArray());
        this.storeValue(enumerator);
    }

    public PDOMCPPEnumerator(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    protected int getRecordSize() {
        return 38;
    }

    @Override
    public int getNodeType() {
        return 3;
    }

    private void storeValue(IEnumerator enumerator) throws CoreException {
        IValue value = enumerator.getValue();
        if (value != null) {
            ((PDOMLinkage)this.getLinkage()).storeValue(this.record + 32L, value);
        }
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IEnumerator) {
            this.storeValue((IEnumerator)newBinding);
        }
    }

    @Override
    public IType getType() {
        IIndexBinding owner = this.getOwner();
        if (owner instanceof IType) {
            return (IType)((Object)owner);
        }
        return null;
    }

    @Override
    public IValue getValue() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadValue(this.record + 32L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return Value.UNKNOWN;
        }
    }
}

