/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.MIMemory;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.CLIShowEndianInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIGDBShowLanguageInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;

public class GDBMemory
extends MIMemory
implements IGDBMemory {
    private IGDBControl fCommandControl;
    private Map<IMemory.IMemoryDMContext, Integer> fAddressSizes = new HashMap<IMemory.IMemoryDMContext, Integer>();
    private Boolean fIsBigEndian;

    public GDBMemory(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBMemory.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IMemory.class.getName(), MIMemory.class.getName(), IGDBMemory.class.getName(), GDBMemory.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fAddressSizes.clear();
        super.shutdown(requestMonitor);
    }

    @Override
    protected void readMemoryBlock(final IDMContext dmc, IAddress address, long offset, int word_size, int count, final DataRequestMonitor<MemoryByte[]> drm) {
        super.readMemoryBlock(dmc, address, offset, word_size, count, new DataRequestMonitor<MemoryByte[]>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                IMemory.IMemoryDMContext memDmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
                if (memDmc != null) {
                    boolean bigEndian = GDBMemory.this.isBigEndian(memDmc);
                    MemoryByte[] memoryByteArray = (MemoryByte[])this.getData();
                    int n = memoryByteArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MemoryByte b = memoryByteArray[n2];
                        b.setBigEndian(bigEndian);
                        b.setEndianessKnown(true);
                        ++n2;
                    }
                }
                drm.setData((Object)((MemoryByte[])this.getData()));
                drm.done();
            }
        });
    }

    @Override
    public void initializeMemoryData(final IMemory.IMemoryDMContext memContext, RequestMonitor rm) {
        ImmediateExecutor.getInstance().execute((Runnable)new Sequence(this.getExecutor(), rm){
            private String originalLanguage;
            private boolean abortLanguageSteps;
            private Sequence.Step[] steps;
            {
                super($anonymous0, $anonymous1);
                this.originalLanguage = "auto";
                this.abortLanguageSteps = false;
                this.steps = null;
            }

            private void determineSteps() {
                ArrayList<Sequence.Step> stepsList = new ArrayList<Sequence.Step>();
                if (GDBMemory.this.fAddressSizes.get(memContext) == null) {
                    stepsList.add(new Sequence.Step(){

                        public void execute(final RequestMonitor requestMonitor) {
                            GDBMemory.this.fCommandControl.queueCommand(GDBMemory.this.fCommandControl.getCommandFactory().createMIGDBShowLanguage((IDMContext)memContext), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIGDBShowLanguageInfo>(requestMonitor){

                                protected void handleCompleted() {
                                    if (this.isSuccess()) {
                                        originalLanguage = ((MIGDBShowLanguageInfo)this.getData()).getLanguage();
                                    } else {
                                        abortLanguageSteps = true;
                                    }
                                    requestMonitor.done();
                                }
                            });
                        }
                    });
                    stepsList.add(new Sequence.Step(){

                        public void execute(final RequestMonitor requestMonitor) {
                            if (abortLanguageSteps) {
                                requestMonitor.done();
                                return;
                            }
                            GDBMemory.this.fCommandControl.queueCommand(GDBMemory.this.fCommandControl.getCommandFactory().createMIGDBSetLanguage((IDMContext)memContext, "c"), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(requestMonitor){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        abortLanguageSteps = true;
                                    }
                                    requestMonitor.done();
                                }
                            });
                        }
                    });
                    stepsList.add(new Sequence.Step(){

                        public void execute(final RequestMonitor requestMonitor) {
                            GDBMemory.this.readAddressSize(memContext, (DataRequestMonitor<Integer>)new ImmediateDataRequestMonitor<Integer>(requestMonitor){

                                protected void handleCompleted() {
                                    if (this.isSuccess()) {
                                        GDBMemory.this.fAddressSizes.put(memContext, (Integer)this.getData());
                                    }
                                    requestMonitor.done();
                                }
                            });
                        }
                    });
                    stepsList.add(new Sequence.Step(){

                        public void execute(final RequestMonitor requestMonitor) {
                            if (abortLanguageSteps) {
                                requestMonitor.done();
                                return;
                            }
                            GDBMemory.this.fCommandControl.queueCommand(GDBMemory.this.fCommandControl.getCommandFactory().createMIGDBSetLanguage((IDMContext)memContext, originalLanguage), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(requestMonitor){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        GdbPlugin.log(this.getStatus());
                                        GDBMemory.this.fCommandControl.queueCommand(GDBMemory.this.fCommandControl.getCommandFactory().createMIGDBSetLanguage((IDMContext)memContext, "auto"), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(requestMonitor){

                                            protected void handleCompleted() {
                                                if (!this.isSuccess()) {
                                                    GdbPlugin.log(this.getStatus());
                                                }
                                                requestMonitor.done();
                                            }
                                        });
                                    } else {
                                        requestMonitor.done();
                                    }
                                }
                            });
                        }
                    });
                }
                if (GDBMemory.this.fIsBigEndian == null) {
                    stepsList.add(new Sequence.Step(){

                        public void execute(final RequestMonitor requestMonitor) {
                            GDBMemory.this.readEndianness(memContext, (DataRequestMonitor<Boolean>)new ImmediateDataRequestMonitor<Boolean>(requestMonitor){

                                protected void handleCompleted() {
                                    if (this.isSuccess()) {
                                        GDBMemory.this.fIsBigEndian = (Boolean)this.getData();
                                    }
                                    requestMonitor.done();
                                }
                            });
                        }
                    });
                }
                this.steps = stepsList.toArray(new Sequence.Step[stepsList.size()]);
            }

            public Sequence.Step[] getSteps() {
                if (this.steps == null) {
                    this.determineSteps();
                }
                return this.steps;
            }
        });
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent event) {
        IMemory.IMemoryDMContext context;
        if (event.getDMContext() instanceof IRunControl.IContainerDMContext && (context = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)event.getDMContext(), IMemory.IMemoryDMContext.class)) != null) {
            this.fAddressSizes.remove(context);
        }
    }

    @Override
    public int getAddressSize(IMemory.IMemoryDMContext context) {
        Integer addressSize = this.fAddressSizes.get(context);
        return addressSize != null ? addressSize : 8;
    }

    @Override
    public boolean isBigEndian(IMemory.IMemoryDMContext context) {
        assert (this.fIsBigEndian != null);
        if (this.fIsBigEndian == null) {
            GdbPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "Endianness was never initialized!"));
            return false;
        }
        return this.fIsBigEndian;
    }

    protected void readAddressSize(IMemory.IMemoryDMContext memContext, final DataRequestMonitor<Integer> drm) {
        IExpressions exprService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        IExpressions.IExpressionDMContext exprContext = exprService.createExpression((IDMContext)memContext, "sizeof (void*)");
        CommandFactory commandFactory = this.fCommandControl.getCommandFactory();
        this.fCommandControl.queueCommand(commandFactory.createMIDataEvaluateExpression(exprContext), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                try {
                    drm.setData((Object)Integer.decode(((MIDataEvaluateExpressionInfo)this.getData()).getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", String.format("Invalid address size: %s", ((MIDataEvaluateExpressionInfo)this.getData()).getValue())));
                }
                drm.done();
            }
        });
    }

    protected void readEndianness(IMemory.IMemoryDMContext memContext, final DataRequestMonitor<Boolean> drm) {
        CommandFactory commandFactory = this.fCommandControl.getCommandFactory();
        this.fCommandControl.queueCommand(commandFactory.createCLIShowEndian(memContext), (DataRequestMonitor)new DataRequestMonitor<CLIShowEndianInfo>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                drm.setData((Object)((CLIShowEndianInfo)this.getData()).isBigEndian());
                drm.done();
            }
        });
    }
}

