/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.core.IErrorParser2;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.internal.autotools.core.AutotoolsProblemMarkerInfo;
import org.eclipse.cdt.internal.autotools.core.ErrorParser;
import org.eclipse.cdt.internal.autotools.core.MarkerGenerator;
import org.eclipse.cdt.internal.core.IErrorMarkeredOutputStream;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;

public class ErrorParserManager
extends OutputStream {
    public static final char ERROR_PARSER_DELIMITER = ';';
    private int nOpens;
    private int lineCounter = 0;
    private final IProject fProject;
    private final MarkerGenerator fMarkerGenerator;
    private Map<String, ErrorParser> fErrorParsers;
    private ArrayList<ProblemMarkerInfo> fErrors;
    private Vector<URI> fDirectoryStack;
    private final URI fBaseDirectoryURI;
    private String previousLine;
    private OutputStream outputStream;
    private final StringBuilder currentLine = new StringBuilder();

    public ErrorParserManager(IProject project, MarkerGenerator markerGenerator) {
        this(project, markerGenerator, null);
    }

    public ErrorParserManager(IProject project, MarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, project.getLocationURI(), markerGenerator, parsersIDs);
    }

    public ErrorParserManager(IProject project, URI baseDirectoryURI, MarkerGenerator markerGenerator, String[] parsersIDs) {
        this.fProject = project;
        this.fMarkerGenerator = markerGenerator;
        this.fDirectoryStack = new Vector();
        this.fErrors = new ArrayList();
        this.fErrorParsers = new LinkedHashMap<String, ErrorParser>();
        this.fBaseDirectoryURI = baseDirectoryURI != null ? baseDirectoryURI : project.getLocationURI();
    }

    public void addErrorParser(String id, ErrorParser parser) {
        this.fErrorParsers.put(id, parser);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public URI getWorkingDirectoryURI() {
        if (!this.fDirectoryStack.isEmpty()) {
            return this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectoryURI;
    }

    public void pushDirectory(IPath dir) {
        if (dir != null) {
            URI uri;
            URI workingDirectoryURI = this.getWorkingDirectoryURI();
            if (!dir.isAbsolute()) {
                uri = URIUtil.append((URI)workingDirectoryURI, (String)dir.toString());
            } else {
                uri = this.toURI(dir);
                if (uri == null) {
                    return;
                }
            }
            this.pushDirectoryURI(uri);
        }
    }

    public void pushDirectoryURI(URI dir) {
        if (dir != null) {
            if (dir.isAbsolute()) {
                this.fDirectoryStack.addElement(dir);
            } else {
                this.fDirectoryStack.addElement(URIUtil.makeAbsolute((URI)dir, (URI)this.getWorkingDirectoryURI()));
            }
        }
    }

    public URI popDirectoryURI() {
        int i = this.fDirectoryStack.size();
        if (i != 0) {
            URI dir = this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return this.fBaseDirectoryURI;
    }

    public int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    private void processLine(String line) {
        String lineTrimmed = line.trim();
        ++this.lineCounter;
        ProblemMarkerInfo marker = null;
        Iterator<ErrorParser> iterator = this.fErrorParsers.values().iterator();
        while (iterator.hasNext()) {
            boolean consume;
            block14: {
                ErrorParser parser;
                ErrorParser curr = parser = iterator.next();
                int types = 0;
                if (curr instanceof IErrorParser2) {
                    types = ((IErrorParser2)curr).getProcessLineBehaviour();
                }
                if ((types & 4) == 0 && lineTrimmed.length() > 1000) continue;
                String lineToParse = lineTrimmed;
                if ((types & 1) != 0) {
                    lineToParse = line;
                }
                consume = false;
                try {
                    try {
                        consume = curr.processLine(lineToParse, this);
                    }
                    catch (Exception e) {
                        AutotoolsPlugin.log(e);
                        if (this.fErrors.size() > 0) {
                            if (marker == null) {
                                marker = this.fErrors.get(0);
                            }
                            this.fErrors.clear();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (this.fErrors.size() > 0) {
                        if (marker == null) {
                            marker = this.fErrors.get(0);
                        }
                        this.fErrors.clear();
                    }
                    throw throwable;
                }
                if (this.fErrors.size() > 0) {
                    if (marker == null) {
                        marker = this.fErrors.get(0);
                    }
                    this.fErrors.clear();
                }
            }
            if (consume) break;
        }
        this.outputLine(line, marker);
    }

    private void outputLine(String line, ProblemMarkerInfo marker) {
        String l = String.valueOf(line) + "\n";
        if (this.outputStream == null) {
            return;
        }
        try {
            if (marker != null && this.outputStream instanceof IErrorMarkeredOutputStream) {
                IErrorMarkeredOutputStream mos = (IErrorMarkeredOutputStream)this.outputStream;
                mos.write(l, marker);
            }
            byte[] b = l.getBytes();
            this.outputStream.write(b, 0, b.length);
        }
        catch (IOException e) {
            AutotoolsPlugin.log(e);
        }
    }

    public int getLineCounter() {
        return this.lineCounter;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName, AutotoolsProblemMarkerInfo.Type type) {
        this.generateExternalMarker(file, lineNumber, desc, severity, varName, null, null, type);
    }

    public void generateExternalMarker(IResource file, int lineNumber, String desc, int severity, String varName, IPath externalPath, String libraryInfo, AutotoolsProblemMarkerInfo.Type type) {
        AutotoolsProblemMarkerInfo problemMarkerInfo = new AutotoolsProblemMarkerInfo(file, lineNumber, desc, severity, varName, externalPath, libraryInfo, type);
        this.addProblemMarker(problemMarkerInfo);
    }

    public void addProblemMarker(AutotoolsProblemMarkerInfo problemMarkerInfo) {
        this.fErrors.add(problemMarkerInfo.getMarker());
        this.fMarkerGenerator.addMarker(problemMarkerInfo);
    }

    public String getPreviousLine() {
        return new String(this.previousLine == null ? "" : this.previousLine);
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public OutputStream getOutputStream() {
        ++this.nOpens;
        return this;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.checkLine(true);
            this.fDirectoryStack.removeAllElements();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkLine(false);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkLine(false);
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String line = buffer.substring(0, i);
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            this.processLine(line);
            this.previousLine = line;
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
                this.previousLine = buffer;
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    private URI toURI(IPath path) {
        URI baseURI = this.getWorkingDirectoryURI();
        String uriString = path.toString();
        if (path.isAbsolute() && uriString.charAt(0) != '/') {
            uriString = String.valueOf('/') + uriString;
        }
        return EFSExtensionManager.getDefault().createNewURIFromPath(baseURI, uriString);
    }

    public static String toDelimitedString(String[] ids) {
        String result = "";
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            result = result.length() == 0 ? id : String.valueOf(result) + ';' + id;
            ++n2;
        }
        return result;
    }
}

