/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors;

import org.eclipse.cdt.autotools.ui.editors.AutoconfWhitespaceDetector;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class InlineDataRule
implements IRule {
    protected IToken token;
    protected IWordDetector fDetector;
    protected IWhitespaceDetector fWsDetector = new AutoconfWhitespaceDetector();
    protected int fColumn = -1;
    protected static final int UNDEFINED = -1;
    private StringBuffer fBuffer = new StringBuffer();
    private String fStartingSequence = "<<";

    public InlineDataRule(IToken inToken) {
        this.token = inToken;
    }

    protected boolean confirmDelimeter(ICharacterScanner scanner, char[] delimeter) {
        int c = scanner.read();
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)c);
        int i = 1;
        while (i < delimeter.length) {
            if (c != delimeter[i]) {
                int j = buffer.length() - 1;
                while (j >= 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            c = scanner.read();
            buffer.append((char)c);
            ++i;
        }
        scanner.unread();
        return true;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        this.fBuffer.setLength(0);
        int i = 0;
        while (i < this.fStartingSequence.length()) {
            this.fBuffer.append((char)c);
            if (this.fStartingSequence.charAt(i) != c) {
                this.unreadBuffer(scanner);
                return Token.UNDEFINED;
            }
            c = scanner.read();
            ++i;
        }
        char[][] lineDelimeters = scanner.getLegalLineDelimiters();
        StringBuffer endMarkerBuffer = new StringBuffer();
        if (c == 45) {
            this.fBuffer.append((char)c);
            c = scanner.read();
        } else if (c == 39) {
            this.fBuffer.append((char)c);
            c = scanner.read();
        }
        while (c != -1 && Character.isJavaIdentifierPart((char)c) && c != 39) {
            this.fBuffer.append((char)c);
            endMarkerBuffer.append((char)c);
            c = scanner.read();
        }
        if (c == 39) {
            this.fBuffer.append((char)c);
            c = scanner.read();
        }
        if (endMarkerBuffer.length() == 0) {
            this.unreadBuffer(scanner);
            return Token.UNDEFINED;
        }
        boolean eol = false;
        boolean finished = false;
        boolean foundMarker = false;
        String endMarker = endMarkerBuffer.toString();
        while (!finished && c != -1) {
            int i2 = 0;
            while (i2 < lineDelimeters.length) {
                if (c == lineDelimeters[i2][0] && this.confirmDelimeter(scanner, lineDelimeters[i2])) {
                    c = scanner.read();
                    eol = true;
                    break;
                }
                ++i2;
            }
            if (eol) {
                eol = false;
                if (foundMarker) {
                    finished = true;
                    continue;
                }
                foundMarker = false;
                int j = 0;
                while (j < endMarker.length()) {
                    if (c != endMarker.charAt(j)) break;
                    c = scanner.read();
                    ++j;
                }
                if (j != endMarker.length()) continue;
                foundMarker = true;
                continue;
            }
            eol = false;
            foundMarker = false;
            c = scanner.read();
        }
        scanner.unread();
        return this.token;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

