/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsSerializableProvider;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QtIncludePaths
extends LanguageSettingsSerializableProvider {
    private final String qmakePath;
    private long qmakeModTime;
    private String qtInstallHeadersPath;
    private long qtInstallHeadersModTime;
    private static final String ATTR_QMAKE = "qmake";
    private static final String ATTR_QMAKE_MOD = "qmakeModification";
    private static final String ATTR_QT_INSTALL_HEADERS = "QT_INSTALL_HEADERS";
    private static final String ATTR_QT_INSTALL_HEADERS_MOD = "qtInstallHeadersModification";

    public QtIncludePaths(String qmakePath) {
        this.qmakePath = qmakePath;
    }

    public static QtIncludePaths loadFrom(Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element element = (Element)node;
        String qmakePath = element.getAttribute(ATTR_QMAKE);
        if (qmakePath == null || qmakePath.isEmpty()) {
            return null;
        }
        QtIncludePaths qtIncludePaths = new QtIncludePaths(qmakePath);
        qtIncludePaths.load(element);
        return qtIncludePaths;
    }

    public String getQMakePath() {
        return this.qmakePath;
    }

    public boolean isValid() {
        if (this.qmakePath == null || this.qmakePath.isEmpty()) {
            return false;
        }
        File qmake = new File(this.qmakePath);
        return qmake.exists() && qmake.canExecute();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QtIncludePaths)) {
            return super.equals(obj);
        }
        QtIncludePaths other = (QtIncludePaths)((Object)obj);
        return this.qmakePath == null ? other.qmakePath == null : this.qmakePath.equals(other.qmakePath);
    }

    public int hashCode() {
        return this.qmakePath == null ? 0 : this.qmakePath.hashCode();
    }

    public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription configDesc, IResource rc, String languageId) {
        List<ICLanguageSettingEntry> entries = null;
        File qmake = new File(this.qmakePath);
        if (!qmake.exists() || this.qmakeModTime != qmake.lastModified()) {
            entries = this.reload();
        } else {
            File qtInstallHeadersDir = new File(this.qtInstallHeadersPath);
            if (!qtInstallHeadersDir.exists() || this.qtInstallHeadersModTime != qtInstallHeadersDir.lastModified()) {
                entries = this.reload();
            }
        }
        if (entries == null) {
            return super.getSettingEntries(configDesc, rc, languageId);
        }
        this.setSettingEntries(configDesc, rc, languageId, entries);
        this.serializeLanguageSettingsInBackground(null);
        return entries;
    }

    public Element serializeAttributes(Element parentElement) {
        parentElement.setAttribute(ATTR_QMAKE, this.qmakePath);
        parentElement.setAttribute(ATTR_QMAKE_MOD, Long.toString(this.qmakeModTime));
        parentElement.setAttribute(ATTR_QT_INSTALL_HEADERS, this.qtInstallHeadersPath);
        parentElement.setAttribute(ATTR_QT_INSTALL_HEADERS_MOD, Long.toString(this.qtInstallHeadersModTime));
        return parentElement;
    }

    public void loadAttributes(Element element) {
        this.qmakeModTime = QtIncludePaths.getLongAttribute(element, ATTR_QMAKE_MOD);
        this.qtInstallHeadersPath = element.getAttribute(ATTR_QT_INSTALL_HEADERS);
        this.qtInstallHeadersModTime = QtIncludePaths.getLongAttribute(element, ATTR_QT_INSTALL_HEADERS_MOD);
    }

    private static long getLongAttribute(Element element, String attr) {
        String value = element.getAttribute(attr);
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            QtPlugin.log("attribute name:" + attr + " value:" + value, e);
            return 0L;
        }
    }

    private List<ICLanguageSettingEntry> reload() {
        block34: {
            this.qmakeModTime = 0L;
            this.qtInstallHeadersPath = null;
            this.qtInstallHeadersModTime = 0L;
            File qmake = new File(this.qmakePath);
            if (!qmake.exists() || !qmake.canExecute()) {
                return Collections.emptyList();
            }
            this.qmakeModTime = qmake.lastModified();
            BufferedReader reader = null;
            Process process = null;
            try {
                try {
                    process = ProcessFactory.getFactory().exec(new String[]{this.qmakePath, "-query", ATTR_QT_INSTALL_HEADERS});
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    this.qtInstallHeadersPath = reader.readLine();
                }
                catch (IOException e) {
                    QtPlugin.log(e);
                    try {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (process != null) {
                                process.destroy();
                            }
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        if (process != null) {
                            process.destroy();
                        }
                        throw throwable;
                    }
                    if (process != null) {
                        process.destroy();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                block36: {
                    try {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (process != null) {
                                process.destroy();
                            }
                            break block36;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (process != null) {
                            process.destroy();
                        }
                        throw throwable2;
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                throw throwable;
            }
            try {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    if (process != null) {
                        process.destroy();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (process != null) {
                    process.destroy();
                }
                throw throwable;
            }
            if (process != null) {
                process.destroy();
            }
        }
        if (this.qtInstallHeadersPath == null) {
            return Collections.emptyList();
        }
        File qtInstallHeadersDir = new File(this.qtInstallHeadersPath);
        this.qtInstallHeadersModTime = qtInstallHeadersDir.lastModified();
        if (!(qtInstallHeadersDir.exists() && qtInstallHeadersDir.canRead() && qtInstallHeadersDir.isDirectory())) {
            return Collections.emptyList();
        }
        File[] files = qtInstallHeadersDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.exists() && pathname.isDirectory();
            }
        });
        ArrayList<ICLanguageSettingEntry> entries = new ArrayList<ICLanguageSettingEntry>(files.length + 1);
        QtIncludePaths.safeAdd(entries, qtInstallHeadersDir);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            QtIncludePaths.safeAdd(entries, file);
            ++n2;
        }
        return entries;
    }

    private static void safeAdd(List<ICLanguageSettingEntry> entries, File file) {
        try {
            entries.add((ICLanguageSettingEntry)new CIncludePathEntry(file.getCanonicalPath(), 18));
        }
        catch (IOException e) {
            QtPlugin.log(e);
        }
    }
}

