/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventFireDelegate;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.osgi.framework.Bundle;

public final class EventManager {
    private boolean extensionPointProcessed = false;
    private final List<ListenerListEntry> listeners = new ArrayList<ListenerListEntry>();

    EventManager() {
    }

    public static EventManager getInstance() {
        return LazyInstance.instance;
    }

    public void addEventListener(IEventListener listener, Class<?> eventType) {
        Class[] classArray;
        if (eventType != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = eventType;
        } else {
            classArray = null;
        }
        this.addEventListener(listener, classArray, null);
    }

    public void addEventListener(IEventListener listener, Class<?>[] eventTypes) {
        this.addEventListener(listener, eventTypes, null);
    }

    public void addEventListener(IEventListener listener, Class<?> eventType, Object eventSource) {
        Object[] objectArray;
        Class[] classArray;
        if (eventType != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = eventType;
        } else {
            classArray = null;
        }
        if (eventSource != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = eventSource;
        } else {
            objectArray = null;
        }
        this.addEventListener(listener, classArray, objectArray);
    }

    public void addEventListener(IEventListener listener, Class<?> eventType, Object[] eventSources) {
        Class[] classArray;
        if (eventType != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = eventType;
        } else {
            classArray = null;
        }
        this.addEventListener(listener, classArray, eventSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(IEventListener listener, Class<?>[] eventTypes, Object[] eventSources) {
        ListenerListEntry listEntry = new ListenerListEntry(this, listener, eventTypes, eventSources);
        List<ListenerListEntry> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listEntry)) {
                this.listeners.remove(listEntry);
            }
            this.listeners.add(listEntry);
        }
    }

    public void removeEventListener(IEventListener listener) {
        ListenerListEntry listEntry = new ListenerListEntry(this, listener, null, (Object)null);
        this.listeners.remove(listEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.listeners.clear();
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.extensionPointProcessed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(EventObject event) {
        ListenerListEntry[] registered;
        Assert.isNotNull((Object)event);
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (!this.extensionPointProcessed) {
                this.addExtensionPointNotificationListeners();
                this.extensionPointProcessed = true;
            }
        }
        ArrayList<ListenerListEntry> affected = new ArrayList<ListenerListEntry>();
        ListenerListEntry[] listenerListEntryArray = registered = this.listeners.toArray(new ListenerListEntry[this.listeners.size()]);
        int n = registered.length;
        int n2 = 0;
        while (n2 < n) {
            ListenerListEntry listEntry = listenerListEntryArray[n2];
            if (listEntry.listensTo(event)) {
                affected.add(listEntry);
            }
            ++n2;
        }
        if (affected.size() == 0) {
            return;
        }
        for (ListenerListEntry listEntry : affected) {
            if (!(listEntry.getListener() instanceof IEventListener)) continue;
            FireRunnable runnable = new FireRunnable((IEventListener)listEntry.getListener(), event);
            if (listEntry.getListener() instanceof IEventFireDelegate) {
                ((IEventFireDelegate)((Object)listEntry.getListener())).fire(runnable);
                continue;
            }
            runnable.run();
        }
    }

    private void addExtensionPointNotificationListeners() {
        IExtension[] extensions;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tcf.te.runtime.eventListeners");
        if (ep != null && (extensions = ep.getExtensions()) != null && extensions.length > 0) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                if (configElements != null && configElements.length > 0) {
                    IConfigurationElement[] iConfigurationElementArray = configElements;
                    int n3 = configElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        String name = configElement.getName();
                        if ("eventListener".equals(name)) {
                            IConfigurationElement[] children;
                            ArrayList<Class> eventTypes = new ArrayList<Class>();
                            ArrayList<Class> eventSourceTypes = new ArrayList<Class>();
                            IConfigurationElement[] iConfigurationElementArray2 = children = configElement.getChildren();
                            int n5 = children.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                block20: {
                                    Bundle bundle;
                                    String bundleId;
                                    String className;
                                    IConfigurationElement child;
                                    block21: {
                                        child = iConfigurationElementArray2[n6];
                                        if ("eventType".equals(child.getName())) {
                                            try {
                                                Class eventType;
                                                className = child.getAttribute("class");
                                                if (className == null || className.trim().length() == 0) break block20;
                                                bundleId = child.getAttribute("bundleId");
                                                Bundle bundle2 = bundle = bundleId != null ? (bundle = Platform.getBundle((String)bundleId)) : null;
                                                if (bundle == null) {
                                                    bundle = Platform.getBundle((String)child.getDeclaringExtension().getNamespaceIdentifier());
                                                }
                                                if (bundle == null) {
                                                    bundle = CoreBundleActivator.getContext().getBundle();
                                                }
                                                Class clazz = eventType = bundle != null ? bundle.loadClass(className) : Class.forName(className);
                                                if (!eventTypes.contains(eventType)) {
                                                    eventTypes.add(eventType);
                                                }
                                            }
                                            catch (Exception exception) {
                                                if (!EventManager.isTracingEnabled()) break block21;
                                                CoreBundleActivator.getTraceHandler().trace("Error instantiating event listener event type object instance: " + child.getAttribute("class"), 0, "trace/events", 4, this);
                                            }
                                        }
                                    }
                                    if ("eventSourceType".equals(child.getName())) {
                                        try {
                                            className = child.getAttribute("class");
                                            if (className != null && className.trim().length() != 0) {
                                                Class eventSourceType;
                                                bundleId = child.getAttribute("bundleId");
                                                Bundle bundle3 = bundle = bundleId != null ? (bundle = Platform.getBundle((String)bundleId)) : null;
                                                if (bundle == null) {
                                                    bundle = Platform.getBundle((String)child.getDeclaringExtension().getNamespaceIdentifier());
                                                }
                                                if (bundle == null) {
                                                    bundle = CoreBundleActivator.getContext().getBundle();
                                                }
                                                Class clazz = eventSourceType = bundle != null ? bundle.loadClass(className) : Class.forName(className);
                                                if (!eventSourceTypes.contains(eventSourceType)) {
                                                    eventSourceTypes.add(eventSourceType);
                                                }
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (!EventManager.isTracingEnabled()) break block20;
                                            CoreBundleActivator.getTraceHandler().trace("Error instantiating event listener event source type object instance: " + child.getAttribute("class"), 0, "trace/events", 4, this);
                                        }
                                    }
                                }
                                ++n6;
                            }
                            EventListenerProxy listener = new EventListenerProxy(configElement);
                            this.addEventListener((IEventListener)listener, !eventTypes.isEmpty() ? eventTypes.toArray(new Class[eventTypes.size()]) : null, !eventSourceTypes.isEmpty() ? eventSourceTypes.toArray(new Class[eventSourceTypes.size()]) : null);
                            if (EventManager.isTracingEnabled()) {
                                CoreBundleActivator.getTraceHandler().trace("Add extension point change listener: " + configElement.getAttribute("class"), 0, "trace/events", 1, this);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public static boolean isTracingEnabled() {
        return CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/events");
    }

    private class EventListenerProxy
    implements IEventListener,
    IEventFireDelegate {
        private final IConfigurationElement configElement;
        private IEventListener delegate;

        public EventListenerProxy(IConfigurationElement configElement) {
            Assert.isNotNull((Object)configElement);
            this.configElement = configElement;
            this.delegate = null;
        }

        private IEventListener getDelegate() {
            block6: {
                if (this.delegate == null) {
                    boolean forcePluginActivation = Boolean.parseBoolean(this.configElement.getAttribute("forcePluginActivation"));
                    if (!forcePluginActivation) {
                        Bundle bundle = Platform.getBundle((String)this.configElement.getContributor().getName());
                        boolean bl = bundle != null ? bundle.getState() == 32 : (forcePluginActivation = false);
                    }
                    if (forcePluginActivation) {
                        try {
                            Object executable = this.configElement.createExecutableExtension("class");
                            if (executable instanceof IEventListener) {
                                this.delegate = (IEventListener)executable;
                            }
                        }
                        catch (Exception ex) {
                            if (!EventManager.isTracingEnabled()) break block6;
                            CoreBundleActivator.getTraceHandler().trace("Error instantiating extension point event listener: " + this.configElement.getAttribute("class") + "(Possible Cause: " + ex.getLocalizedMessage() + ")", 0, "trace/events", 4, this);
                        }
                    }
                }
            }
            return this.delegate;
        }

        @Override
        public void eventFired(EventObject event) {
            Assert.isNotNull((Object)event);
            IEventListener delegate = this.getDelegate();
            if (delegate != null) {
                delegate.eventFired(event);
            }
        }

        @Override
        public void fire(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            if (this.getDelegate() instanceof IEventFireDelegate) {
                ((IEventFireDelegate)((Object)this.getDelegate())).fire(runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected static class FireRunnable
    implements Runnable {
        private final IEventListener listener;
        private final EventObject event;

        public FireRunnable(IEventListener listener, EventObject event) {
            Assert.isNotNull((Object)listener);
            Assert.isNotNull((Object)event);
            this.listener = listener;
            this.event = event;
        }

        @Override
        public void run() {
            this.listener.eventFired(this.event);
        }
    }

    private static class LazyInstance {
        public static EventManager instance = new EventManager();

        private LazyInstance() {
        }
    }

    private class ListenerListEntry {
        private final IEventListener listener;
        private final Object[] eventSources;
        private final Class<?>[] eventTypes;
        final /* synthetic */ EventManager this$0;

        protected ListenerListEntry(EventManager eventManager, IEventListener listener, Class<?> eventType, Object eventSource) {
            Object[] objectArray;
            Class[] classArray;
            if (eventType == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = eventType;
            }
            if (eventSource == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = eventSource;
            }
            this(eventManager, listener, classArray, objectArray);
        }

        protected ListenerListEntry(EventManager eventManager, IEventListener listener, Class<?>[] eventTypes, Object[] eventSources) {
            this.this$0 = eventManager;
            this.listener = listener;
            this.eventTypes = eventTypes == null || eventTypes.length == 0 ? null : eventTypes;
            this.eventSources = eventSources == null || eventSources.length == 0 ? null : eventSources;
        }

        protected EventListener getListener() {
            return this.listener;
        }

        protected boolean listensTo(EventObject event) {
            boolean types = this.eventTypes == null || this.eventTypes.length == 0;
            boolean sources = this.eventSources == null || this.eventSources.length == 0;
            int t = 0;
            while (!types && this.eventTypes != null && t < this.eventTypes.length) {
                types = this.eventTypes[t].isInstance(event);
                ++t;
            }
            int s = 0;
            while (!sources && this.eventSources != null && s < this.eventSources.length) {
                Object eventSource = this.eventSources[s];
                if (eventSource instanceof Class) {
                    Class eventSourceClass = (Class)eventSource;
                    sources = eventSourceClass.isInstance(event.getSource());
                } else {
                    sources = eventSource == event.getSource();
                }
                ++s;
            }
            return types && sources;
        }

        public int hashCode() {
            if (this.getListener() != null) {
                return this.getListener().hashCode();
            }
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListenerListEntry) {
                ListenerListEntry other = (ListenerListEntry)obj;
                return this.getListener() == other.getListener();
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "{" + "listener=" + this.listener + ",eventTypes=" + Arrays.deepToString(this.eventTypes) + ",eventSources=" + Arrays.deepToString(this.eventSources) + "}";
        }
    }
}

