/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.lm.delegates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.tcf.te.core.cdt.CdtUtils;
import org.eclipse.tcf.te.launch.core.exceptions.LaunchServiceException;
import org.eclipse.tcf.te.launch.core.interfaces.IReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.lm.delegates.DefaultLaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.filetransfer.FileTransfersPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.selection.interfaces.IProjectSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.IRemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.filetransfer.FileTransferItem;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;

public class RemoteAppLaunchManagerDelegate
extends DefaultLaunchManagerDelegate {
    private static final String[] MANDATORY_CONFIG_ATTRIBUTES = new String[]{"org.eclipse.tcf.te.launch.launch_contexts", "org.eclipse.tcf.te.tcf.processes.core.process_image"};

    public void initLaunchConfigAttributes(ILaunchConfigurationWorkingCopy wc, ILaunchSpecification launchSpec) {
        super.initLaunchConfigAttributes(wc, launchSpec);
        wc.setAttribute("org.eclipse.tcf.te.tcf.processes.core.process_stop_at_main", true);
        wc.setAttribute("org.eclipse.tcf.te.tcf.processes.core.process_attach_children", true);
        try {
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, CdtUtils.getDefaultSourceLookupDirector().getMemento());
            IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchSpecification)launchSpec);
            if (contexts != null && contexts.length == 1) {
                ILaunchConfiguration attachLaunch = (ILaunchConfiguration)Platform.getAdapterManager().getAdapter((Object)contexts[0], ILaunchConfiguration.class);
                wc.setAttribute("org.eclipse.tcf.debug.PathMap", attachLaunch.getAttribute("org.eclipse.tcf.debug.PathMap", null));
            }
        }
        catch (Exception exception) {}
        this.copySpecToConfig(launchSpec, wc);
        wc.rename(this.getDefaultLaunchName((ILaunchConfiguration)wc));
    }

    public void updateLaunchConfig(ILaunchConfigurationWorkingCopy wc, ISelectionContext selContext, boolean replace) {
        super.updateLaunchConfig(wc, selContext, replace);
        if (selContext instanceof IProjectSelectionContext) {
            if (replace) {
                ArrayList<IFileTransferItem> transfers = new ArrayList<IFileTransferItem>();
                ArrayList<IReferencedProjectItem> projects = new ArrayList<IReferencedProjectItem>();
                String processPath = this.getProcessImageAndSetProjectAndTransfer((IProjectSelectionContext)selContext, transfers, projects);
                FileTransfersPersistenceDelegate.setFileTransfers((ILaunchConfigurationWorkingCopy)wc, (IFileTransferItem[])transfers.toArray(new IFileTransferItem[transfers.size()]));
                ReferencedProjectsPersistenceDelegate.setReferencedProjects((ILaunchConfigurationWorkingCopy)wc, (IReferencedProjectItem[])projects.toArray(new IReferencedProjectItem[projects.size()]));
                if (processPath != null && processPath.trim().length() > 0) {
                    DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)wc, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image", (String)processPath);
                }
            } else {
                ArrayList<IFileTransferItem> transfers = new ArrayList<IFileTransferItem>(Arrays.asList(FileTransfersPersistenceDelegate.getFileTransfers((ILaunchConfiguration)wc)));
                ArrayList<IReferencedProjectItem> projects = new ArrayList<IReferencedProjectItem>(Arrays.asList(ReferencedProjectsPersistenceDelegate.getReferencedProjects((ILaunchConfiguration)wc)));
                String processPath = this.getProcessImageAndSetProjectAndTransfer((IProjectSelectionContext)selContext, transfers, projects);
                FileTransfersPersistenceDelegate.setFileTransfers((ILaunchConfigurationWorkingCopy)wc, (IFileTransferItem[])transfers.toArray(new IFileTransferItem[transfers.size()]));
                ReferencedProjectsPersistenceDelegate.setReferencedProjects((ILaunchConfigurationWorkingCopy)wc, (IReferencedProjectItem[])projects.toArray(new IReferencedProjectItem[projects.size()]));
                if (processPath != null && processPath.trim().length() > 0 && !DefaultPersistenceDelegate.hasAttribute((ILaunchConfiguration)wc, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image")) {
                    DefaultPersistenceDelegate.setAttribute((ILaunchConfigurationWorkingCopy)wc, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image", (String)processPath);
                }
            }
        } else if (selContext instanceof IRemoteSelectionContext) {
            IRemoteSelectionContext remoteCtx = (IRemoteSelectionContext)selContext;
            LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchConfigurationWorkingCopy)wc, (IModelNode[])new IModelNode[]{remoteCtx.getRemoteCtx()});
        }
        wc.rename(this.getDefaultLaunchName((ILaunchConfiguration)wc));
    }

    protected ILaunchSpecification addLaunchSpecAttributes(ILaunchSpecification launchSpec, String launchConfigTypeId, ISelectionContext selectionContext) {
        launchSpec = super.addLaunchSpecAttributes(launchSpec, launchConfigTypeId, selectionContext);
        if (selectionContext instanceof IRemoteSelectionContext) {
            IModelNode remoteCtx;
            ArrayList<IModelNode> launchContexts = new ArrayList<IModelNode>(Arrays.asList(LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchSpecification)launchSpec)));
            if (!launchContexts.contains(remoteCtx = ((IRemoteSelectionContext)selectionContext).getRemoteCtx())) {
                launchContexts.add(remoteCtx);
                LaunchContextsPersistenceDelegate.setLaunchContexts((ILaunchSpecification)launchSpec, (IModelNode[])launchContexts.toArray(new IModelNode[launchContexts.size()]));
            }
            launchSpec.setLaunchConfigName(this.getDefaultLaunchName(launchSpec));
        } else if (selectionContext instanceof IProjectSelectionContext) {
            ArrayList<IFileTransferItem> transfers = new ArrayList<IFileTransferItem>(Arrays.asList(FileTransfersPersistenceDelegate.getFileTransfers((ILaunchSpecification)launchSpec)));
            ArrayList<IReferencedProjectItem> projects = new ArrayList<IReferencedProjectItem>(Arrays.asList(ReferencedProjectsPersistenceDelegate.getReferencedProjects((ILaunchSpecification)launchSpec)));
            String processPath = this.getProcessImageAndSetProjectAndTransfer((IProjectSelectionContext)selectionContext, transfers, projects);
            FileTransfersPersistenceDelegate.setFileTransfers((ILaunchSpecification)launchSpec, (IFileTransferItem[])transfers.toArray(new IFileTransferItem[transfers.size()]));
            ReferencedProjectsPersistenceDelegate.setReferencedProjects((ILaunchSpecification)launchSpec, (IReferencedProjectItem[])projects.toArray(new IReferencedProjectItem[projects.size()]));
            launchSpec.addAttribute("org.eclipse.tcf.te.tcf.processes.core.process_image", (Object)processPath);
            launchSpec.setLaunchConfigName(this.getDefaultLaunchName(launchSpec));
        }
        return launchSpec;
    }

    public String getDefaultLaunchName(ILaunchSpecification launchSpec) {
        IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchSpecification)launchSpec);
        String processPath = (String)launchSpec.getAttribute("org.eclipse.tcf.te.tcf.processes.core.process_image", null);
        String name = this.getDefaultLaunchName(contexts != null && contexts.length > 0 ? contexts[0] : null, processPath);
        return name.trim().length() > 0 ? name.trim() : super.getDefaultLaunchName(launchSpec);
    }

    public String getDefaultLaunchName(ILaunchConfiguration launchConfig) {
        IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)launchConfig);
        String processPath = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)launchConfig, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image", null);
        String name = this.getDefaultLaunchName(contexts != null && contexts.length > 0 ? contexts[0] : null, processPath);
        return name.trim().length() > 0 ? name.trim() : super.getDefaultLaunchName(launchConfig);
    }

    private String getDefaultLaunchName(IModelNode context, String processPath) {
        String name = "";
        if (processPath != null) {
            name = String.valueOf(name) + new Path(processPath).lastSegment();
        }
        if (context != null) {
            IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)context, IPropertiesAccessService.class);
            Object dnsName = service != null ? service.getProperty((Object)context, "dns.name.transient") : null;
            String ctxName = service != null ? (String)service.getTargetAddress((Object)context).get("address") : null;
            ctxName = dnsName != null && dnsName.toString().trim().length() > 0 ? dnsName.toString().trim() : ctxName;
            name = String.valueOf(name) + " (" + ctxName + ")";
        }
        return name.trim();
    }

    private String getProcessImageAndSetProjectAndTransfer(IProjectSelectionContext prjContext, List<IFileTransferItem> transfers, List<IReferencedProjectItem> projects) {
        String processName = null;
        String processPath = null;
        boolean added = false;
        Object[] objectArray = prjContext.getSelections();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selection = objectArray[n2];
            if (selection instanceof IPath) {
                IPath path = (IPath)selection;
                FileTransferItem transfer = new FileTransferItem(path, (IPath)new Path("/tmp/"));
                if (!transfers.contains(transfer)) {
                    transfers.add((IFileTransferItem)transfer);
                }
                if (!added) {
                    processName = path.lastSegment();
                    processPath = "/tmp/" + processName;
                }
                added = true;
            }
            ++n2;
        }
        ReferencedProjectItem project = new ReferencedProjectItem(prjContext.getProjectCtx().getName());
        if (!projects.contains(project)) {
            projects.add((IReferencedProjectItem)project);
        }
        return processPath;
    }

    public void validate(String launchMode, ILaunchConfiguration launchConfig) throws LaunchServiceException {
        super.validate(launchMode, launchConfig);
        StringBuilder missingAttributes = new StringBuilder();
        String[] stringArray = MANDATORY_CONFIG_ATTRIBUTES;
        int n = MANDATORY_CONFIG_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!this.isValidAttribute(attribute, launchConfig, launchMode)) {
                if (missingAttributes.length() == 0) {
                    missingAttributes.append(attribute);
                } else {
                    missingAttributes.append(", ");
                    missingAttributes.append(attribute);
                }
            }
            ++n2;
        }
        if (missingAttributes.length() > 0) {
            throw new LaunchServiceException("Missing launch configuration attributes: \n" + missingAttributes.toString(), 1);
        }
    }

    protected int equals(String attributeKey, Object specValue, Object confValue, ILaunchSpecification launchSpec, ILaunchConfiguration launchConfig, String launchMode) {
        if ("org.eclipse.tcf.te.tcf.processes.core.process_image".equals(attributeKey)) {
            int match;
            int n = match = specValue.equals(confValue) ? 2 : 0;
            if (match != 2) {
                Path confPath = new Path(confValue.toString());
                Path specPath = new Path(specValue.toString());
                match = confPath.lastSegment().equals(specPath.lastSegment()) ? 1 : 0;
            }
            return match;
        }
        return super.equals(attributeKey, specValue, confValue, launchSpec, launchConfig, launchMode);
    }

    protected int getNumAttributes() {
        return 8;
    }

    protected int getAttributeRanking(String attributeKey) {
        if ("org.eclipse.tcf.te.launch.launch_contexts".equals(attributeKey)) {
            return this.getNumAttributes() * 256;
        }
        if ("org.eclipse.tcf.te.tcf.processes.core.process_image".equals(attributeKey)) {
            return this.getNumAttributes() * 128;
        }
        if ("org.eclipse.tcf.te.tcf.processes.core.process_arguments".equals(attributeKey)) {
            return this.getNumAttributes() * 64;
        }
        if ("org.eclipse.tcf.te.launch.file_transfers".equals(attributeKey)) {
            return this.getNumAttributes() * 32;
        }
        if ("org.eclipse.tcf.te.launch.referencedProjects".equals(attributeKey)) {
            return this.getNumAttributes() * 16;
        }
        if ("org.eclipse.tcf.te.tcf.processes.core.process_stop_at_entry".equals(attributeKey)) {
            return this.getNumAttributes() * 8;
        }
        if ("org.eclipse.tcf.te.tcf.processes.core.process_stop_at_main".equals(attributeKey)) {
            return this.getNumAttributes() * 4;
        }
        if ("org.eclipse.tcf.te.tcf.processes.core.process_attach_children".equals(attributeKey)) {
            return this.getNumAttributes() * 2;
        }
        return 1;
    }

    public String getDescription(ILaunchConfiguration config) {
        String image = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)config, (String)"org.eclipse.tcf.te.tcf.processes.core.process_image", null);
        String args = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)config, (String)"org.eclipse.tcf.te.tcf.processes.core.process_arguments", (String)"");
        if (image != null) {
            return String.valueOf(new Path(image).toPortableString()) + " " + args;
        }
        return "";
    }
}

