/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class ContentTypeHelper {
    private static final String CONTENT_TYPE_BINARY_ID = "org.eclipse.cdt.core.binaryFile";

    public static boolean isBinaryFile(FSTreeNode node) {
        IContentType binaryFile;
        IContentType contentType = ContentTypeHelper.getContentType(node);
        return contentType != null && (binaryFile = Platform.getContentTypeManager().getContentType(CONTENT_TYPE_BINARY_ID)) != null && contentType.isKindOf(binaryFile);
    }

    public static IContentType getContentType(FSTreeNode node) {
        if (PersistenceManager.getInstance().isUnresovled(node)) {
            return null;
        }
        IContentType contentType = PersistenceManager.getInstance().getResolved(node);
        if (contentType != null) {
            return contentType;
        }
        contentType = Platform.getContentTypeManager().findContentTypeFor(node.name);
        if (contentType == null) {
            try {
                contentType = ContentTypeHelper.findContentTypeByStream(node);
            }
            catch (Exception exception) {}
        }
        if (contentType != null) {
            PersistenceManager.getInstance().addResovled(node, contentType);
        } else {
            PersistenceManager.getInstance().addUnresolved(node);
        }
        return contentType;
    }

    private static IContentType findContentTypeByStream(FSTreeNode node) throws CoreException, IOException {
        IContentType iContentType;
        block9: {
            InputStream is = null;
            try {
                File file = CacheManager.getCacheFile(node);
                if (file.exists()) {
                    IPath path = CacheManager.getCachePath(node);
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
                    is = fileStore.openInputStream(0, null);
                } else {
                    URL url = node.getLocationURL();
                    is = url.openStream();
                }
                iContentType = Platform.getContentTypeManager().findContentTypeFor(is, node.name);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return iContentType;
    }
}

