/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.gnu.c.IGCCASTArrayRangeDesignator;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTArrayRangeDesignator
extends ASTNode
implements IGCCASTArrayRangeDesignator,
IASTAmbiguityParent {
    private IASTExpression floor;
    private IASTExpression ceiling;

    public CASTArrayRangeDesignator() {
    }

    public CASTArrayRangeDesignator(IASTExpression floor, IASTExpression ceiling) {
        this.setRangeFloor(floor);
        this.setRangeCeiling(ceiling);
    }

    @Override
    public CASTArrayRangeDesignator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTArrayRangeDesignator copy(IASTNode.CopyStyle style) {
        CASTArrayRangeDesignator copy = new CASTArrayRangeDesignator();
        copy.setRangeFloor(this.floor == null ? null : this.floor.copy(style));
        copy.setRangeCeiling(this.ceiling == null ? null : this.ceiling.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IASTExpression getRangeFloor() {
        return this.floor;
    }

    @Override
    public void setRangeFloor(IASTExpression expression) {
        this.assertNotFrozen();
        this.floor = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(SUBSCRIPT_FLOOR_EXPRESSION);
        }
    }

    @Override
    public IASTExpression getRangeCeiling() {
        return this.ceiling;
    }

    @Override
    public void setRangeCeiling(IASTExpression expression) {
        this.assertNotFrozen();
        this.ceiling = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(SUBSCRIPT_CEILING_EXPRESSION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDesignators) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.floor != null && !this.floor.accept(action)) {
            return false;
        }
        if (this.ceiling != null && !this.ceiling.accept(action)) {
            return false;
        }
        return !action.shouldVisitDesignators || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.floor) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.floor = (IASTExpression)other;
        }
        if (child == this.ceiling) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.ceiling = (IASTExpression)other;
        }
    }
}

