/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSwitchStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;

public class CPPASTSwitchStatement
extends ASTAttributeOwner
implements ICPPASTSwitchStatement,
IASTAmbiguityParent {
    private IScope scope;
    private IASTExpression controllerExpression;
    private IASTDeclaration controllerDeclaration;
    private IASTStatement body;

    public CPPASTSwitchStatement() {
    }

    public CPPASTSwitchStatement(IASTDeclaration controller, IASTStatement body) {
        this.setControllerDeclaration(controller);
        this.setBody(body);
    }

    public CPPASTSwitchStatement(IASTExpression controller, IASTStatement body) {
        this.setControllerExpression(controller);
        this.setBody(body);
    }

    @Override
    public CPPASTSwitchStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTSwitchStatement copy(IASTNode.CopyStyle style) {
        CPPASTSwitchStatement copy = new CPPASTSwitchStatement();
        copy.setControllerDeclaration(this.controllerDeclaration == null ? null : this.controllerDeclaration.copy(style));
        copy.setControllerExpression(this.controllerExpression == null ? null : this.controllerExpression.copy(style));
        copy.setBody(this.body == null ? null : this.body.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getControllerExpression() {
        return this.controllerExpression;
    }

    @Override
    public void setControllerExpression(IASTExpression controller) {
        this.assertNotFrozen();
        this.controllerExpression = controller;
        if (controller != null) {
            controller.setParent(this);
            controller.setPropertyInParent(CONTROLLER_EXP);
            this.controllerDeclaration = null;
        }
    }

    @Override
    public IASTStatement getBody() {
        return this.body;
    }

    @Override
    public void setBody(IASTStatement body) {
        this.assertNotFrozen();
        this.body = body;
        if (body != null) {
            body.setParent(this);
            body.setPropertyInParent(BODY);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributes(action)) {
            return false;
        }
        if (this.controllerExpression != null && !this.controllerExpression.accept(action)) {
            return false;
        }
        if (this.controllerDeclaration != null && !this.controllerDeclaration.accept(action)) {
            return false;
        }
        if (this.body != null && !this.body.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.body == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.body = (IASTStatement)other;
        } else if (this.controllerDeclaration == child || this.controllerExpression == child) {
            if (other instanceof IASTExpression) {
                this.setControllerExpression((IASTExpression)other);
            } else if (other instanceof IASTDeclaration) {
                this.setControllerDeclaration((IASTDeclaration)other);
            }
        }
    }

    @Override
    public IASTDeclaration getControllerDeclaration() {
        return this.controllerDeclaration;
    }

    @Override
    public void setControllerDeclaration(IASTDeclaration d) {
        this.assertNotFrozen();
        this.controllerDeclaration = d;
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(CONTROLLER_DECLARATION);
            this.controllerExpression = null;
        }
    }

    @Override
    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPBlockScope(this);
        }
        return this.scope;
    }
}

