/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor.pages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tcf.te.core.interfaces.IFilterable;
import org.eclipse.tcf.te.core.interfaces.IPropertyChangeProvider;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.trees.TreeControl;
import org.eclipse.tcf.te.ui.utils.TreeViewerUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractCustomFormToolkitEditorPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.osgi.framework.Bundle;

public abstract class TreeViewerExplorerEditorPage
extends AbstractCustomFormToolkitEditorPage
implements IDoubleClickListener {
    private TreeControl treeControl;
    private IToolBarManager toolbarMgr;
    private PropertyChangeListener pcListener;
    private Image formImage;

    @Override
    public void dispose() {
        IPropertyChangeProvider provider = this.getPropertyChangeProvider();
        if (provider != null && this.pcListener != null) {
            provider.removePropertyChangeListener(this.pcListener);
        }
        if (this.formImage != null) {
            this.formImage.dispose();
        }
        if (this.treeControl != null) {
            this.treeControl.dispose();
            this.treeControl = null;
        }
        super.dispose();
    }

    public void setFocus() {
        Control control = this.treeControl.getViewer().getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        ImageDescriptor iconDesc;
        URL iconURL;
        String bundleId;
        Bundle bundle;
        super.setInitializationData(config, propertyName, data);
        String iconPath = config.getAttribute("icon");
        if (iconPath != null && (bundle = Platform.getBundle((String)(bundleId = config.getContributor().getName()))) != null && (iconURL = bundle.getEntry(iconPath)) != null && (iconDesc = ImageDescriptor.createFromURL((URL)iconURL)) != null) {
            this.formImage = iconDesc.createImage();
        }
        this.treeControl = this.doCreateTreeControl();
    }

    @Override
    protected Image getFormImage() {
        return this.formImage;
    }

    @Override
    protected void createToolbarContributionItems(IToolBarManager manager) {
        this.toolbarMgr = manager;
        this.treeControl.createToolbarContributionItems(manager);
        super.createToolbarContributionItems(manager);
    }

    @Override
    protected void doCreateFormContent(Composite parent, CustomFormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        Assert.isNotNull((Object)this.treeControl);
        this.treeControl.setupFormPanel(parent, toolkit);
        this.getSite().registerContextMenu(this.getId(), this.treeControl.getContextMenuManager(), (ISelectionProvider)this.treeControl.getViewer());
        Object input = this.getViewerInput();
        this.treeControl.getViewer().setInput(input);
        this.addViewerListeners();
        this.adjustTreeColumnWidth(this.treeControl.getViewer());
        this.updateUI();
    }

    protected void adjustTreeColumnWidth(Viewer viewer) {
        if (!(viewer instanceof TreeViewer)) {
            return;
        }
        TreeViewer treeViewer = (TreeViewer)viewer;
        final Tree tree = treeViewer.getTree();
        tree.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                TreeColumn[] columns;
                int sumColumnWidth = 0;
                int treeWidth = tree.getSize().x - tree.getVerticalBar().getSize().x;
                TreeColumn[] treeColumnArray = columns = tree.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn column = treeColumnArray[n2];
                    Object widthHint = column.getData("widthHint");
                    sumColumnWidth += widthHint instanceof Integer ? ((Integer)widthHint).intValue() : column.getWidth();
                    ++n2;
                }
                int sumColumnWidth2 = 0;
                TreeColumn maxColumn = null;
                TreeColumn[] treeColumnArray2 = columns;
                int n3 = columns.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeColumn column = treeColumnArray2[n4];
                    Object widthHint = column.getData("widthHint");
                    int width = widthHint instanceof Integer ? ((Integer)widthHint).intValue() : column.getWidth();
                    int weight = width * 100 / sumColumnWidth;
                    int newWidth = weight * treeWidth / 100;
                    sumColumnWidth2 += newWidth;
                    column.setWidth(newWidth);
                    if (maxColumn == null || maxColumn.getWidth() < column.getWidth()) {
                        maxColumn = column;
                    }
                    ++n4;
                }
                if (sumColumnWidth2 > treeWidth && maxColumn != null) {
                    int delta = sumColumnWidth2 - treeWidth + 2;
                    maxColumn.setWidth(maxColumn.getWidth() - delta);
                }
                tree.removeControlListener((ControlListener)this);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void addViewerListeners() {
        TreeViewer viewer = (TreeViewer)this.treeControl.getViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewerExplorerEditorPage.this.propagateSelection();
            }
        });
        viewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TreeViewerExplorerEditorPage.this.propagateSelection();
            }
        });
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        IPropertyChangeProvider provider = this.getPropertyChangeProvider();
        if (provider != null) {
            this.pcListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Object input;
                    Object object = event.getSource();
                    if (object == (input = TreeViewerExplorerEditorPage.this.getTreeViewerInput())) {
                        if (Display.getCurrent() != null) {
                            TreeViewerExplorerEditorPage.this.updateUI();
                        } else {
                            Display display = TreeViewerExplorerEditorPage.this.getSite().getShell().getDisplay();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TreeViewerExplorerEditorPage.this.updateUI();
                                }
                            });
                        }
                    }
                }
            };
            provider.addPropertyChangeListener(this.pcListener);
        }
    }

    public Object getAdapter(Class adapter) {
        if (TreeViewer.class.equals((Object)adapter)) {
            return this.treeControl.getViewer();
        }
        return super.getAdapter(adapter);
    }

    private Object getAdapter(Object adaptable, Class adapter) {
        Object adapted = null;
        if (adapter.isInstance(adaptable)) {
            adapted = adaptable;
        }
        if (adapted == null && adaptable instanceof IAdaptable) {
            adapted = ((IAdaptable)adaptable).getAdapter(adapter);
        }
        if (adapted == null && adaptable != null) {
            adapted = Platform.getAdapterManager().getAdapter(adaptable, adapter);
        }
        return adapted;
    }

    private IFilterable adaptFilterable() {
        Object input = this.getTreeViewerInput();
        if (input != null) {
            return (IFilterable)this.getAdapter(input, IFilterable.class);
        }
        return null;
    }

    protected abstract Object getViewerInput();

    private IPropertyChangeProvider getPropertyChangeProvider() {
        Object input = this.getTreeViewerInput();
        if (input != null) {
            return (IPropertyChangeProvider)this.getAdapter(input, IPropertyChangeProvider.class);
        }
        return null;
    }

    Object getTreeViewerInput() {
        if (this.treeControl != null && this.treeControl.getViewer() != null) {
            return this.treeControl.getViewer().getInput();
        }
        return null;
    }

    protected TreeControl doCreateTreeControl() {
        return new TreeControl(this.getViewerId(), (IWorkbenchPart)this);
    }

    public final TreeControl getTreeControl() {
        return this.treeControl;
    }

    protected void updateUI() {
        Image image;
        this.toolbarMgr.update(true);
        IManagedForm managedForm = this.getManagedForm();
        Form form = managedForm.getForm().getForm();
        Object element = this.getTreeViewerInput();
        boolean filterEnabled = false;
        IFilterable filterDecorator = this.adaptFilterable();
        if (filterDecorator != null) {
            TreeViewer viewer = (TreeViewer)this.treeControl.getViewer();
            filterEnabled = TreeViewerUtil.isFiltering((TreeViewer)viewer, (TreePath)TreePath.EMPTY);
        }
        ILabelDecorator titleDecorator = this.getTitleBarDecorator();
        String text = this.getFormTitle();
        if (text != null) {
            if (titleDecorator != null) {
                text = titleDecorator.decorateText(text, element);
            }
            if (filterEnabled) {
                TreeViewer viewer = (TreeViewer)this.treeControl.getViewer();
                text = TreeViewerUtil.getDecoratedText((String)text, (TreeViewer)viewer, (TreePath)TreePath.EMPTY);
            }
        }
        if ((image = this.getFormImage()) != null) {
            if (titleDecorator != null) {
                image = titleDecorator.decorateImage(image, element);
            }
            if (filterEnabled) {
                TreeViewer viewer = (TreeViewer)this.treeControl.getViewer();
                image = TreeViewerUtil.getDecoratedImage((Image)image, (TreeViewer)viewer, (TreePath)TreePath.EMPTY);
            }
        }
        if (text != null) {
            try {
                form.setText(text);
            }
            catch (Exception exception) {}
        }
        if (image != null) {
            try {
                form.setImage(image);
            }
            catch (Exception exception) {}
        }
    }

    protected ILabelDecorator getTitleBarDecorator() {
        return null;
    }

    protected void propagateSelection() {
        ISelection selection = this.treeControl.getViewer().getSelection();
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        try {
            selectionProvider.setSelection(selection);
            if (selectionProvider instanceof MultiPageSelectionProvider) {
                SelectionChangedEvent changedEvent = new SelectionChangedEvent(selectionProvider, selection);
                ((MultiPageSelectionProvider)selectionProvider).firePostSelectionChanged(changedEvent);
            }
        }
        catch (SWTException sWTException) {}
    }

    protected String getDoubleClickCommandId() {
        return null;
    }

    protected abstract String getViewerId();

    public void doubleClick(final DoubleClickEvent event) {
        String commandId = this.getDoubleClickCommandId();
        Command cmd = null;
        if (commandId != null) {
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = cmd = service != null ? service.getCommand(commandId) : null;
        }
        if (cmd != null && cmd.isDefined() && cmd.isEnabled()) {
            final Command command = cmd;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void handleException(Throwable e) {
                }

                public void run() throws Exception {
                    IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    Assert.isNotNull((Object)handlerSvc);
                    ISelection selection = event.getSelection();
                    EvaluationContext ctx = new EvaluationContext(handlerSvc.getCurrentState(), (Object)selection);
                    ctx.addVariable("selection", (Object)selection);
                    ctx.addVariable("activeMenuSelection", (Object)selection);
                    ctx.setAllowPluginActivation(true);
                    ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                    Assert.isNotNull((Object)pCmd);
                    handlerSvc.executeCommandInContext(pCmd, null, (IEvaluationContext)ctx);
                }
            });
        } else {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            TreeViewer viewer = (TreeViewer)this.treeControl.getViewer();
            if (viewer.isExpandable(element)) {
                viewer.setExpandedState(element, !viewer.getExpandedState(element));
            }
        }
    }
}

