/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.listeners;

import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractWindowListener
implements IWindowListener {
    protected final IPartListener2 partListener = this.createPartListener();
    protected final IPerspectiveListener perspectiveListener = this.createPerspectiveListener();

    protected IPartListener2 createPartListener() {
        return null;
    }

    protected IPerspectiveListener createPerspectiveListener() {
        return null;
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        if (window != null) {
            if (window.getPartService() != null && this.partListener != null) {
                window.getPartService().removePartListener(this.partListener);
            }
            if (this.perspectiveListener != null) {
                window.removePerspectiveListener(this.perspectiveListener);
            }
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        if (window != null) {
            if (window.getPartService() != null && this.partListener != null) {
                IWorkbenchPartReference partRef;
                IPartService service = window.getPartService();
                service.removePartListener(this.partListener);
                service.addPartListener(this.partListener);
                IWorkbenchPage page = window.getActivePage();
                if (page != null && (partRef = page.getActivePartReference()) != null) {
                    this.partListener.partActivated(partRef);
                }
            }
            if (this.perspectiveListener != null) {
                window.addPerspectiveListener(this.perspectiveListener);
                if (window.getActivePage() != null) {
                    this.perspectiveListener.perspectiveActivated(window.getActivePage(), window.getActivePage().getPerspective());
                }
            }
        }
    }
}

