/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.editor.tabs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.internal.debug.ui.commands.MemoryMapWidget;
import org.eclipse.tcf.internal.debug.ui.launch.TCFMemoryMapTab;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.te.tcf.launch.ui.editor.AbstractTcfLaunchTabContainerEditorPage;
import org.eclipse.tcf.te.tcf.launch.ui.editor.tabs.TableUtils;

public class MemoryMapTab
extends TCFMemoryMapTab {
    private final AbstractTcfLaunchTabContainerEditorPage parentEditorPage;

    public MemoryMapTab(AbstractTcfLaunchTabContainerEditorPage parentEditorPage) {
        Assert.isNotNull((Object)((Object)parentEditorPage));
        this.parentEditorPage = parentEditorPage;
    }

    public final AbstractTcfLaunchTabContainerEditorPage getParentEditorPage() {
        return this.parentEditorPage;
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.performApply(AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.parentEditorPage.getPeerModel(this.parentEditorPage.getEditorInput())));
        this.parentEditorPage.checkLaunchConfigDirty();
    }

    protected MemoryMapWidget createWidget(Composite composite, TCFNode node) {
        return new MyMemoryMapWidget(composite, node);
    }

    protected static class MyMemoryMapWidget
    extends MemoryMapWidget {
        public MyMemoryMapWidget(Composite composite, TCFNode node) {
            super(composite, node);
        }

        protected void configureTableLayout(Table table, int widthHint, int heighHint, String[] columnNames) {
            Assert.isNotNull((Object)table);
            GridData data = new GridData(1808);
            data.widthHint = -1;
            data.heightHint = heighHint;
            table.setLayoutData((Object)data);
            int i = 0;
            while (i < columnNames.length) {
                TableColumn column = new TableColumn(table, 16384, i);
                column.setMoveable(false);
                column.setText(columnNames[i]);
                switch (i) {
                    case 0: {
                        column.setWidth(37);
                        column.setData("widthHint", (Object)37);
                        break;
                    }
                    case 1: 
                    case 2: {
                        column.setWidth(10);
                        column.setData("widthHint", (Object)10);
                        break;
                    }
                    case 4: {
                        column.setWidth(18);
                        column.setData("widthHint", (Object)18);
                        break;
                    }
                    default: {
                        column.setWidth(7);
                        column.setData("widthHint", (Object)7);
                    }
                }
                ++i;
            }
            TableUtils.adjustTableColumnWidth(table);
        }
    }
}

