/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.filetransfer;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.filetransfer.FileTransferItem;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.dialogs.FSFolderSelectionDialog;
import org.eclipse.tcf.te.tcf.filesystem.ui.dialogs.FSOpenFileDialog;
import org.eclipse.tcf.te.tcf.launch.core.filetransfer.FileTransferItemValidator;
import org.eclipse.tcf.te.tcf.launch.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;

public class AddEditFileTransferDialog
extends CustomTitleAreaDialog {
    private final IFileTransferItem item;
    final IModelNode launchContext;
    private BaseEditBrowseTextControl host;
    private BaseEditBrowseTextControl target;
    private BaseEditBrowseTextControl options;
    private Button toTarget;
    private Button toHost;
    private boolean modeNew = true;

    public AddEditFileTransferDialog(Shell shell, String contextHelpId, IFileTransferItem item, IModelNode launchContexts) {
        super(shell, contextHelpId);
        Assert.isNotNull((Object)item);
        this.item = item;
        this.launchContext = launchContexts;
        this.modeNew = item.isEmpty();
    }

    protected void createDialogAreaContent(Composite parent) {
        super.createDialogAreaContent(parent);
        this.setDialogTitle(this.modeNew ? Messages.AddEditFileTransferDialog_add_dialogTitle : Messages.AddEditFileTransferDialog_edit_dialogTitle);
        this.setTitle(this.modeNew ? Messages.AddEditFileTransferDialog_add_title : Messages.AddEditFileTransferDialog_edit_title);
        this.setDefaultMessage(this.modeNew ? Messages.AddEditFileTransferDialog_add_message : Messages.AddEditFileTransferDialog_edit_message, 1);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(panel, 0);
        this.toTarget = new Button(panel, 16);
        this.toTarget.setText(Messages.AddEditFileTransferDialog_toTarget_checkbox);
        this.toTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditFileTransferDialog.this.validate();
            }
        });
        new Label(panel, 0);
        this.toHost = new Button(panel, 16);
        this.toHost.setText(Messages.AddEditFileTransferDialog_toHost_checkbox);
        this.toHost.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditFileTransferDialog.this.validate();
            }
        });
        this.host = new BaseEditBrowseTextControl(null){

            protected void onButtonControlSelected() {
                int direction;
                int n = direction = AddEditFileTransferDialog.this.toTarget.getSelection() ? 1 : 2;
                if (direction == 1) {
                    FileDialog fileDialog = new FileDialog(AddEditFileTransferDialog.this.getShell(), 4096);
                    fileDialog.setFilterPath(this.getEditFieldControlText());
                    fileDialog.setFileName(this.getEditFieldControlText());
                    String file = fileDialog.open();
                    if (file != null) {
                        this.setEditFieldControlText(file);
                    }
                } else {
                    DirectoryDialog directoryDialog = new DirectoryDialog(AddEditFileTransferDialog.this.getShell(), 4096);
                    directoryDialog.setFilterPath(this.getEditFieldControlText());
                    String directory = directoryDialog.open();
                    if (directory != null) {
                        this.setEditFieldControlText(directory);
                    }
                }
            }

            public void modifyText(ModifyEvent e) {
                AddEditFileTransferDialog.this.validate();
            }
        };
        this.host.setEditFieldLabel(Messages.AddEditFileTransferDialog_host_label);
        this.host.setIsGroup(false);
        this.host.setHideBrowseButton(false);
        this.host.setAdjustBackgroundColor(true);
        this.host.setParentControlIsInnerPanel(true);
        this.host.setupPanel(panel);
        this.host.doCreateControlDecoration(this.host.getEditFieldControl());
        this.target = new BaseEditBrowseTextControl(null){

            protected void onButtonControlSelected() {
                String absPath;
                Object candidate;
                int direction = AddEditFileTransferDialog.this.toTarget.getSelection() ? 1 : 2;
                FSFolderSelectionDialog dialog = direction == 1 ? new FSFolderSelectionDialog(AddEditFileTransferDialog.this.getShell()) : new FSOpenFileDialog(AddEditFileTransferDialog.this.getShell());
                dialog.setInput((Object)this.getEditFieldControlText());
                dialog.setInput((Object)AddEditFileTransferDialog.this.launchContext);
                if (dialog.open() == 0 && (candidate = dialog.getFirstResult()) instanceof FSTreeNode && (absPath = ((FSTreeNode)candidate).getLocation()) != null) {
                    this.setEditFieldControlText(absPath);
                }
            }

            public void modifyText(ModifyEvent e) {
                AddEditFileTransferDialog.this.validate();
            }
        };
        this.target.setEditFieldLabel(Messages.AddEditFileTransferDialog_target_label);
        this.target.setIsGroup(false);
        this.target.setHideBrowseButton(false);
        this.target.setAdjustBackgroundColor(true);
        this.target.setParentControlIsInnerPanel(true);
        this.target.setupPanel(panel);
        this.target.doCreateControlDecoration(this.target.getEditFieldControl());
        new Label(panel, 0);
        new Label(panel, 0);
        this.options = new BaseEditBrowseTextControl(null){

            public void modifyText(ModifyEvent e) {
                AddEditFileTransferDialog.this.validate();
            }
        };
        this.options.setEditFieldLabel(Messages.AddEditFileTransferDialog_options_label);
        this.options.setIsGroup(false);
        this.options.setHideBrowseButton(true);
        this.options.setHasHistory(false);
        this.options.setAdjustBackgroundColor(true);
        this.options.setParentControlIsInnerPanel(true);
        this.options.setupPanel(panel);
        this.options.doCreateControlDecoration(this.target.getEditFieldControl());
        AddEditFileTransferDialog.applyDialogFont((Control)panel);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.restoreWidgetValues();
        this.validate();
        return control;
    }

    protected void validate() {
        FileTransferItem wc = new FileTransferItem();
        this.saveWidgetValues((IFileTransferItem)wc);
        Map invalid = FileTransferItemValidator.validate((IFileTransferItem)wc);
        boolean valid = true;
        if (invalid != null && invalid.containsKey("host")) {
            this.host.updateControlDecoration((String)invalid.get("host"), 3);
            if (valid) {
                this.setErrorMessage((String)invalid.get("host"));
            }
            valid = false;
        } else {
            this.host.updateControlDecoration(null, 0);
        }
        if (invalid != null && invalid.containsKey("target")) {
            this.target.updateControlDecoration((String)invalid.get("target"), 3);
            if (valid) {
                this.setErrorMessage((String)invalid.get("target"));
            }
            valid = false;
        } else {
            this.target.updateControlDecoration(null, 0);
        }
        if (valid) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(valid);
    }

    private void saveWidgetValues(IFileTransferItem wc) {
        wc.setProperty("host", (Object)new Path(this.host.getEditFieldControlText()).toPortableString());
        wc.setProperty("target", (Object)new Path(this.target.getEditFieldControlText()).toPortableString());
        wc.setProperty("options", (Object)this.options.getEditFieldControlText());
        int direction = this.toTarget.getSelection() ? 1 : 2;
        wc.setProperty("direction", direction);
    }

    protected void restoreWidgetValues() {
        String hostPath = this.item.getStringProperty("host");
        this.host.setEditFieldControlText(hostPath != null ? new Path(hostPath).toOSString() : "");
        String targetPath = this.item.getStringProperty("target");
        this.target.setEditFieldControlText(targetPath != null ? new Path(targetPath).toPortableString() : "");
        this.target.getButtonControl().setEnabled(this.launchContext != null);
        String optionsString = this.item.getStringProperty("options");
        this.options.setEditFieldControlText(optionsString != null ? optionsString : "");
        int direction = this.item.getIntProperty("direction");
        this.toTarget.setSelection(direction != 2);
        this.toHost.setSelection(direction == 2);
    }

    protected void saveWidgetValues() {
        this.saveWidgetValues(this.item);
    }
}

