/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.preferences;

import java.util.Set;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class BreakpointPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PLUGIN_ID = "org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage";
    BooleanFieldEditor setDefaultTriggerCheckbox;
    ComboFieldEditor defaultTriggerExpressoinCombo;

    public BreakpointPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.TCFBreakpointPreferencesDescription);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object button = event.getSource();
        if (button instanceof BooleanFieldEditor) {
            BooleanFieldEditor fe = (BooleanFieldEditor)button;
            this.defaultTriggerExpressoinCombo.setEnabled(fe.getBooleanValue(), this.getFieldEditorParent());
        }
    }

    public void createFieldEditors() {
        this.setDefaultTriggerCheckbox = new BooleanFieldEditor("org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.setDefaultTriggerScopeEnabled", Messages.TCFBreakpointPreferencesEnableDefaultTriggerScope, this.getFieldEditorParent());
        this.addField((FieldEditor)this.setDefaultTriggerCheckbox);
        String[] expressionList = this.getTriggerExpressions();
        this.defaultTriggerExpressoinCombo = new ComboFieldEditor("org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.defaultTriggerExpression", Messages.TCFBreakpointPreferencesTriggerScopeExpression, this.joinToArray2D(expressionList, expressionList), this.getFieldEditorParent());
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.defaultTriggerExpressoinCombo.setEnabled(store.getBoolean("org.eclipse.tcf.cdt.ui.preferences.BreakpointPreferencePage.setDefaultTriggerScopeEnabled"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.defaultTriggerExpressoinCombo);
        if (!this.checkTCFToggleBreakpointAdapter()) {
            this.setMessage(Messages.TCFBreakpointPrefrencesError, 2);
            this.setValid(false);
            this.setDefaultTriggerCheckbox.setEnabled(false, this.getFieldEditorParent());
            this.defaultTriggerExpressoinCombo.setEnabled(false, this.getFieldEditorParent());
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private String[] getTriggerExpressions() {
        IDialogSettings dialogSettings = this.getBreakpointScopeDialogSettings();
        String[] returnList = null;
        String[] expressionList = null;
        int index = 0;
        if (dialogSettings != null) {
            expressionList = dialogSettings.getArray(Messages.TCFThreadFilterQueryExpressionStore);
            if (expressionList != null) {
                index = 0;
                while (index < expressionList.length) {
                    String member = expressionList[index];
                    if (member == null || member.length() == 0) break;
                    ++index;
                }
            }
            returnList = new String[index + 1];
            returnList[0] = "";
            int loop = 0;
            while (loop < index) {
                returnList[loop + 1] = expressionList[loop];
                ++loop;
            }
        } else {
            returnList = new String[index];
        }
        return returnList;
    }

    private IDialogSettings getBreakpointScopeDialogSettings() {
        String component = "org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFThreadFilterEditor";
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(component);
        return section;
    }

    private String[][] joinToArray2D(String[] labels, String[] values) {
        String[][] array2d = new String[labels.length][];
        int i = 0;
        while (i < labels.length) {
            array2d[i] = new String[2];
            array2d[i][0] = labels[i];
            array2d[i][1] = values[i];
            ++i;
        }
        return array2d;
    }

    private boolean checkTCFToggleBreakpointAdapter() {
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part == null) {
            part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        }
        if (part != null) {
            ISelection selection = part.getSite().getSelectionProvider().getSelection();
            Set enablers = DebugUITools.getToggleBreakpointsTargetManager().getEnabledToggleBreakpointsTargetIDs((IWorkbenchPart)part, selection);
            if (enablers != null && !enablers.contains("org.eclipse.tcf.debug.toggleTCFBreakpoint")) {
                return true;
            }
            String preferred = DebugUITools.getToggleBreakpointsTargetManager().getPreferredToggleBreakpointsTargetID((IWorkbenchPart)part, selection);
            if (preferred != null && !preferred.equals("org.eclipse.tcf.debug.toggleTCFBreakpoint")) {
                return false;
            }
        }
        return true;
    }
}

