/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor.sections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.ui.controls.PeerAttributesTablePart;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class AttributesSection
extends AbstractSection {
    private PeerAttributesTablePart tablePart;
    IPeerModel od;
    final IPropertiesContainer odc = new PropertiesContainer();
    final IPropertiesContainer wc = new PropertiesContainer();
    private static final String[] BANNED_NAMES = new String[]{"ID", "AgentID", "ServiceManagerID", "ServerManagerID", "Name", "TransportName", "Host", "Port", "PipeName", "redirect.proxy", "Visible", "ClientID"};
    private static final String[] FILTERED_NAMES = new String[]{"ID", "AgentID", "ServiceManagerID", "ServerManagerID", "Name", "TransportName", "Host", "Port", "PipeName", "redirect.proxy", "Visible", "ClientID"};

    public AttributesSection(IManagedForm form, Composite parent) {
        super(form, parent, 128);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public void dispose() {
        super.dispose();
        if (this.tablePart != null) {
            this.tablePart.dispose();
            this.tablePart = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (PeerAttributesTablePart.class.equals((Object)adapter)) {
            return this.tablePart;
        }
        return super.getAdapter(adapter);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.AttributesSection_title);
        section.setDescription(Messages.AttributesSection_description);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 2, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        this.tablePart = new PeerAttributesTablePart(){

            @Override
            protected void onTableModified() {
                AttributesSection.this.dataChanged(null);
            }
        };
        this.tablePart.setMinSize(SWTControlUtil.convertWidthInCharsToPixels((Control)client, (int)20), SWTControlUtil.convertHeightInCharsToPixels((Control)client, (int)6));
        this.tablePart.setBannedNames(BANNED_NAMES);
        this.tablePart.createControl(client, 65540, 2, toolkit);
        this.updateEnablement();
        this.setIsUpdating(false);
    }

    public void setActive(boolean active) {
        if (active) {
            Object node;
            if (this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerModel) {
                this.setupData((IPeerModel)node);
            }
        } else {
            this.dataChanged(null);
        }
    }

    public void setupData(final IPeerModel node) {
        if (this.isDirty()) {
            return;
        }
        boolean updateWidgets = true;
        if (node == null && this.od == null || node != null && node.equals(this.od)) {
            updateWidgets = false;
        }
        PropertiesContainer previousOdc = new PropertiesContainer();
        previousOdc.setProperties(this.odc.getProperties());
        this.od = node;
        this.odc.clearProperties();
        this.wc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                Map properties = node.getPeer().getAttributes();
                for (Map.Entry entry : properties.entrySet()) {
                    AttributesSection.this.wc.setProperty((String)entry.getKey(), entry.getValue());
                    AttributesSection.this.odc.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
        });
        String[] stringArray = FILTERED_NAMES;
        int n = FILTERED_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String filteredName = stringArray[n2];
            this.wc.setProperty(filteredName, null);
            this.odc.setProperty(filteredName, null);
            ++n2;
        }
        for (String name : this.odc.getProperties().keySet()) {
            if (!name.endsWith(".silent") && !name.endsWith(".transient")) continue;
            this.wc.setProperty(name, null);
            this.odc.setProperty(name, null);
        }
        if (!previousOdc.getProperties().equals(this.odc.getProperties())) {
            updateWidgets = true;
        }
        if (updateWidgets) {
            this.setIsUpdating(true);
            HashMap<String, String> attributes = new HashMap<String, String>();
            Map properties = this.wc.getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                attributes.put((String)entry.getKey(), entry.getValue().toString());
            }
            if (this.tablePart != null) {
                this.tablePart.setAttributes(attributes);
            }
            this.setIsUpdating(false);
        }
        this.dataChanged(null);
        this.updateEnablement();
    }

    public void extractData(final IPeerModel node) {
        if (node == null) {
            return;
        }
        Map<String, String> attributes = this.tablePart.getAttributes();
        Map properties = this.wc.getProperties();
        final ArrayList<String> removed = new ArrayList<String>();
        for (String key : properties.keySet()) {
            if (attributes.containsKey(key)) {
                this.wc.setProperty(key, (Object)attributes.get(key));
                attributes.remove(key);
                continue;
            }
            this.wc.setProperty(key, null);
            removed.add(key);
        }
        if (!attributes.isEmpty()) {
            for (String key : attributes.keySet()) {
                this.wc.setProperty(key, (Object)attributes.get(key));
            }
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IPeer oldPeer = node.getPeer();
                HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                for (String key : AttributesSection.this.wc.getProperties().keySet()) {
                    String value = AttributesSection.this.wc.getStringProperty(key);
                    if (value != null) {
                        attributes.put(key, value);
                        continue;
                    }
                    attributes.remove(key);
                }
                for (String key : removed) {
                    attributes.remove(key);
                }
                PeerRedirector newPeer = oldPeer instanceof PeerRedirector ? new PeerRedirector(((PeerRedirector)oldPeer).getParent(), attributes) : new Peer(attributes);
                boolean changed = node.setChangeEventsEnabled(false);
                node.setProperty("instance", (Object)newPeer);
                if (changed) {
                    node.setChangeEventsEnabled(true);
                }
            }
        });
    }

    public void commit(boolean onSave) {
        boolean needsSaving = this.isDirty();
        super.commit(onSave);
        if (!onSave || !needsSaving) {
            return;
        }
        this.extractData(this.od);
    }

    public void dataChanged(TypedEvent e) {
        if (this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        if (this.tablePart != null) {
            Map<String, String> attributes = this.tablePart.getAttributes();
            Map properties = this.odc.getProperties();
            if (attributes.size() != properties.size()) {
                isDirty = true;
            } else {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    if (properties.containsKey(entry.getKey()) && properties.get(entry.getKey()).equals(entry.getValue())) continue;
                    isDirty = true;
                    break;
                }
            }
        }
        this.markDirty(isDirty);
    }

    protected void updateEnablement() {
        final Object input = this.getManagedForm().getInput();
        final AtomicBoolean isStatic = new AtomicBoolean();
        final AtomicBoolean isRemote = new AtomicBoolean();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (input instanceof IPeerModel) {
                    isStatic.set(((IPeerModel)input).isStatic());
                    isRemote.set(((IPeerModel)input).isRemote());
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        if (this.tablePart != null) {
            this.tablePart.setReadOnly(!isStatic.get() || isRemote.get());
        }
    }
}

