/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.search;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.internal.search.ProcessBaseSearchable;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;

public class ProcessUserSearchable
extends ProcessBaseSearchable {
    private static final int OPTION_NOT_REMEMBER = 0;
    private static final int OPTION_BY_ME = 1;
    private static final int OPTION_SPECIFIED = 2;
    private int choice;
    private String user;
    private Button fBtnUserNotRem;
    private Button fBtnUserMe;
    private Button fBtnUserSpecified;
    private BaseEditBrowseTextControl txtUser;

    public void createAdvancedPart(Composite parent) {
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessUserSearchable.this.optionChecked(e);
            }
        };
        Composite modifiedComp = this.createSection(parent, Messages.ProcessUserSearchable_WhoStarted);
        modifiedComp.setLayout((Layout)new GridLayout(2, false));
        this.fBtnUserNotRem = new Button(modifiedComp, 16);
        this.fBtnUserNotRem.setText(Messages.ProcessUserSearchable_DontRemember);
        this.fBtnUserNotRem.setSelection(true);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.fBtnUserNotRem.setLayoutData((Object)data);
        this.fBtnUserNotRem.addSelectionListener((SelectionListener)l);
        this.fBtnUserMe = new Button(modifiedComp, 16);
        this.fBtnUserMe.setText(Messages.ProcessUserSearchable_Myself);
        data = new GridData();
        data.horizontalSpan = 2;
        this.fBtnUserMe.setLayoutData((Object)data);
        this.fBtnUserMe.addSelectionListener((SelectionListener)l);
        this.fBtnUserSpecified = new Button(modifiedComp, 16);
        this.fBtnUserSpecified.setText(Messages.ProcessUserSearchable_SpecifyUser);
        data = new GridData();
        this.fBtnUserSpecified.setLayoutData((Object)data);
        this.fBtnUserSpecified.addSelectionListener((SelectionListener)l);
        Composite cmpUser = new Composite(modifiedComp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        cmpUser.setLayout((Layout)layout);
        data = new GridData();
        cmpUser.setLayoutData((Object)data);
        this.txtUser = new BaseEditBrowseTextControl(null);
        this.txtUser.setIsGroup(false);
        this.txtUser.setHasHistory(false);
        this.txtUser.setHideBrowseButton(true);
        this.txtUser.setParentControlIsInnerPanel(true);
        this.txtUser.setupPanel(cmpUser);
        this.txtUser.setEnabled(false);
        Text text = (Text)this.txtUser.getEditFieldControl();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessUserSearchable.this.userModified();
            }
        });
    }

    protected void userModified() {
        this.fireOptionChanged();
    }

    public boolean isInputValid() {
        if (this.choice == 2 && this.txtUser != null) {
            boolean vFrom = this.txtUser.isValid();
            if (vFrom) {
                String fromText;
                this.user = fromText = this.txtUser.getEditFieldControlText().trim();
            }
            return vFrom;
        }
        return true;
    }

    protected void optionChecked(SelectionEvent e) {
        Object src = e.getSource();
        boolean specified = false;
        if (src == this.fBtnUserNotRem) {
            this.choice = 0;
        } else if (src == this.fBtnUserMe) {
            this.choice = 1;
        } else if (src == this.fBtnUserSpecified) {
            this.choice = 2;
            specified = true;
        }
        if (this.txtUser != null) {
            this.txtUser.setEnabled(specified);
        }
        this.fireOptionChanged();
    }

    public boolean match(Object element) {
        if (element instanceof IProcessContextNode) {
            final IProcessContextNode node = (IProcessContextNode)element;
            final AtomicReference username = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    username.set(node.getSysMonitorContext().getUserName());
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            switch (this.choice) {
                case 0: {
                    return true;
                }
                case 1: {
                    return System.getProperty("user.name").equals(username.get());
                }
                case 2: {
                    return this.user == null ? username.get() == null : this.user.equals(username.get());
                }
            }
        }
        return false;
    }
}

