/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.actions;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.util.TCFDataCache;

public abstract class TCFActionStepOver
extends TCFAction
implements IRunControl.RunControlListener {
    private boolean step_line;
    private boolean step_back;
    private final IRunControl rc;
    private final IBreakpoints bps;
    private IRunControl.RunControlContext ctx;
    private TCFDataCache<TCFContextState> state;
    private TCFDataCache<TCFSourceRef> line_info;
    private TCFSourceRef source_ref;
    private BigInteger pc0;
    private BigInteger pc1;
    private int step_cnt;
    private Map<String, Object> bp;
    private boolean second_step_back;
    private boolean final_step;
    protected boolean exited;

    public TCFActionStepOver(TCFLaunch launch, IRunControl.RunControlContext ctx, boolean step_line, boolean step_back) {
        super(launch, ctx.getID());
        this.rc = this.launch.getService(IRunControl.class);
        this.bps = this.launch.getService(IBreakpoints.class);
        this.ctx = ctx;
        this.step_line = step_line;
        this.step_back = step_back;
    }

    protected abstract TCFDataCache<TCFContextState> getContextState();

    protected abstract TCFDataCache<TCFSourceRef> getLineInfo();

    protected abstract TCFDataCache<?> getStackTrace();

    protected abstract TCFDataCache<IStackTrace.StackTraceContext> getStackFrame();

    protected abstract int getStackFrameIndex();

    @Override
    public void run() {
        if (this.exited) {
            return;
        }
        try {
            this.runAction();
        }
        catch (Throwable x) {
            this.exit(x);
        }
    }

    private void setSourceRef(TCFSourceRef ref) {
        ILineNumbers.CodeArea area = ref.area;
        if (area != null) {
            this.pc0 = JSON.toBigInteger((Number)area.start_address);
            this.pc1 = JSON.toBigInteger((Number)area.end_address);
        } else {
            this.pc0 = null;
            this.pc1 = null;
        }
        this.source_ref = ref;
    }

    private void runAction() {
        int fno;
        if (this.aborted) {
            this.exit(null);
            return;
        }
        if (this.state == null) {
            this.rc.addListener((IRunControl.RunControlListener)this);
            this.state = this.getContextState();
            if (this.state == null) {
                this.exit(new Exception("Invalid context ID"));
                return;
            }
        }
        if (!this.state.validate((Runnable)this)) {
            return;
        }
        if (this.state.getData() == null || !((TCFContextState)this.state.getData()).is_suspended) {
            Throwable error = this.state.getError();
            if (error == null) {
                error = new Exception("Context is not suspended");
            }
            this.exit(error);
            return;
        }
        if (this.step_cnt > 0) {
            boolean ok = false;
            TCFContextState state_data = (TCFContextState)this.state.getData();
            if ("Step".equals(state_data.suspend_reason) || this.isMyBreakpoint(state_data)) {
                ok = true;
            } else if ("Breakpoint".equals(state_data.suspend_reason) && this.pc0 != null && this.pc1 != null) {
                BigInteger x = new BigInteger(state_data.suspend_pc);
                boolean bl = ok = x.compareTo(this.pc0) >= 0 && x.compareTo(this.pc1) < 0;
            }
            if (!ok) {
                this.exit(null, state_data.suspend_reason);
                return;
            }
        }
        int mode = 0;
        if (!this.step_line) {
            mode = this.step_back ? 7 : 1;
        } else {
            int n = mode = this.step_back ? 9 : 3;
        }
        if (this.ctx.canResume(mode)) {
            if (this.step_cnt > 0) {
                this.exit(null);
                return;
            }
            this.ctx.resume(mode, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
            ++this.step_cnt;
            return;
        }
        TCFDataCache<?> stack_trace = this.getStackTrace();
        if (!stack_trace.validate((Runnable)this)) {
            return;
        }
        if (this.step_line && this.source_ref == null) {
            this.line_info = this.getLineInfo();
            if (!this.line_info.validate((Runnable)this)) {
                return;
            }
            TCFSourceRef ref = (TCFSourceRef)this.line_info.getData();
            if (ref == null) {
                this.step_line = false;
                Protocol.invokeLater((Runnable)this);
                return;
            }
            if (ref.error != null) {
                this.exit(ref.error);
                return;
            }
            this.setSourceRef(ref);
        }
        if ((fno = this.getStackFrameIndex()) > 0) {
            int n = mode = this.step_back ? 11 : 5;
            if (this.ctx.canResume(mode)) {
                this.ctx.resume(mode, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TCFActionStepOver.this.exit(error);
                        }
                    }
                });
                return;
            }
            int n2 = mode = this.step_back ? 6 : 0;
            if (this.bps != null && this.ctx.canResume(mode)) {
                if (this.bp == null) {
                    TCFDataCache<IStackTrace.StackTraceContext> frame = this.getStackFrame();
                    if (!frame.validate((Runnable)this)) {
                        return;
                    }
                    Number addr = ((IStackTrace.StackTraceContext)frame.getData()).getInstructionAddress();
                    if (addr == null) {
                        this.exit(new Exception("Unknown PC address"));
                        return;
                    }
                    if (this.step_back) {
                        BigInteger n3 = JSON.toBigInteger((Number)addr);
                        addr = n3.subtract(BigInteger.valueOf(1L));
                    }
                    String id = "Step." + this.ctx.getID();
                    this.bp = new HashMap<String, Object>();
                    this.bp.put("ID", id);
                    this.bp.put("Location", addr.toString());
                    this.bp.put("Condition", "$thread==\"" + this.ctx.getID() + "\"");
                    this.bp.put("Enabled", Boolean.TRUE);
                    this.bps.add(this.bp, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                TCFActionStepOver.this.exit(error);
                            }
                        }
                    });
                }
                this.ctx.resume(mode, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TCFActionStepOver.this.exit(error);
                        }
                    }
                });
                ++this.step_cnt;
                return;
            }
            this.exit(new Exception("Step over is not supported"));
            return;
        }
        if (this.bp != null) {
            this.bps.remove(new String[]{(String)this.bp.get("ID")}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
            this.bp = null;
        }
        BigInteger pc = new BigInteger(((TCFContextState)this.state.getData()).suspend_pc);
        if (this.step_cnt > 0) {
            if (this.pc0 == null && this.pc1 == null || ((TCFContextState)this.state.getData()).suspend_pc == null) {
                this.exit(null);
                return;
            }
            assert (this.step_line);
            if (pc.compareTo(this.pc0) < 0 || pc.compareTo(this.pc1) >= 0) {
                if (!this.line_info.validate((Runnable)this)) {
                    return;
                }
                TCFSourceRef ref = (TCFSourceRef)this.line_info.getData();
                if (ref == null || ref.area == null) {
                    if (fno < 0 && (stack_trace.getError() == null || this.step_cnt >= 10)) {
                        this.exit(stack_trace.getError());
                        return;
                    }
                } else if (this.isSameLine(this.source_ref.area, ref.area)) {
                    this.setSourceRef(ref);
                } else if (this.step_back && !this.second_step_back) {
                    this.second_step_back = true;
                    this.setSourceRef(ref);
                } else if (this.step_back && !this.final_step) {
                    this.final_step = true;
                    this.step_back = false;
                    this.setSourceRef(ref);
                } else {
                    this.exit(null);
                    return;
                }
            }
        }
        ++this.step_cnt;
        int n = mode = this.step_back ? 7 : 1;
        if (this.ctx.canResume(mode)) {
            this.ctx.resume(mode, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
            return;
        }
        int n4 = mode = this.step_back ? 15 : 13;
        if (this.ctx.canResume(mode) && pc != null && this.pc0 != null && this.pc1 != null && pc.compareTo(this.pc0) >= 0 && pc.compareTo(this.pc1) < 0) {
            HashMap<String, BigInteger> args = new HashMap<String, BigInteger>();
            args.put("RangeStart", this.pc0);
            args.put("RangeEnd", this.pc1);
            this.ctx.resume(mode, 1, args, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
            return;
        }
        int n5 = mode = this.step_back ? 8 : 2;
        if (this.ctx.canResume(mode)) {
            this.ctx.resume(mode, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
            return;
        }
        this.exit(new Exception("Step over is not supported"));
    }

    protected void exit(Throwable error) {
        this.exit(error, "Step Over");
    }

    protected void exit(Throwable error, String reason) {
        if (this.exited) {
            return;
        }
        if (this.bp != null) {
            this.bps.remove(new String[]{(String)this.bp.get("ID")}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                }
            });
        }
        this.rc.removeListener((IRunControl.RunControlListener)this);
        this.exited = true;
        if (error == null) {
            this.setActionResult(this.getContextID(), reason);
        } else {
            this.launch.removeContextActions(this.getContextID());
        }
        this.done();
    }

    public void containerResumed(String[] context_ids) {
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.equals(context)) {
                this.contextSuspended(id, null, null, null);
            }
            ++n2;
        }
        this.contextSuspended(context, pc, reason, params);
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext c = runControlContextArray[n2];
            if (c.getID().equals(this.ctx.getID())) {
                this.ctx = c;
            }
            ++n2;
        }
    }

    public void contextException(String context, String msg) {
        if (context.equals(this.ctx.getID())) {
            this.exit(new Exception(msg));
        }
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String context = stringArray[n2];
            if (context.equals(this.ctx.getID())) {
                this.exit(null);
            }
            ++n2;
        }
    }

    public void contextResumed(String context) {
    }

    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
        if (!context.equals(this.ctx.getID())) {
            return;
        }
        Protocol.invokeLater((Runnable)this);
    }

    private boolean isSameLine(ILineNumbers.CodeArea x, ILineNumbers.CodeArea y) {
        if (x == null || y == null) {
            return false;
        }
        if (x.start_line != y.start_line) {
            return false;
        }
        if (!(x.directory == y.directory || x.directory != null && x.directory.equals(y.directory))) {
            return false;
        }
        return x.file == y.file || x.file != null && x.file.equals(y.file);
    }

    private boolean isMyBreakpoint(TCFContextState state_data) {
        Collection c;
        Object ids;
        if (this.bp == null) {
            return false;
        }
        if (!"Breakpoint".equals(state_data.suspend_reason)) {
            return false;
        }
        if (state_data.suspend_params != null && (ids = state_data.suspend_params.get("BPs")) != null && (c = (Collection)ids).contains(this.bp.get("ID"))) {
            return true;
        }
        if (state_data.suspend_pc == null) {
            return false;
        }
        BigInteger x = new BigInteger(state_data.suspend_pc);
        BigInteger y = new BigInteger((String)this.bp.get("Location"));
        return x.equals(y);
    }
}

