/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.listeners;

import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.internal.utils.LogUtils;
import org.eclipse.tcf.te.tcf.core.listeners.interfaces.IChannelOpenListener;
import org.eclipse.tcf.te.tcf.core.nls.Messages;

public class ChannelListener
implements IChannel.IChannelListener {
    private final IChannel channel;

    public ChannelListener(IChannel channel) {
        Assert.isNotNull((Object)channel);
        this.channel = channel;
    }

    protected final IChannel getChannel() {
        return this.channel;
    }

    public void congestionLevel(int level) {
    }

    public void onChannelClosed(Throwable error) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        this.detachListeners(this.getChannel());
        String cause = "";
        if (error != null) {
            cause = NLS.bind((String)Messages.InternalChannelListener_onChannelClosed_cause, (Object)error.getLocalizedMessage());
        }
        LogUtils.logMessageForChannel(this.getChannel(), NLS.bind((String)Messages.InternalChannelListener_onChannelClosed_message, (Object)cause), "trace/channels", this);
        Tcf.fireChannelStateChangeListeners(this.getChannel(), 2);
    }

    protected void detachListeners(IChannel channel) {
        Assert.isNotNull((Object)channel);
        channel.removeChannelListener((IChannel.IChannelListener)this);
        IChannelOpenListener openListener = (IChannelOpenListener)Tcf.getAdapter(IChannelOpenListener.class);
        if (openListener != null) {
            openListener.setChannelListener(channel, null);
        }
    }

    public void onChannelOpened() {
    }
}

