/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.IModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelUpdateService
extends AbstractLocatorModelService
implements ILocatorModelUpdateService {
    public LocatorModelUpdateService(ILocatorModel parentModel) {
        super(parentModel);
    }

    @Override
    public void add(final IPeerModel peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Map peers = (Map)this.getLocatorModel().getAdapter(Map.class);
        Assert.isNotNull((Object)peers);
        peers.put(peer.getPeerId(), peer);
        final IModelListener[] listeners = this.getLocatorModel().getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IModelListener[] iModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelListener listener = iModelListenerArray[n2];
                        listener.locatorModelChanged(LocatorModelUpdateService.this.getLocatorModel(), peer, true);
                        ++n2;
                    }
                }
            });
        }
    }

    @Override
    public void remove(final IPeerModel peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Map peers = (Map)this.getLocatorModel().getAdapter(Map.class);
        Assert.isNotNull((Object)peers);
        peers.remove(peer.getPeerId());
        this.getLocatorModel().setChildren(peer.getPeerId(), null);
        final IModelListener[] listeners = this.getLocatorModel().getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IModelListener[] iModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelListener listener = iModelListenerArray[n2];
                        listener.locatorModelChanged(LocatorModelUpdateService.this.getLocatorModel(), peer, false);
                        ++n2;
                    }
                }
            });
        }
    }

    @Override
    public void updatePeerServices(IPeerModel peerNode, Collection<String> localServices, Collection<String> remoteServices) {
        Assert.isNotNull((Object)peerNode);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        peerNode.setProperty("services.local", localServices != null ? this.makeString(localServices) : null);
        peerNode.setProperty("services.remote", remoteServices != null ? this.makeString(remoteServices) : null);
    }

    protected String makeString(Collection<String> collection) {
        Assert.isNotNull(collection);
        String buffer = collection.toString();
        buffer = buffer.replaceAll("\\[", "").replaceAll("\\]", "");
        return buffer.trim();
    }

    @Override
    public void addChild(IPeerModel child) {
        Assert.isNotNull((Object)child);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeerModel parent = (IPeerModel)child.getParent(IPeerModel.class);
        if (parent == null) {
            return;
        }
        String parentPeerId = parent.getPeerId();
        Assert.isNotNull((Object)parentPeerId);
        ArrayList<IPeerModel> children = new ArrayList<IPeerModel>(this.getLocatorModel().getChildren(parentPeerId));
        if (!children.contains(child)) {
            children.add(child);
            this.getLocatorModel().setChildren(parentPeerId, children);
        }
        parent.fireChangeEvent("changed", null, children);
    }

    @Override
    public void removeChild(IPeerModel child) {
        Assert.isNotNull((Object)child);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeerModel parent = (IPeerModel)child.getParent(IPeerModel.class);
        if (parent == null) {
            return;
        }
        String parentPeerId = parent.getPeerId();
        Assert.isNotNull((Object)parentPeerId);
        ArrayList<IPeerModel> children = new ArrayList<IPeerModel>(this.getLocatorModel().getChildren(parentPeerId));
        if (children.contains(child)) {
            children.remove(child);
            this.getLocatorModel().setChildren(parentPeerId, children);
        }
        parent.fireChangeEvent("changed", null, children);
    }

    @Override
    public void mergeUserDefinedAttributes(IPeerModel node, IPeer peer, boolean force) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeer dst = node.getPeer();
        if (!(dst instanceof PeerRedirector) && !(dst instanceof Peer)) {
            return;
        }
        if (dst == peer) {
            return;
        }
        if (!force) {
            Assert.isTrue((dst.getID().equals(peer.getID()) || dst.getAttributes().get("remote.id.transient") != null && ((String)dst.getAttributes().get("remote.id.transient")).equals(peer.getID()) ? 1 : 0) != 0);
        }
        HashMap<String, String> dstAttrs = new HashMap<String, String>(dst.getAttributes());
        HashMap<String, String> srcAttrs = new HashMap<String, String>(peer.getAttributes());
        boolean removeURI = srcAttrs.containsKey("URI.transient.remove");
        boolean bl = removeURI = removeURI ? Boolean.parseBoolean((String)srcAttrs.remove("URI.transient.remove")) : false;
        if (removeURI) {
            dstAttrs.remove("URI.transient");
        }
        String peerClassSimpleName = peer.getClass().getSimpleName();
        if (peer.getAttributes().containsKey("remote.transient")) {
            peerClassSimpleName = "RemotePeer";
        }
        if ("RemotePeer".equals(peerClassSimpleName) && !"RemotePeer".equals(dst.getClass().getSimpleName())) {
            srcAttrs.remove("ID");
            srcAttrs.remove("Name");
            String merged = (String)dstAttrs.get("remote.merged.transient");
            for (String key : dstAttrs.keySet()) {
                if (merged != null && merged.contains(key)) continue;
                srcAttrs.remove(key);
            }
        }
        if ("RemotePeer".equals(peerClassSimpleName) && !"RemotePeer".equals(dst.getClass().getSimpleName())) {
            srcAttrs.put("remote.transient", Boolean.TRUE.toString());
            srcAttrs.put("remote.id.transient", peer.getID());
            srcAttrs.put("remote.merged.transient", srcAttrs.keySet().toString());
        }
        if (!srcAttrs.isEmpty()) {
            dstAttrs.putAll(srcAttrs);
        }
        if (force && !dst.getID().equals(dstAttrs.get("ID"))) {
            dstAttrs.put("ID", dst.getID());
        }
        if (dst instanceof PeerRedirector) {
            ((PeerRedirector)dst).updateAttributes(dstAttrs);
        } else if (dst instanceof Peer) {
            ((Peer)dst).updateAttributes(dstAttrs);
        }
    }
}

