/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.collect.Lists;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescriptionProvider;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializationExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SerializableResourceDescription
extends AbstractResourceDescription
implements Externalizable {
    private List<SerializableEObjectDescription> descriptions = Collections.emptyList();
    private List<SerializableReferenceDescription> references = Collections.emptyList();
    private List<QualifiedName> importedNames = Collections.emptyList();
    private URI uri;

    public void updateResourceURI(URI uri) {
        for (SerializableReferenceDescription ref : this.references) {
            ref.updateResourceURI(uri, this.uri);
        }
        for (SerializableEObjectDescription desc : this.descriptions) {
            desc.updateResourceURI(uri);
        }
        this.uri = uri;
    }

    @Override
    protected List<IEObjectDescription> computeExportedObjects() {
        return this.descriptions;
    }

    @Override
    public Iterable<QualifiedName> getImportedNames() {
        return this.importedNames;
    }

    @Override
    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return this.references;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setURI(SerializationExtensions.readURI(in));
        int descriptionsSize = in.readInt();
        this.descriptions = new ArrayList<SerializableEObjectDescription>(descriptionsSize);
        for (int i = 0; i < descriptionsSize; ++i) {
            this.descriptions.add((SerializableEObjectDescription)SerializationExtensions.readCastedObject(in));
        }
        int referencesSize = in.readInt();
        this.references = new ArrayList<SerializableReferenceDescription>(referencesSize);
        for (int i = 0; i < referencesSize; ++i) {
            this.references.add((SerializableReferenceDescription)SerializationExtensions.readCastedObject(in));
        }
        int importedNamesSize = in.readInt();
        this.importedNames = new ArrayList<QualifiedName>(importedNamesSize);
        for (int i = 0; i < importedNamesSize; ++i) {
            this.importedNames.add(SerializationExtensions.readQualifiedName(in));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationExtensions.writeURI(out, this.uri);
        out.writeInt(this.descriptions.size());
        for (SerializableEObjectDescription desc : this.descriptions) {
            out.writeObject(desc);
        }
        out.writeInt(this.references.size());
        for (SerializableReferenceDescription ref : this.references) {
            out.writeObject(ref);
        }
        out.writeInt(this.importedNames.size());
        for (QualifiedName name : this.importedNames) {
            SerializationExtensions.writeQualifiedName(out, name);
        }
    }

    public List<SerializableEObjectDescription> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<SerializableEObjectDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public List<SerializableReferenceDescription> getReferences() {
        return this.references;
    }

    public void setReferences(List<SerializableReferenceDescription> references) {
        this.references = references;
    }

    public void setImportedNames(List<QualifiedName> importedNames) {
        this.importedNames = importedNames;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public static SerializableResourceDescription createCopy(IResourceDescription desc) {
        SerializableResourceDescription description = new SerializableResourceDescription();
        description.setURI(desc.getURI());
        description.descriptions = Lists.newArrayList((Iterable)IterableExtensions.map(desc.getExportedObjects(), SerializableResourceDescription::createCopy));
        description.references = Lists.newArrayList((Iterable)IterableExtensions.map(desc.getReferenceDescriptions(), SerializableResourceDescription::createCopy));
        description.importedNames = Lists.newArrayList(desc.getImportedNames());
        return description;
    }

    private static SerializableEObjectDescription createCopy(IEObjectDescription desc) {
        if (desc instanceof SerializableEObjectDescriptionProvider) {
            return ((SerializableEObjectDescriptionProvider)((Object)desc)).toSerializableEObjectDescription();
        }
        SerializableEObjectDescription result = new SerializableEObjectDescription();
        result.setEClass(desc.getEClass());
        result.setEObjectURI(desc.getEObjectURI());
        result.qualifiedName = desc.getQualifiedName();
        result.userData = new HashMap(desc.getUserDataKeys().length);
        for (String key : desc.getUserDataKeys()) {
            result.userData.put(key, desc.getUserData(key));
        }
        return result;
    }

    private static SerializableReferenceDescription createCopy(IReferenceDescription desc) {
        SerializableReferenceDescription result = new SerializableReferenceDescription();
        result.setSourceEObjectUri(desc.getSourceEObjectUri());
        result.setTargetEObjectUri(desc.getTargetEObjectUri());
        result.setEReference(desc.getEReference());
        result.setIndexInList(desc.getIndexInList());
        result.setContainerEObjectURI(desc.getContainerEObjectURI());
        return result;
    }
}

