/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractListSelectionWizardPage
extends WizardPage {
    private CheckboxTableViewer listViewer;
    private final SelectionMode mode;

    protected AbstractListSelectionWizardPage(String pageName, Wizard wizard, SelectionMode mode) {
        super(pageName);
        this.mode = mode;
        this.setWizard((IWizard)wizard);
    }

    protected List<String> getSelection() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.hasSelection()) {
            Object[] objectArray = this.listViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object sel = objectArray[n2];
                result.add(sel.toString());
                ++n2;
            }
        }
        return result;
    }

    protected boolean hasSelection() {
        return this.listViewer != null && this.listViewer.getCheckedElements() != null && this.listViewer.getCheckedElements().length > 0;
    }

    protected abstract Collection<String> getInput();

    protected abstract String getPageTitle();

    protected abstract String getPageMessage();

    public void createControl(Composite parent) {
        this.setTitle(this.getPageTitle());
        this.setMessage(this.getPageMessage());
        Collection<String> input = this.getInput();
        ArrayList initialSelection = new ArrayList();
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        if (input != null && input.size() > 0) {
            this.listViewer = CheckboxTableViewer.newCheckList((Composite)contents, (int)2048);
            this.listViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
            this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CheckboxTableViewer source = (CheckboxTableViewer)event.getSource();
                    AbstractListSelectionWizardPage.this.updatePageCompletionStatus(source);
                }
            });
            this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.listViewer.setInput(input);
            this.listViewer.setCheckedElements(initialSelection.toArray());
            this.listViewer.setSelection(this.listViewer.getSelection(), true);
            this.updatePageCompletionStatus(this.listViewer);
            this.addSelectionButtons(contents);
        } else {
            Label l = new Label(contents, 0);
            l.setText("There are no attributes to filter on.");
        }
        this.setControl((Control)contents);
    }

    private void updatePageCompletionStatus(CheckboxTableViewer source) {
        if (this.mode == SelectionMode.EXACTLY_ONE) {
            this.setPageComplete(source.getCheckedElements().length == 1);
        } else if (this.mode == SelectionMode.AT_LEAST_ONE) {
            this.setPageComplete(source.getCheckedElements().length >= 1);
        } else if (this.mode == SelectionMode.ALWAYS) {
            this.setPageComplete(true);
        }
    }

    protected void updateInputList() {
        this.listViewer.setInput(this.getInput());
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(1, 128, true, false));
        Button selectButton = new Button(buttonComposite, 0);
        selectButton.setText("Select All");
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractListSelectionWizardPage.this.listViewer.setAllChecked(true);
                AbstractListSelectionWizardPage.this.listViewer.setSelection(AbstractListSelectionWizardPage.this.listViewer.getSelection(), true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = new Button(buttonComposite, 0);
        deselectButton.setText("Deselect All");
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractListSelectionWizardPage.this.listViewer.setAllChecked(false);
                AbstractListSelectionWizardPage.this.listViewer.setSelection(AbstractListSelectionWizardPage.this.listViewer.getSelection(), true);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    public static enum SelectionMode {
        EXACTLY_ONE,
        AT_LEAST_ONE,
        ALWAYS;

    }
}

