/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.HostThreadIdentifier;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.old.RocmCallStackStateProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

public abstract class AbstractGpuEventHandler {
    private Set<Integer> fHostIdDefined = new HashSet<Integer>();
    protected final RocmCallStackStateProvider fStateProvider;

    protected AbstractGpuEventHandler(RocmCallStackStateProvider stateProvider) {
        this.fStateProvider = stateProvider;
    }

    public abstract void handleEvent(ITmfStateSystemBuilder var1, ITmfEvent var2) throws AttributeNotFoundException;

    public void addHostIdToStateSystemIfNotDefined(ITmfStateSystemBuilder ssb, ITmfTrace trace, HostThreadIdentifier hostThreadIdentifier, int quark) {
        if (this.fHostIdDefined.contains(hostThreadIdentifier.hashCode())) {
            return;
        }
        int parentQuark = ssb.getParentAttributeQuark(quark);
        this.fHostIdDefined.add(hostThreadIdentifier.hashCode());
        ssb.modifyAttribute(trace.getStartTime().toNanos(), (Object)hostThreadIdentifier.hashCode(), parentQuark);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pushParallelActivityOnCallStack(ITmfStateSystemBuilder ssb, int callStackQuark, String eventName, Long ts, Long endTs) {
        try {
            int depth = 1;
            int subQuark = ssb.getQuarkRelativeAndAdd(callStackQuark, new String[]{String.valueOf(depth)});
            if (ts < ssb.getStartTime()) {
                return;
            }
            while (true) {
                if (ssb.querySingleState(ts.longValue(), subQuark).getValue() == null) {
                    ssb.modifyAttribute(ts.longValue(), (Object)depth, callStackQuark);
                    this.fStateProvider.addFutureEvent(endTs, null, callStackQuark);
                    ssb.modifyAttribute(ts.longValue(), (Object)eventName, subQuark);
                    this.fStateProvider.addFutureEvent(endTs, null, subQuark);
                    return;
                }
                subQuark = ssb.getQuarkRelativeAndAdd(callStackQuark, new String[]{String.valueOf(++depth)});
            }
        }
        catch (StateSystemDisposedException e) {
            Activator.getInstance().logError(e.getMessage());
        }
    }

    public static Long getEndTime(ITmfEvent event) {
        Long timestampEnd = (Long)event.getContent().getFieldValue(Long.class, new String[]{"end"});
        if (timestampEnd != null) {
            return ((CtfTmfTrace)event.getTrace()).timestampCyclesToNanos(timestampEnd.longValue());
        }
        return 0L;
    }
}

