/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old;

import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.AbstractGpuEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.old.RocmCallStackStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class RoctxEventHandler
extends AbstractGpuEventHandler {
    public RoctxEventHandler(RocmCallStackStateProvider stateProvider) {
        super(stateProvider);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) throws AttributeNotFoundException {
        int systemQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Processes", "System"});
        Long threadId = (Long)event.getContent().getFieldValue(Long.class, new String[]{"tid"});
        if (threadId == null) {
            threadId = 0L;
        }
        int threadQuark = ssb.getQuarkRelativeAndAdd(systemQuark, new String[]{"Thread " + threadId.toString()});
        int apiQuark = ssb.getQuarkRelativeAndAdd(threadQuark, new String[]{"RocTX"});
        int callStackQuark = ssb.getQuarkRelativeAndAdd(apiQuark, new String[]{"CallStack"});
        Long timestamp = event.getTimestamp().getValue();
        String message = (String)event.getContent().getFieldValue(String.class, new String[]{"message"});
        if (message == null || message.equals("")) {
            ssb.popAttribute(timestamp.longValue(), callStackQuark);
            return;
        }
        ssb.pushAttribute(timestamp.longValue(), (Object)message, callStackQuark);
    }
}

