/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.internal.ctf.core.utils.LEB128;

@NonNullByDefault
public final class IntegerDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private static final int SIZE_64 = 64;
    private static final int SIZE_32 = 32;
    private static final int SIZE_27 = 27;
    private static final int SIZE_16 = 16;
    private static final int SIZE_8 = 8;
    private static final int SIZE_5 = 5;
    private static final int BYTE_ALIGN = 8;
    private static final int BASE_10 = 10;
    public static final IntegerDeclaration UINT_32B_DECL = new IntegerDeclaration(32, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_32L_DECL = new IntegerDeclaration(32, false, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration INT_32B_DECL = new IntegerDeclaration(32, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_32L_DECL = new IntegerDeclaration(32, true, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration UINT_64B_DECL = new IntegerDeclaration(64, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_64L_DECL = new IntegerDeclaration(64, false, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration INT_64B_DECL = new IntegerDeclaration(64, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_64L_DECL = new IntegerDeclaration(64, true, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration UINT_8_DECL = new IntegerDeclaration(8, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_8_DECL = new IntegerDeclaration(8, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_5B_DECL = new IntegerDeclaration(5, false, 10, ByteOrder.BIG_ENDIAN, Encoding.NONE, "", 1L);
    public static final IntegerDeclaration UINT_5L_DECL = new IntegerDeclaration(5, false, 10, ByteOrder.LITTLE_ENDIAN, Encoding.NONE, "", 1L);
    public static final IntegerDeclaration UINT_27B_DECL = new IntegerDeclaration(27, false, 10, ByteOrder.BIG_ENDIAN, Encoding.NONE, "", 1L);
    public static final IntegerDeclaration UINT_27L_DECL = new IntegerDeclaration(27, false, 10, ByteOrder.LITTLE_ENDIAN, Encoding.NONE, "", 1L);
    public static final IntegerDeclaration UINT_16B_DECL = new IntegerDeclaration(16, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_16L_DECL = new IntegerDeclaration(16, false, ByteOrder.LITTLE_ENDIAN);
    private final int fLength;
    private final boolean fSigned;
    private final int fBase;
    private final boolean fIsByteOrderSet;
    private final ByteOrder fByteOrder;
    private final Encoding fEncoding;
    private final long fAlignment;
    private final String fClock;
    private boolean fVarint = false;

    @Deprecated
    public static IntegerDeclaration createDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment) {
        block21: {
            block22: {
                if (!encoding.equals((Object)Encoding.NONE) || !clock.equals("") || base != 10 || byteOrder == null) break block21;
                if (alignment != 8L) break block22;
                switch (len) {
                    case 8: {
                        return signed ? INT_8_DECL : UINT_8_DECL;
                    }
                    case 16: {
                        if (!signed) {
                            if (IntegerDeclaration.isBigEndian(byteOrder)) {
                                return UINT_16B_DECL;
                            }
                            return UINT_16L_DECL;
                        }
                        break block21;
                    }
                    case 32: {
                        if (signed) {
                            if (IntegerDeclaration.isBigEndian(byteOrder)) {
                                return INT_32B_DECL;
                            }
                            return INT_32L_DECL;
                        }
                        if (IntegerDeclaration.isBigEndian(byteOrder)) {
                            return UINT_32B_DECL;
                        }
                        return UINT_32L_DECL;
                    }
                    case 64: {
                        if (signed) {
                            if (IntegerDeclaration.isBigEndian(byteOrder)) {
                                return INT_64B_DECL;
                            }
                            return INT_64L_DECL;
                        }
                        if (IntegerDeclaration.isBigEndian(byteOrder)) {
                            return UINT_64B_DECL;
                        }
                        return UINT_64L_DECL;
                    }
                }
                break block21;
            }
            if (alignment == 1L) {
                switch (len) {
                    case 5: {
                        if (signed) break;
                        if (IntegerDeclaration.isBigEndian(byteOrder)) {
                            return UINT_5B_DECL;
                        }
                        return UINT_5L_DECL;
                    }
                    case 27: {
                        if (signed) break;
                        if (IntegerDeclaration.isBigEndian(byteOrder)) {
                            return UINT_27B_DECL;
                        }
                        return UINT_27L_DECL;
                    }
                }
            }
        }
        return new IntegerDeclaration(len, signed, base, byteOrder, encoding, clock, alignment);
    }

    public static IntegerDeclaration createDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment, @Nullable String role) {
        block21: {
            block22: {
                if (!encoding.equals((Object)Encoding.NONE) || !clock.equals("") || base != 10 || byteOrder == null) break block21;
                if (alignment != 8L) break block22;
                switch (len) {
                    case 8: {
                        return signed ? INT_8_DECL : UINT_8_DECL;
                    }
                    case 16: {
                        if (!signed) {
                            if (IntegerDeclaration.isBigEndian(byteOrder)) {
                                return UINT_16B_DECL;
                            }
                            return UINT_16L_DECL;
                        }
                        break block21;
                    }
                    case 32: {
                        if (signed) {
                            if (IntegerDeclaration.isBigEndian(byteOrder)) {
                                return INT_32B_DECL;
                            }
                            return INT_32L_DECL;
                        }
                        if (IntegerDeclaration.isBigEndian(byteOrder)) {
                            return UINT_32B_DECL;
                        }
                        return UINT_32L_DECL;
                    }
                    case 64: {
                        if (signed) {
                            if (IntegerDeclaration.isBigEndian(byteOrder)) {
                                return INT_64B_DECL;
                            }
                            return INT_64L_DECL;
                        }
                        if (IntegerDeclaration.isBigEndian(byteOrder)) {
                            return UINT_64B_DECL;
                        }
                        return UINT_64L_DECL;
                    }
                }
                break block21;
            }
            if (alignment == 1L) {
                switch (len) {
                    case 5: {
                        if (signed) break;
                        if (IntegerDeclaration.isBigEndian(byteOrder)) {
                            return UINT_5B_DECL;
                        }
                        return UINT_5L_DECL;
                    }
                    case 27: {
                        if (signed) break;
                        if (IntegerDeclaration.isBigEndian(byteOrder)) {
                            return UINT_27B_DECL;
                        }
                        return UINT_27L_DECL;
                    }
                }
            }
        }
        return new IntegerDeclaration(len, signed, base, byteOrder, encoding, clock, alignment, role);
    }

    public static IntegerDeclaration createVarintDeclaration(boolean signed, int base, @Nullable String role, boolean varint) {
        IntegerDeclaration decl = new IntegerDeclaration(0, signed, base, null, Encoding.NONE, "", 0L);
        decl.setRole(role);
        decl.setVarint(varint);
        return decl;
    }

    private static boolean isBigEndian(@Nullable ByteOrder byteOrder) {
        return byteOrder != null && byteOrder.equals(ByteOrder.BIG_ENDIAN);
    }

    private IntegerDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment) {
        this.fLength = len;
        this.fSigned = signed;
        this.fBase = base;
        this.fIsByteOrderSet = byteOrder != null;
        this.fByteOrder = byteOrder == null ? ByteOrder.nativeOrder() : byteOrder;
        this.fEncoding = encoding;
        this.fClock = clock;
        this.fAlignment = Math.max(alignment, 1L);
    }

    private IntegerDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment, @Nullable String role) {
        this(len, signed, base, byteOrder, encoding, clock, alignment);
        this.setRole(role);
    }

    private IntegerDeclaration(int len, boolean signed, @Nullable ByteOrder byteOrder) {
        this(len, signed, 10, byteOrder, Encoding.NONE, "", 8L, null);
    }

    public boolean isSigned() {
        return this.fSigned;
    }

    public boolean isVarint() {
        return this.fVarint;
    }

    private void setVarint(boolean varint) {
        this.fVarint = varint;
    }

    public int getBase() {
        return this.fBase;
    }

    @Override
    public boolean isByteOrderSet() {
        return this.fIsByteOrderSet;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public Encoding getEncoding() {
        return this.fEncoding;
    }

    public boolean isCharacter() {
        return this.fLength == 8 && this.fEncoding != Encoding.NONE;
    }

    public boolean isUnsignedByte() {
        return this.fLength == 8 && !this.fSigned;
    }

    public int getLength() {
        return this.fLength;
    }

    @Override
    public long getAlignment() {
        return this.fAlignment;
    }

    public String getClock() {
        return this.fClock;
    }

    @Override
    public int getMaximumSize() {
        return this.fLength;
    }

    @Override
    public IntegerDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        ByteOrder byteOrder = input.getByteOrder();
        input.setByteOrder(this.fByteOrder);
        long value = this.read(input);
        input.setByteOrder(byteOrder);
        return new IntegerDefinition(this, definitionScope, fieldName, value);
    }

    public String toString() {
        return "[declaration] integer[length:" + this.fLength + (this.fSigned ? " " : " un") + "signed base:" + this.fBase + " byteOrder:" + String.valueOf(this.fByteOrder) + " encoding:" + String.valueOf((Object)this.fEncoding) + " alignment:" + this.fAlignment + "  clock:" + this.fClock + "]";
    }

    public BigInteger getMaxValue() {
        int significantBits = this.fLength - (this.fSigned ? 1 : 0);
        return Objects.requireNonNull(BigInteger.ONE.shiftLeft(significantBits).subtract(BigInteger.ONE));
    }

    public BigInteger getMinValue() {
        if (!this.fSigned) {
            return Objects.requireNonNull(BigInteger.ZERO);
        }
        int significantBits = this.fLength - 1;
        return Objects.requireNonNull(BigInteger.ONE.shiftLeft(significantBits).negate());
    }

    private long read(BitBuffer input) throws CTFException {
        if (this.isVarint()) {
            if (this.isSigned()) {
                return LEB128.readSignedLeb(input);
            }
            return LEB128.readUnsignedLeb(input);
        }
        this.alignRead(input);
        boolean signed = this.isSigned();
        int length = this.getLength();
        long bits = 0L;
        ByteOrder previousByteOrder = input.getByteOrder();
        if (this.getByteOrder() != input.getByteOrder()) {
            input.setByteOrder(this.getByteOrder());
        }
        if (length > 64) {
            throw new CTFException("Cannot read an integer with over 64 bits. Length given: " + length);
        }
        bits = input.get(length, signed);
        if (previousByteOrder != input.getByteOrder()) {
            input.setByteOrder(previousByteOrder);
        }
        return bits;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.fAlignment ^ this.fAlignment >>> 32);
        result = 31 * result + this.fBase;
        result = 31 * result + this.fByteOrder.toString().hashCode();
        result = 31 * result + this.fClock.hashCode();
        result = 31 * result + this.fEncoding.hashCode();
        result = 31 * result + this.fLength;
        result = 31 * result + (this.fSigned ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerDeclaration other = (IntegerDeclaration)obj;
        if (!this.isBinaryEquivalent(other)) {
            return false;
        }
        if (!this.fByteOrder.equals(other.fByteOrder)) {
            return false;
        }
        if (!this.fClock.equals(other.fClock)) {
            return false;
        }
        if (this.fEncoding != other.fEncoding) {
            return false;
        }
        return this.fBase == other.fBase;
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerDeclaration other = (IntegerDeclaration)obj;
        return this.isBinaryEquivalent(other);
    }

    private boolean isBinaryEquivalent(IntegerDeclaration other) {
        if (this.fAlignment != other.fAlignment) {
            return false;
        }
        if (this.fLength != other.fLength) {
            return false;
        }
        if (this.fSigned != other.fSigned) {
            return false;
        }
        return this.fLength == 8 || this.fByteOrder.equals(other.fByteOrder);
    }
}

