/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.python.bouncycastle.asn1.ASN1Integer;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.ASN1Primitive;
import org.python.bouncycastle.asn1.ASN1Sequence;
import org.python.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.python.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.python.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import org.python.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import org.python.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import org.python.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import org.python.bouncycastle.pqc.jcajce.spec.McElieceCCA2PrivateKeySpec;
import org.python.bouncycastle.pqc.jcajce.spec.McElieceCCA2PublicKeySpec;

public class McElieceCCA2KeyFactorySpi
extends KeyFactorySpi {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2";

    public PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof McElieceCCA2PublicKeySpec) {
            return new BCMcElieceCCA2PublicKey((McElieceCCA2PublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            try {
                subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.toString());
            }
            try {
                ASN1Primitive aSN1Primitive = subjectPublicKeyInfo.parsePublicKey();
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
                String string = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).toString();
                BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
                int n = bigInteger.intValue();
                BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getValue();
                int n2 = bigInteger2.intValue();
                byte[] byArray2 = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
                return new BCMcElieceCCA2PublicKey(new McElieceCCA2PublicKeySpec(OID, n, n2, byArray2));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec: " + iOException.getMessage());
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec.getClass() + ".");
    }

    public PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof McElieceCCA2PrivateKeySpec) {
            return new BCMcElieceCCA2PrivateKey((McElieceCCA2PrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PrivateKeyInfo privateKeyInfo;
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            try {
                privateKeyInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec: " + iOException);
            }
            try {
                ASN1Primitive aSN1Primitive = privateKeyInfo.parsePrivateKey().toASN1Primitive();
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
                String string = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).toString();
                BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
                int n = bigInteger.intValue();
                BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getValue();
                int n2 = bigInteger2.intValue();
                byte[] byArray2 = ((ASN1OctetString)aSN1Sequence.getObjectAt(3)).getOctets();
                byte[] byArray3 = ((ASN1OctetString)aSN1Sequence.getObjectAt(4)).getOctets();
                byte[] byArray4 = ((ASN1OctetString)aSN1Sequence.getObjectAt(5)).getOctets();
                byte[] byArray5 = ((ASN1OctetString)aSN1Sequence.getObjectAt(6)).getOctets();
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(7);
                byte[][] byArrayArray = new byte[aSN1Sequence2.size()][];
                for (int i = 0; i < aSN1Sequence2.size(); ++i) {
                    byArrayArray[i] = ((ASN1OctetString)aSN1Sequence2.getObjectAt(i)).getOctets();
                }
                return new BCMcElieceCCA2PrivateKey(new McElieceCCA2PrivateKeySpec(OID, n, n2, byArray2, byArray3, byArray4, byArray5, byArrayArray));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec.getClass() + ".");
    }

    public KeySpec getKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof BCMcElieceCCA2PrivateKey) {
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if (McElieceCCA2PrivateKeySpec.class.isAssignableFrom(clazz)) {
                BCMcElieceCCA2PrivateKey bCMcElieceCCA2PrivateKey = (BCMcElieceCCA2PrivateKey)key;
                return new McElieceCCA2PrivateKeySpec(OID, bCMcElieceCCA2PrivateKey.getN(), bCMcElieceCCA2PrivateKey.getK(), bCMcElieceCCA2PrivateKey.getField(), bCMcElieceCCA2PrivateKey.getGoppaPoly(), bCMcElieceCCA2PrivateKey.getP(), bCMcElieceCCA2PrivateKey.getH(), bCMcElieceCCA2PrivateKey.getQInv());
            }
        } else if (key instanceof BCMcElieceCCA2PublicKey) {
            if (X509EncodedKeySpec.class.isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if (McElieceCCA2PublicKeySpec.class.isAssignableFrom(clazz)) {
                BCMcElieceCCA2PublicKey bCMcElieceCCA2PublicKey = (BCMcElieceCCA2PublicKey)key;
                return new McElieceCCA2PublicKeySpec(OID, bCMcElieceCCA2PublicKey.getN(), bCMcElieceCCA2PublicKey.getT(), bCMcElieceCCA2PublicKey.getG());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
    }

    public Key translateKey(Key key) throws InvalidKeyException {
        if (key instanceof BCMcElieceCCA2PrivateKey || key instanceof BCMcElieceCCA2PublicKey) {
            return key;
        }
        throw new InvalidKeyException("Unsupported key type.");
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws InvalidKeySpecException {
        try {
            ASN1Primitive aSN1Primitive = subjectPublicKeyInfo.parsePublicKey();
            McElieceCCA2PublicKey mcElieceCCA2PublicKey = McElieceCCA2PublicKey.getInstance((ASN1Sequence)aSN1Primitive);
            return new BCMcElieceCCA2PublicKey(mcElieceCCA2PublicKey.getOID().getId(), mcElieceCCA2PublicKey.getN(), mcElieceCCA2PublicKey.getT(), mcElieceCCA2PublicKey.getG());
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec");
        }
    }

    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws InvalidKeySpecException {
        try {
            ASN1Primitive aSN1Primitive = privateKeyInfo.parsePrivateKey().toASN1Primitive();
            McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = McElieceCCA2PrivateKey.getInstance(aSN1Primitive);
            return new BCMcElieceCCA2PrivateKey(mcElieceCCA2PrivateKey.getOID().getId(), mcElieceCCA2PrivateKey.getN(), mcElieceCCA2PrivateKey.getK(), mcElieceCCA2PrivateKey.getField(), mcElieceCCA2PrivateKey.getGoppaPoly(), mcElieceCCA2PrivateKey.getP(), mcElieceCCA2PrivateKey.getH(), mcElieceCCA2PrivateKey.getQInv());
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec");
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return null;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return null;
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return null;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }
}

