/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.core.data.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.scripting.core.data.provider.ScriptedEntryDataModel;
import org.eclipse.tracecompass.incubator.internal.scripting.core.data.provider.ScriptedTimeGraphDataProvider;
import org.eclipse.tracecompass.incubator.internal.scripting.core.data.provider.ScriptingDataProviderManager;
import org.eclipse.tracecompass.incubator.scripting.core.analysis.ScriptedAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenTimeGraphProviderFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenXYDataProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenXYProviderFactory;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DataProviderScriptingModule {
    @WrapToScript
    public static final String ENTRY_PATH = "path";
    @WrapToScript
    public static final String ENTRY_DISPLAY = "display";
    @WrapToScript
    public static final String ENTRY_NAME = "name";
    @WrapToScript
    public static final String ENTRY_PARENT = "parent";
    @WrapToScript
    public static final String ENTRY_ID = "id";
    @WrapToScript
    public static final String ENTRY_DELTA = "delta";
    @WrapToScript
    public static final String ENTRY_FIELD_QUARK = "quark";
    @WrapToScript
    public static final String ENTRY_FIELD_PARENT_ID = "parentId";

    @WrapToScript
    public @Nullable ITimeGraphDataProvider<TimeGraphEntryModel> createTimeGraphProvider(IAnalysisModule analysis, Map<String, Object> data, @ScriptParameter(defaultValue="") String dpName) {
        ITmfAnalysisModuleWithStateSystems module;
        ITmfTrace trace = null;
        if (analysis instanceof TmfAbstractAnalysisModule) {
            TmfAbstractAnalysisModule newAnalysis = (TmfAbstractAnalysisModule)analysis;
            trace = newAnalysis.getTrace();
        }
        ArrayList<ITmfStateSystem> stateSystems = new ArrayList<ITmfStateSystem>();
        if (analysis instanceof ITmfAnalysisModuleWithStateSystems && (module = (ITmfAnalysisModuleWithStateSystems)analysis).schedule().isOK() && module.waitForInitialization()) {
            module.getStateSystems().forEach(stateSystems::add);
        }
        if (stateSystems.isEmpty() || trace == null) {
            return null;
        }
        String dataProviderName = dpName.isEmpty() ? String.valueOf(analysis.getName()) : dpName;
        return DataProviderScriptingModule.createTimeGraphProvider(trace, stateSystems, dataProviderName, data);
    }

    @WrapToScript
    public @Nullable ITimeGraphDataProvider<TimeGraphEntryModel> createTimeGraphProvider(ScriptedAnalysis analysis, Map<String, Object> data, @ScriptParameter(defaultValue="") String dpName) {
        ITmfStateSystemBuilder stateSystem = analysis.getStateSystem(true);
        if (stateSystem == null) {
            return null;
        }
        String dataProviderName = dpName.isEmpty() ? String.valueOf(analysis.getName()) : dpName;
        return DataProviderScriptingModule.createTimeGraphProvider(analysis.getTrace(), Collections.singletonList(stateSystem), dataProviderName, data);
    }

    private static @Nullable ITimeGraphDataProvider<TimeGraphEntryModel> createTimeGraphProvider(ITmfTrace trace, List<ITmfStateSystem> stateSystems, String analysisName, Map<String, Object> data) {
        Object pathObj = data.get(ENTRY_PATH);
        if (pathObj == null) {
            return null;
        }
        String path = String.valueOf(pathObj);
        Object displayObj = data.get(ENTRY_DISPLAY);
        DataDrivenStateSystemPath display = new DataDrivenStateSystemPath(displayObj == null ? Collections.emptyList() : Collections.singletonList(new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)String.valueOf(displayObj))));
        Object nameObj = data.get(ENTRY_NAME);
        DataDrivenStateSystemPath name = nameObj == null ? null : new DataDrivenStateSystemPath(Collections.singletonList(new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)String.valueOf(nameObj))));
        Object parentObj = data.get(ENTRY_PARENT);
        DataDrivenStateSystemPath parent = parentObj == null ? null : new DataDrivenStateSystemPath(Collections.singletonList(new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)String.valueOf(parentObj))));
        Object idObj = data.get(ENTRY_ID);
        DataDrivenStateSystemPath id = new DataDrivenStateSystemPath(Collections.singletonList(new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)String.valueOf(idObj))));
        DataDrivenOutputEntry entry = new DataDrivenOutputEntry(Collections.emptyList(), path, null, true, display, id, parent, name, DataDrivenXYDataProvider.DisplayType.ABSOLUTE);
        ITimeGraphDataProvider provider = DataDrivenTimeGraphProviderFactory.create((ITmfTrace)trace, stateSystems, Collections.singletonList(entry), Collections.emptyList(), (String)("org.eclipse.tracecompass.incubator.scripting.dataprovider:" + analysisName));
        ScriptingDataProviderManager.getInstance().registerDataProvider(trace, (ITmfTreeDataProvider<? extends ITmfTreeDataModel>)provider);
        return provider;
    }

    @WrapToScript
    public @Nullable ITmfTreeXYDataProvider<ITmfTreeDataModel> createXYProvider(IAnalysisModule analysis, Map<String, Object> data, @ScriptParameter(defaultValue="") String dpName) {
        ITmfAnalysisModuleWithStateSystems module;
        ITmfTrace trace = null;
        if (analysis instanceof TmfAbstractAnalysisModule) {
            TmfAbstractAnalysisModule newAnalysis = (TmfAbstractAnalysisModule)analysis;
            trace = newAnalysis.getTrace();
        }
        ArrayList<ITmfStateSystem> stateSystems = new ArrayList<ITmfStateSystem>();
        if (analysis instanceof ITmfAnalysisModuleWithStateSystems && (module = (ITmfAnalysisModuleWithStateSystems)analysis).schedule().isOK() && module.waitForInitialization()) {
            module.getStateSystems().forEach(stateSystems::add);
        }
        if (stateSystems.isEmpty() || trace == null) {
            return null;
        }
        String dataProviderName = dpName.isEmpty() ? String.valueOf(analysis.getName()) : dpName;
        return DataProviderScriptingModule.createXYProvider(trace, stateSystems, dataProviderName, data);
    }

    @WrapToScript
    public @Nullable ITmfTreeXYDataProvider<ITmfTreeDataModel> createXYProvider(ScriptedAnalysis analysis, Map<String, Object> data, @ScriptParameter(defaultValue="") String dpName) {
        ITmfStateSystemBuilder stateSystem = analysis.getStateSystem(true);
        if (stateSystem == null) {
            return null;
        }
        String dataProviderName = dpName.isEmpty() ? String.valueOf(analysis.getName()) : dpName;
        return DataProviderScriptingModule.createXYProvider(analysis.getTrace(), Collections.singletonList(stateSystem), dataProviderName, data);
    }

    private static @Nullable ITmfTreeXYDataProvider<ITmfTreeDataModel> createXYProvider(ITmfTrace trace, List<ITmfStateSystem> stateSystems, String analysisName, Map<String, Object> data) {
        Object pathObj = data.get(ENTRY_PATH);
        if (pathObj == null) {
            return null;
        }
        String path = String.valueOf(pathObj);
        Object displayObj = data.get(ENTRY_DISPLAY);
        DataDrivenStateSystemPath display = new DataDrivenStateSystemPath(displayObj == null ? Collections.emptyList() : Collections.singletonList(new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)String.valueOf(displayObj))));
        Object nameObj = data.get(ENTRY_NAME);
        DataDrivenStateSystemPath name = nameObj == null ? null : new DataDrivenStateSystemPath(Collections.singletonList(new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)String.valueOf(nameObj))));
        Object parentObj = data.get(ENTRY_PARENT);
        DataDrivenStateSystemPath parent = parentObj == null ? null : new DataDrivenStateSystemPath(Collections.singletonList(new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)String.valueOf(parentObj))));
        Object idObj = data.get(ENTRY_ID);
        DataDrivenStateSystemPath id = new DataDrivenStateSystemPath(Collections.singletonList(new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)String.valueOf(idObj))));
        Object isDeltaObj = data.get(ENTRY_DELTA);
        DataDrivenXYDataProvider.DisplayType displayType = DataDrivenXYDataProvider.DisplayType.ABSOLUTE;
        if (isDeltaObj != null && ((Boolean)isDeltaObj).booleanValue()) {
            displayType = DataDrivenXYDataProvider.DisplayType.DELTA;
        }
        DataDrivenOutputEntry entry = new DataDrivenOutputEntry(Collections.emptyList(), path, null, true, display, id, parent, name, displayType);
        ITmfTreeXYDataProvider provider = DataDrivenXYProviderFactory.create((ITmfTrace)trace, stateSystems, Collections.singletonList(entry), (String)("org.eclipse.tracecompass.incubator.scripting.dataprovider:" + analysisName));
        ScriptingDataProviderManager.getInstance().registerDataProvider(trace, (ITmfTreeDataProvider<? extends ITmfTreeDataModel>)provider);
        return provider;
    }

    @WrapToScript
    public @Nullable ITmfTreeDataModel createEntry(String name, Map<String, Object> data) {
        Object quarkObj = data.get(ENTRY_FIELD_QUARK);
        int quark = !(quarkObj instanceof Number) ? -2 : ((Number)quarkObj).intValue();
        Object parentObj = data.get(ENTRY_FIELD_PARENT_ID);
        int parent = !(parentObj instanceof Number) ? -1 : ((Number)parentObj).intValue();
        return new ScriptedEntryDataModel(name, parent, quark);
    }

    @WrapToScript
    public @Nullable ITimeGraphArrow createArrow(long sourceId, long destinationId, long time, long duration, int value) {
        return new TimeGraphArrow(sourceId, destinationId, time, duration, value);
    }

    @WrapToScript
    public ITimeGraphDataProvider<ITimeGraphEntryModel> createScriptedTimeGraphProvider(ScriptedAnalysis analysis, Function<Map<String, Object>, @Nullable List<ITimeGraphEntryModel>> entryMethod, @Nullable Function<Map<String, Object>, @Nullable List<ITimeGraphRowModel>> rowModelMethod, @Nullable Function<Map<String, Object>, @Nullable List<ITimeGraphArrow>> arrowMethod) {
        ScriptedTimeGraphDataProvider provider = new ScriptedTimeGraphDataProvider(analysis, entryMethod, rowModelMethod, arrowMethod);
        ScriptingDataProviderManager.getInstance().registerDataProvider(analysis.getTrace(), (ITmfTreeDataProvider<? extends ITmfTreeDataModel>)provider);
        return provider;
    }
}

